package com.ejianc.integration.sdbjmaterial.util;

import com.ejianc.integration.sdbjmaterial.workflow.Flow;
import com.ejianc.integration.sdbjmaterial.workflow.Item;
import com.ejianc.integration.sdbjmaterial.workflow.Node;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.*;

import java.util.*;

public class XmlUtils {
	
	public static void main(String[] args) {
		String xmlContent = "<process name=\"8abc662a4cd6bce1014cdb06579e1bec\" displayName=\"PM_物资领用出库\"><end layout=\"560,80,50,50\" name=\"end\"></end><task layout=\"279,94,100,50\" name=\"rect3r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect4r1\" name=\"path3r1\" /></task><task layout=\"279,94,100,50\" name=\"rect4r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"end\" name=\"path4r1\" /></task><task layout=\"279,94,100,50\" name=\"rect2r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect3r1\" name=\"path2r1\" /></task><start layout=\"28,79,50,50\" name=\"start\"><transition offset=\"0,-10\" to=\"rect1r1\" name=\"path1\" /></start><task layout=\"130,90,100,50\" name=\"rect1r1\" displayName=\"项目库管员\" form=\"8abc662a50d343ac0150d6bcc3697af4\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect2r1\" name=\"path1r1\" /></task></process>";

		Flow flow = parse(xmlContent);
		flow.getNodes().get(0).getItem().setMan("guoming");
		flow.getNodes().get(0).getItem().setManid("9999999999999999999999999");

		System.out.println(flow);

		System.out.println(convertXml(flow));
	}
	
	/**
	 * 流程实体转xml
	 * 
	 * @param flow
	 * @return
	 */
	public static String convertXml(Flow flow) {
		String xml = "<?xml version=\"1.0\"?><flow name=\""+flow.getName()+"\" isedit=\""+flow.getIsedit()+"\">";
		if(flow.getNodes() != null && flow.getNodes().size() > 0) {
			for(Node node:flow.getNodes()) {
				Item item = node.getItem();
				xml += "<node orders=\""+node.getOrders()+"\">";
				if(StringUtils.isNotBlank(item.getMan())) {
					xml += "<item orders=\""+item.getOrders()+"\" man=\""+item.getMan()+"\" manid=\""+item.getManid()+"\" handlemode=\""+item.getHandlemode()+"\" roleid=\""+item.getRoleid()+"\" rolename=\""+item.getRolename()+"\"/>";
				}else{
					xml += "<item orders=\""+item.getOrders()+"\" man=\"\" manid=\"\" handlemode=\""+item.getHandlemode()+"\" roleid=\""+item.getRoleid()+"\" rolename=\""+item.getRolename()+"\"/>";
				}
				xml += "</node>";
			}
		}
		xml += "</flow>";
		return xml;
	}

	public static String updateProcessXml(Flow newFlow, String oldContent) {
		try {
			Document document = DocumentHelper.parseText(oldContent.trim());
			Element rootElement = document.getRootElement();
			Element startElements = rootElement.element("start");
			if(null == startElements) {
				return document.asXML();
			}
			List<Node> nodes = newFlow.getNodes();
			Map<String, Node> nodeMap = new HashMap<>();
			for(Node node : nodes) {
				nodeMap.put(node.getItem().getUnicField(), node);
			}
			List<Element> taskElements = rootElement.elements("task");
			Node tmpNode = null;
			Attribute assignee = null;
			Attribute assigneeDisplay = null;
			for(Element taskElement : taskElements) {
				tmpNode = nodeMap.get(taskElement.attributeValue("name"));
				if(null != tmpNode) {
					assignee = taskElement.attribute("assignee");
					assigneeDisplay = taskElement.attribute("assigneeDisplay");
					if(null == assignee) {
                        taskElement.addAttribute("assignee", tmpNode.getItem().getManid());
                    } else {
                        assignee.setValue(tmpNode.getItem().getManid());
                    }
					if(null == assigneeDisplay) {
                        taskElement.addAttribute("assigneeDisplay", tmpNode.getItem().getMan());
                    } else {
                        assigneeDisplay.setValue(tmpNode.getItem().getMan());
                    }
				}
			}

			return document.asXML().replaceAll("\n", "");
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * 流程xml转实体
	 * 
	 * @param xmlContent
	 * @return
	 */
	public static Flow parse(String xmlContent) {
		try {
			Document document = DocumentHelper.parseText(xmlContent.trim());
			Element rootElement = document.getRootElement();
			Flow flow = new Flow();
			flow.setProcessid(rootElement.attributeValue("name"));
			flow.setName(rootElement.attributeValue("displayName"));
			flow.setIsedit(true);

			Element startElements = rootElement.element("start");
			List<Node> nodes = null;
			if(null == startElements) {
				nodes = new ArrayList<>();
			} else {
				nodes = toNodeList(rootElement);
			}
			flow.setNodes(nodes);

			return flow;
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		return null;
	}

	private static List<Node> toNodeList(Element element) {
		List<Node> nodes = new ArrayList<Node>();
		Element startElements = element.element("start");
		if(null == startElements) {
			return nodes;
		}
		String toName = startElements.element("transition").attributeValue("to");
		
		List<Element> taskElements = element.elements("task");
		for(Element taskElement:taskElements) {
			if(toName.equals(taskElement.attributeValue("name"))){
				taskElements.remove(taskElement);
				
				loopNodes(taskElements,nodes,taskElement);
				break;
			}
		}
		
		return nodes;
	}
	
	
	private static void loopNodes(List<Element> taskElements, List<Node> nodes,Element element) {
		String toName = element.element("transition").attributeValue("to");
		
		Node node = new Node();
		Item item = new Item();
		item.setOrders(nodes.size()+1);
		if(StringUtils.isNotBlank(element.attributeValue("assignee"))) {
			item.setMan(element.attributeValue("assigneeDisplay"));
			item.setManid(element.attributeValue("assignee"));
		}
		item.setHandlemode("1");
		item.setRoleid(element.attributeValue("form"));
		item.setRolename(element.attributeValue("displayName"));
		item.setUnicField(element.attributeValue("name"));
		node.setItem(item);
		node.setOrders(nodes.size()+1);
		nodes.add(node);
		
		if(!"end".equals(toName)) {
			for(Element taskElement:taskElements) {
				if(toName.equals(taskElement.attributeValue("name"))){
					taskElements.remove(taskElement);

					loopNodes(taskElements, nodes,taskElement);
					break;
				}
			}
		}
	}
}
