package com.ejianc.integration.sdbjmaterial.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.integration.sdbjmaterial.vo.OutstoreDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 领料出库实体
 * 
 * @author generator
 * 
 */
public class OutstoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String engineering; // 工程名称
    private String projectManager; // 项目经理
    private String projectAddress; // 项目地址
    private String memo; // 备注
    private String subContractId; // 分包合同id
    private String subContractName; // 分包合同名称
    private String mainContractName; // 主合同名称
    private String mainContractId; // 主合同id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String projectId; // 项目id
    private String projectSourceId; // 八局项目id
    private String devProjectName; // 研发项目名称
    private String devProjectId; // 研发项目id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date outDate; // 出库日期
    private String senderId; // 发料人id
    private String sender; // 发料人
    private String otherSideProcessor; // 对方经办人
    private BigDecimal totalAmount; // 出库金额
    private String allocationInUnitName; // 调入单位名称
    private String allocationInUnitId; // 调入单位id
    private String outTypeName; // 出库单l类别名称
    private String outType; // 出库单l类别
    private String name; // 出库单名称
    private String billCode; // 出库单编号
    private Integer billState; // 单据状态
    private String useForName;
    private String useFor;
    private String warehouseName; // 仓库名称
    private String warehouseId; // 仓库id
    private String allocationInUnitType; // 调入单位类型
    private String opid; // 八局单据id
    private String processid; // 八局 提交流程id
    private Boolean materialVerification;
    
    private List<OutstoreDetailVO> outstoreDetailEntities = new ArrayList<>(); // 领料出库子表

    public String getAllocationInUnitType() {
        return allocationInUnitType;
    }

    public void setAllocationInUnitType(String allocationInUnitType) {
        this.allocationInUnitType = allocationInUnitType;
    }

    public String getOpid() {
        return opid;
    }

    public void setOpid(String opid) {
        this.opid = opid;
    }

    public String getProcessid() {
        return processid;
    }

    public void setProcessid(String processid) {
        this.processid = processid;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getUseForName() {
        return useForName;
    }

    public void setUseForName(String useForName) {
        this.useForName = useForName;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    /**
     * 工程名称
     */
    public String getEngineering() {
        return engineering;
    }

    /**
     * 工程名称
     */
    public void setEngineering(String engineering) {
        this.engineering = engineering;
    }
    /**
     * 项目经理
     */
    public String getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目地址
     */
    public String getProjectAddress() {
        return projectAddress;
    }

    /**
     * 项目地址
     */
    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 分包合同id
     */
    public String getSubContractId() {
        return subContractId;
    }

    /**
     * 分包合同id
     */
    public void setSubContractId(String subContractId) {
        this.subContractId = subContractId;
    }
    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同id
     */
    public String getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同id
     */
    public void setMainContractId(String mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    public String getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    /**
     * 出库日期
     */
    public java.util.Date getOutDate() {
        return outDate;
    }

    /**
     * 出库日期
     */
    public void setOutDate(java.util.Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 发料人id
     */
    public String getSenderId() {
        return senderId;
    }

    /**
     * 发料人id
     */
    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }
    /**
     * 发料人
     */
    public String getSender() {
        return sender;
    }

    /**
     * 发料人
     */
    public void setSender(String sender) {
        this.sender = sender;
    }
    /**
     * 对方经办人
     */
    public String getOtherSideProcessor() {
        return otherSideProcessor;
    }

    /**
     * 对方经办人
     */
    public void setOtherSideProcessor(String otherSideProcessor) {
        this.otherSideProcessor = otherSideProcessor;
    }
    /**
     * 出库金额
     */
    public java.math.BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * 出库金额
     */
    public void setTotalAmount(java.math.BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    /**
     * 出库单l类别名称
     */
    public String getOutTypeName() {
        return outTypeName;
    }

    /**
     * 出库单l类别名称
     */
    public void setOutTypeName(String outTypeName) {
        this.outTypeName = outTypeName;
    }
    /**
     * 出库单l类别
     */
    public String getOutType() {
        return outType;
    }

    /**
     * 出库单l类别
     */
    public void setOutType(String outType) {
        this.outType = outType;
    }
    /**
     * 出库单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 出库单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 出库单编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 出库单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<OutstoreDetailVO> getOutstoreDetailEntities() {
        return outstoreDetailEntities;
    }

    public void setOutstoreDetailEntities(List<OutstoreDetailVO> outstoreDetailEntities) {
        this.outstoreDetailEntities = outstoreDetailEntities;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getDevProjectName() {
        return devProjectName;
    }

    public void setDevProjectName(String devProjectName) {
        this.devProjectName = devProjectName;
    }

    public String getDevProjectId() {
        return devProjectId;
    }

    public void setDevProjectId(String devProjectId) {
        this.devProjectId = devProjectId;
    }

    public String getAllocationInUnitName() {
        return allocationInUnitName;
    }

    public void setAllocationInUnitName(String allocationInUnitName) {
        this.allocationInUnitName = allocationInUnitName;
    }

    public String getAllocationInUnitId() {
        return allocationInUnitId;
    }

    public void setAllocationInUnitId(String allocationInUnitId) {
        this.allocationInUnitId = allocationInUnitId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

	public Boolean getMaterialVerification() {
		return materialVerification;
	}

	public void setMaterialVerification(Boolean materialVerification) {
		this.materialVerification = materialVerification;
	}
    
}
