package com.ejianc.integration.sdbjmaterial.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.collect.Maps;
import groovy.util.logging.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 测试
 * </p>
 *
 * @author yqls
 * @since 2020-08-17
 */
@Slf4j
public class Test {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final static String SDBJ_SERVER_URL = "https://pm.baju.com.cn/";
    private final static String APPID = "yql001";
    private final static String ACCESS_TOKEN_URL = "slsd8j/openapi/Auth_getAccessToken.action";
    private final static String MATERIAL_BY_DETAIL_ID_URL = "slsd8j/openapi/MaterialOut_getMaterialByDetailId.action";
    private final static String MATERIAL_WARE_HOUSE_LIST_URL = "slsd8j/openapi/MaterialOut_getStorehouseList.action";
    private final static String CONTRACT_LIST_URL = "slsd8j/openapi/MaterialOut_getContractList.action";

    /** 模拟本地缓存 */
    private static final Map<String, String> localCache = Maps.newConcurrentMap();

    public static void main(String[] args) {
        try {
            Test test = new Test();
//            /** 根据扫码以后获取到的入库明细ID，获取相关库存信息 */
//            test.getMaterialByDetailId();

            JSONObject json = new JSONObject();
            json.put("type", "6");
            json.put("indetailid", "402847888ca07deb018ca4c3f7ef37e2");
            CommonResponse<JSONObject> response = test.scanQRCode(json);
            System.out.println(JSONObject.toJSONString(response));
            System.out.println(JSONObject.toJSONString(response.getData()));

        } catch (Exception e) {
            //执行失败
            System.out.println(e);
        }
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();

        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL+url;
        String reqResp =  HttpTookit.get(newUrl, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData);
    }

    /**
     * 获取水电八局服务访问Token
     *
     * @return success: Boolean,服务响应结果编码；
     *         message: String, 服务响应结果信息；
     *         data: {access_token：String，平台服务访问密钥；invalidate: DateTime，过期时间}
     */
    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String reqUrl = SDBJ_SERVER_URL + ACCESS_TOKEN_URL;

        String tokenInfo = localCache.get("access_token");
        if(StringUtils.isNotBlank(tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject(tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get("invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if(invalidateTime > curTime) {
                return tokenData;
            }
        }

        Map<String, Object> params = new HashMap<>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader(reqUrl, params);
            logger.info("获取水电八局服务访问Token服务-[地址：{}, 参数：{}]，返回结果：{}", reqUrl, JSONObject.toJSONString(params), reqRespStr);

            JSONObject reqResp = JSONObject.parseObject(reqRespStr);
            if(BooleanUtils.isNotTrue((Boolean) reqResp.get("success"))) {
                logger.error(null != reqResp.get("message") ? reqResp.get("message").toString() : "获取水电八局服务请求Token失败！");
                return null;
            }

            Map<String, Object> tokenData = (Map<String, Object>) reqResp.get("data");
            JSONObject invalidateInfo = (JSONObject) tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get("time").toString());

            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", invalidateTime);

            //放入缓存，有效时间1小时
            localCache.put("access_token", JSONObject.toJSONString(resp));

            return resp;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }

    /**
     * 根据扫码以后获取到的入库明细ID，获取相关库存信息
     *
     * @throws Exception
     */
    private void getMaterialByDetailId() throws Exception {
        Map<String, Object> params = new HashMap<>(2);
        params.put("indetailid", "402847888ca07deb018ca4c3f7ef37e1");
        params.put("intype", "8");

        CommonResponse<JSONObject> response = this.sendGetReq(MATERIAL_BY_DETAIL_ID_URL, params);
        JSONObject res = null;
        if(response.isSuccess()){
            Integer count = response.getData().getJSONObject("data").getInteger("count");
            if(count>0){
                JSONArray list =response.getData().getJSONObject("data").getJSONArray("list");
                res = list.getJSONObject(0);
            }
        }
        logger.info("---根据扫码以后获取到的入库明细ID，获取相关库存信息，请求成功！data = " + JSONObject.toJSONString(res) + "  ------------");
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/10/19 二维码内容翻译
     * @Description scanQRCode
     * @Param [data]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @PostMapping("scanQRCode")
    @ResponseBody
    public CommonResponse<JSONObject> scanQRCode(@RequestBody JSONObject data){
        JSONObject res = new JSONObject();
        if(data==null){
            return CommonResponse.error("非法数据！");
        }
        String type = data.getString("type");/*** 库存类型 */
        String indetailid = data.getString("indetailid");
        if(StringUtils.isEmpty(type) || StringUtils.isEmpty(indetailid)){
            return CommonResponse.error("参数不完整！");
        }
        try {
            JSONObject material = getSingleStore(indetailid, type);
            if(material == null){
                return CommonResponse.error("查询库存失败:不存在相关物资！");
            }
            res.put("material",material);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("查询八局库存出现异常："+e.getLocalizedMessage());
        }
        JSONObject material = res.getJSONObject("material");
        String projectSourceId = material.getString("projectid");
        String storehouseId = material.getString("storehouseid");
        String contractid = material.getString("contractid");
//        CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectBySourceId(projectSourceId);
//        if(!projectRegisterVOCommonResponse.isSuccess() || projectRegisterVOCommonResponse.getData()==null){
//            return CommonResponse.error("此项目信息尚未同步，无法识别！");
//        }
//        res.put("project",projectRegisterVOCommonResponse.getData());
        CommonResponse<JSONObject> response = getSingleWarehouse(storehouseId,projectSourceId);
        if(!response.isSuccess() || response.getData()==null){
            return CommonResponse.error(response.getMsg());
        }
        res.put("warehouse",response.getData());
        CommonResponse<JSONObject> resp = this.getContractList(projectSourceId);
        if(!resp.isSuccess() || resp.getData()==null){
            return CommonResponse.error(resp.getMsg());
        }
        JSONArray contractList = resp.getData().getJSONArray("list");
        JSONObject contract = contractList.stream().map(x->(JSONObject)x).filter(x->contractid.equals(x.getString("id"))).findFirst().orElse(null);
        res.put("contract", contract);
        return CommonResponse.success(res);
    }

    private JSONObject getSingleStore(String indetailid, String intype) throws Exception {
        Map<String, Object> params = new HashMap<>(2);
        params.put("indetailid", indetailid);
        params.put("intype", intype);
        CommonResponse<JSONObject> response = sendGetReq(MATERIAL_BY_DETAIL_ID_URL, params);
        JSONObject res = null;
        if(response.isSuccess()){
            Integer count = response.getData().getJSONObject("data").getInteger("count");
            if(count>0){
                JSONArray list =response.getData().getJSONObject("data").getJSONArray("list");
                res = list.getJSONObject(0);
            }
        }
        return res;
    }

    public CommonResponse<JSONObject> getSingleWarehouse(String storehouseId,String projectId) {
        try {
            Map<String, Object> params = new HashMap<>(2);
            params.put("houseid", storehouseId);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = sendGetReq(MATERIAL_WARE_HOUSE_LIST_URL, params);
            if(response.isSuccess()){
                JSONObject back = null;
                JSONArray list = response.getData().getJSONObject("data").getJSONArray("list");
                if(list!=null && list.size()>0 ){
                    back = list.getJSONObject(0);
                }
                return CommonResponse.success(back);
            }
            return response;
        } catch (Exception e) {
            logger.error("查询物资仓库列表异常, ", e);
            return CommonResponse.error("查询物资仓库列表失败:"+e.getLocalizedMessage());
        }
    }

    /**
     * 根据项目Id查询项目主合同信息列表
     *
     * @param projectId 项目主键Id
     * @return success: Boolean,服务响应结果编码；
     *         message: String, 服务响应结果信息；
     *         data: {list [{id: String,合同Id；name: String,合同名称；code：String,合同编号；tyname：String,合同类别；contractsignamount：Number,合同金额；signdate：Date,签约日期}, ...]}
     */
    @GetMapping(value = "contractList")
    public CommonResponse<JSONObject> getContractList(@RequestParam(value = "projectId") String projectId) {
        try {
            Map<String, Object> params = new HashMap<>(2);
            params.put("prjid", projectId);

            CommonResponse<JSONObject> response = sendGetReq(CONTRACT_LIST_URL, params);
            if(response.isSuccess()){
                JSONObject back = new JSONObject();
                back.put("list",response.getData().getJSONObject("data").get("list"));
                return CommonResponse.success(back);
            }
            return response;

        } catch (Exception e) {
            logger.error("获取目主合同信息列表异常，", e);
            return CommonResponse.error("获取目主合同信息列表失败!");
        }
    }
}