/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class Test {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SDBJ_SERVER_URL = "https://pm.baju.com.cn/";
    private static final String APPID = "yql001";
    private static final String ACCESS_TOKEN_URL = "slsd8j/openapi/Auth_getAccessToken.action";
    private static final String MATERIAL_BY_DETAIL_ID_URL = "slsd8j/openapi/MaterialOut_getMaterialByDetailId.action";
    private static final String MATERIAL_WARE_HOUSE_LIST_URL = "slsd8j/openapi/MaterialOut_getStorehouseList.action";
    private static final String CONTRACT_LIST_URL = "slsd8j/openapi/MaterialOut_getContractList.action";
    private static final Map<String, String> localCache = Maps.newConcurrentMap();

    public static void main(String[] args) {
        try {
            Test test = new Test();
            JSONObject json = new JSONObject();
            json.put("type", (Object)"6");
            json.put("indetailid", (Object)"402847888ca07deb018ca4c3f7ef37e2");
            CommonResponse<JSONObject> response = test.scanQRCode(json);
            System.out.println(JSONObject.toJSONString(response));
            System.out.println(JSONObject.toJSONString((Object)response.getData()));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.get((String)newUrl, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String reqUrl = "https://pm.baju.com.cn/slsd8j/openapi/Auth_getAccessToken.action";
        String tokenInfo = localCache.get("access_token");
        if (StringUtils.isNotBlank((CharSequence)tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject((String)tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get((Object)"invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if (invalidateTime > curTime) {
                return tokenData;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader((String)reqUrl, params);
            this.logger.info("\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u670d\u52a1-[\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(params), reqRespStr});
            JSONObject reqResp = JSONObject.parseObject((String)reqRespStr);
            if (BooleanUtils.isNotTrue((Boolean)((Boolean)reqResp.get((Object)"success")))) {
                this.logger.error(null != reqResp.get((Object)"message") ? reqResp.get((Object)"message").toString() : "\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bf7\u6c42Token\u5931\u8d25\uff01");
                return null;
            }
            Map tokenData = (Map)reqResp.get((Object)"data");
            JSONObject invalidateInfo = (JSONObject)tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get((Object)"time").toString());
            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", (Object)invalidateTime);
            localCache.put("access_token", JSONObject.toJSONString((Object)resp));
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u5f02\u5e38, ", (Throwable)e);
            return null;
        }
    }

    private void getMaterialByDetailId() throws Exception {
        Integer count;
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("indetailid", "402847888ca07deb018ca4c3f7ef37e1");
        params.put("intype", "8");
        CommonResponse<JSONObject> response = this.sendGetReq(MATERIAL_BY_DETAIL_ID_URL, params);
        JSONObject res = null;
        if (response.isSuccess() && (count = ((JSONObject)response.getData()).getJSONObject("data").getInteger("count")) > 0) {
            JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
            res = list.getJSONObject(0);
        }
        this.logger.info("---\u6839\u636e\u626b\u7801\u4ee5\u540e\u83b7\u53d6\u5230\u7684\u5165\u5e93\u660e\u7ec6ID\uff0c\u83b7\u53d6\u76f8\u5173\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + JSONObject.toJSONString(res) + "  ------------");
    }

    @PostMapping(value={"scanQRCode"})
    @ResponseBody
    public CommonResponse<JSONObject> scanQRCode(@RequestBody JSONObject data) {
        JSONObject material;
        JSONObject res = new JSONObject();
        if (data == null) {
            return CommonResponse.error((String)"\u975e\u6cd5\u6570\u636e\uff01");
        }
        String type = data.getString("type");
        String indetailid = data.getString("indetailid");
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)indetailid)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u5b8c\u6574\uff01");
        }
        try {
            material = this.getSingleStore(indetailid, type);
            if (material == null) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25:\u4e0d\u5b58\u5728\u76f8\u5173\u7269\u8d44\uff01");
            }
            res.put("material", (Object)material);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)("\u67e5\u8be2\u516b\u5c40\u5e93\u5b58\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()));
        }
        material = res.getJSONObject("material");
        String projectSourceId = material.getString("projectid");
        String storehouseId = material.getString("storehouseid");
        String contractid = material.getString("contractid");
        CommonResponse<JSONObject> response = this.getSingleWarehouse(storehouseId, projectSourceId);
        if (!response.isSuccess() || response.getData() == null) {
            return CommonResponse.error((String)response.getMsg());
        }
        res.put("warehouse", response.getData());
        CommonResponse<JSONObject> resp = this.getContractList(projectSourceId);
        if (!resp.isSuccess() || resp.getData() == null) {
            return CommonResponse.error((String)resp.getMsg());
        }
        JSONArray contractList = ((JSONObject)resp.getData()).getJSONArray("list");
        JSONObject contract = contractList.stream().map(x -> (JSONObject)x).filter(x -> contractid.equals(x.getString("id"))).findFirst().orElse(null);
        res.put("contract", (Object)contract);
        return CommonResponse.success((Object)res);
    }

    private JSONObject getSingleStore(String indetailid, String intype) throws Exception {
        Integer count;
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("indetailid", indetailid);
        params.put("intype", intype);
        CommonResponse<JSONObject> response = this.sendGetReq(MATERIAL_BY_DETAIL_ID_URL, params);
        JSONObject res = null;
        if (response.isSuccess() && (count = ((JSONObject)response.getData()).getJSONObject("data").getInteger("count")) > 0) {
            JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
            res = list.getJSONObject(0);
        }
        return res;
    }

    public CommonResponse<JSONObject> getSingleWarehouse(String storehouseId, String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("houseid", storehouseId);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = this.sendGetReq(MATERIAL_WARE_HOUSE_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject back = null;
                JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
                if (list != null && list.size() > 0) {
                    back = list.getJSONObject(0);
                }
                return CommonResponse.success(back);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5f02\u5e38, ", (Throwable)e);
            return CommonResponse.error((String)("\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5931\u8d25:" + e.getLocalizedMessage()));
        }
    }

    @GetMapping(value={"contractList"})
    public CommonResponse<JSONObject> getContractList(@RequestParam(value="projectId") String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = this.sendGetReq(CONTRACT_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject back = new JSONObject();
                back.put("list", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)back);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u76ee\u4e3b\u5408\u540c\u4fe1\u606f\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u76ee\u4e3b\u5408\u540c\u4fe1\u606f\u5217\u8868\u5931\u8d25!");
        }
    }
}

