package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yqls
 * @date 2025-05-12 14:46:36
 */
@Component
public class AZTHelper {
    private static Logger logger = LoggerFactory.getLogger(AZTHelper.class);

    private static String host;
    private static String appId;
    private static String appSecret;

    @Value("${azt.host:http://10.60.231.72:9004}")
    public void setHost(String host) {
        this.host = host;
    }

    @Value("${azt.appId:dianziqianzhang}")
    private void setAppId(String appId) {
        this.appId = appId;
    }

    @Value("${azt.appSecret:ok4XOnvBzzKr2hgPV6l426m8IU}")
    private void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    /**
     * 上传文档
     * @param billId
     * @param fileName
     * @param fileUrl
     * @param fileContent
     * @return
     */
    public static JSONObject upload(Long billId, String fileName, String fileUrl, String fileContent) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring(time, 5);
        fileUrl = StringUtils.isEmpty(fileUrl) ? "" : fileUrl;
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&businessId=" + billId);
        sign.append("&fileFormat=" + "pdf");
        sign.append("&fileName=" + fileName);
        if(StringUtils.isNotEmpty(fileContent)){
            sign.append("&fileSource=" + 4);
        } else {
            sign.append("&fileSource=" + 2);
        }
        sign.append("&fileUrl=" + fileUrl);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=" + "1.0");
        sign.append("&" + appSecret);
        // sha256加密
        String signStr = AZTHelper.getSHA256Str(sign.toString());

        Map<String, String> headers = new HashMap<>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);

        Map<String, String> params = new HashMap<>();
        params.put("fileName", fileName);
        params.put("fileSource", "2");
        params.put("fileFormat", "pdf");
        params.put("businessId", String.valueOf(billId));
        params.put("fileUrl", fileUrl);
        params.put("fileContent", fileContent);

        String url = host + "/iCloudDoc/file/v1/upload";
        JSONObject json = null;
        try {
            logger.info("下载文档url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("上传文档结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    /**
     * 下载文档
     * @param fileId
     * @return
     */
    public static JSONObject download(String fileId) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring(time, 5);
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&downType=" + 2);
        sign.append("&fileId=" + fileId);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=" + "1.0");
        sign.append("&" + appSecret);
        // sha256加密
        String signStr = AZTHelper.getSHA256Str(sign.toString());
        Map<String, String> headers = new HashMap<>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);

        Map<String, String> params = new HashMap<>();
        params.put("fileId", fileId);
        params.put("downType", "2");

        String url = host + "/iCloudDoc/file/v1/download";
        JSONObject json = null;
        try {
            logger.info("下载文档url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("下载文档结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    /**
     * 文件预览
     * @param fileId
     * @return
     */
    public static String filePreview(String fileId) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring(time, 5);
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&fileId=" + fileId);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=" + "1.0");
        sign.append("&" + appSecret);
        // sha256加密
        String signStr = AZTHelper.getSHA256Str(sign.toString());
        Map<String, String> headers = new HashMap<>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);

        Map<String, String> params = new HashMap<>();
        params.put("fileId", fileId);

        String url = host + "/iCloudDoc/file/v1/filePreview";
        JSONObject json = null;
        try {
            logger.info("文件预览url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("文件预览结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        String result = json.getString("data");
        return result;
    }

    /**
     * sha256加密
     * @param str
     * @return
     */
    private static String getSHA256Str(String str) {
        MessageDigest messageDigest;
        String encdeStr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString(hash);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static void main(String[] args) {
        JSONObject data = upload(1L, "新增出库.pdf", "https://qlh.baju.com.cn/ejc-file-web/attachment/filePreview?fileId=976898625164546094", null);
        System.out.println(JSON.toJSONString(data));
//        JSONObject data = download("F2025051309460136095202048946707");
//        System.out.println(JSON.toJSONString(data));
//        String url = filePreview("F2025051309460136095202048946707");
//        System.out.println(JSON.toJSONString(url));
//        String fileUrl = null;
//        fileUrl = StringUtils.isEmpty(fileUrl) ? "" : fileUrl;
//        StringBuilder str = new StringBuilder();
//        str.append("fileUrl" + fileUrl);
//        System.out.println(str.toString());
    }

}
