package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yqls
 * @date 2025-05-12 14:46:36
 */
@Component
public class KhxtHelper {
    private static Logger logger = LoggerFactory.getLogger(KhxtHelper.class);

    private static CacheManager cacheManager;
    private final static String KHXT_CACHE_KEY_PREFIX = "KHXT::";

    private static String host;
    private static String userName;
    private static String secretKey;

    @Value("${khxt.host:https://khxt.baju.com.cn}")
    public void setHost(String host) {
        this.host = host;
    }

    @Value("${khxt.userName:bjyql}")
    private void setUserName(String userName) {
        this.userName = userName;
    }

    @Value("${khxt.secretKey:dzqz3d5f2a9c1e74f6b8e8d0c3a7b6e5d}")
    private void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Autowired
    private void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /**
     * 获取供方token接口
     *
     * @return success: Boolean,服务响应结果编码；
     *         message: String, 服务响应结果信息；
     *         result: access_token：String，平台服务访问密钥
     */
    public static String getToken() {
        String key = KHXT_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String token = cacheManager.get(key);
        if(StringUtils.isNotBlank(token)) {
            return token;
        }

        Map<String, String> params = new HashMap<>();
        params.put("userName", userName);
        params.put("secretKey", secretKey);
        String url = host + "/gfpt/user/getToken";
        try {
            String response = HttpTookit.getAndHeader(url, params);
            logger.info("获取供方token接口-[地址：{}, 参数：{}]，返回结果：{}", url, JSONObject.toJSONString(params), response);
            JSONObject json = JSONObject.parseObject(response);
            if(BooleanUtils.isNotTrue(json.getBoolean("success"))) {
                logger.error(null != json.get("message") ? json.get("message").toString() : "获取供方token失败！");
                return null;
            }
            String result = json.getString("result");
            //放入缓存，有效时间1小时
            cacheManager.setex(key, result, 60 * 50);
            return result;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }

    /**
     * 根据主数据编码查询供应商信息和联系人数组
     * @param gscode
     * @return
     */
    public static JSONArray getYQLSupplierBasicinfo(String gscode) {
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Access-Token", getToken());

        Map<String, String> params = new HashMap<>();
        params.put("gscode", gscode);
        String url = host + "/gfptadmin/basicinfo/getYQLSupplierBasicinfo";
        try {
            String response = HttpTookit.get(url, params, headers);
            logger.info("获取供方token接口-[地址：{}, 消息头：{}，参数：{}]，返回结果：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params), response);
            JSONObject json = JSONObject.parseObject(response);
            if(BooleanUtils.isNotTrue(json.getBoolean("success"))) {
                logger.error(null != json.get("message") ? json.get("message").toString() : "获取供方token失败！");
                return new JSONArray();
            }
            JSONArray result = json.getJSONArray("result");
            return result;
        } catch (Exception e) {
            logger.error("获取供方token异常, ", e);
            return new JSONArray();
        }
    }

    public static void main(String[] args) {
        JSONArray data = getYQLSupplierBasicinfo("S2018070211");
        System.out.println(JSON.toJSONString(data));
    }

}
