/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AZTHelper {
    private static Logger logger = LoggerFactory.getLogger(AZTHelper.class);
    private static String host;
    private static String appId;
    private static String appSecret;

    @Value(value="${azt.host:http://10.60.231.72:9004}")
    public void setHost(String host) {
        AZTHelper.host = host;
    }

    @Value(value="${azt.appId:dianziqianzhang}")
    private void setAppId(String appId) {
        AZTHelper.appId = appId;
    }

    @Value(value="${azt.appSecret:ok4XOnvBzzKr2hgPV6l426m8IU}")
    private void setAppSecret(String appSecret) {
        AZTHelper.appSecret = appSecret;
    }

    public static JSONObject upload(Long billId, String fileName, String fileUrl, String fileContent) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring((String)time, (int)5);
        fileUrl = StringUtils.isEmpty((CharSequence)fileUrl) ? "" : fileUrl;
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&businessId=" + billId);
        sign.append("&fileFormat=pdf");
        sign.append("&fileName=" + fileName);
        if (StringUtils.isNotEmpty((CharSequence)fileContent)) {
            sign.append("&fileSource=4");
        } else {
            sign.append("&fileSource=2");
        }
        sign.append("&fileUrl=" + fileUrl);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=1.0");
        sign.append("&" + appSecret);
        String signStr = AZTHelper.getSHA256Str(sign.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileName", fileName);
        params.put("fileSource", "2");
        params.put("fileFormat", "pdf");
        params.put("businessId", String.valueOf(billId));
        params.put("fileUrl", fileUrl);
        params.put("fileContent", fileContent);
        String url = host + "/iCloudDoc/file/v1/upload";
        JSONObject json = null;
        try {
            logger.info("\u4e0b\u8f7d\u6587\u6863url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u4e0a\u4f20\u6587\u6863\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    public static JSONObject download(String fileId) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring((String)time, (int)5);
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&downType=2");
        sign.append("&fileId=" + fileId);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=1.0");
        sign.append("&" + appSecret);
        String signStr = AZTHelper.getSHA256Str(sign.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileId", fileId);
        params.put("downType", "2");
        String url = host + "/iCloudDoc/file/v1/download";
        JSONObject json = null;
        try {
            logger.info("\u4e0b\u8f7d\u6587\u6863url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u4e0b\u8f7d\u6587\u6863\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    public static String filePreview(String fileId) {
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring((String)time, (int)5);
        StringBuilder sign = new StringBuilder();
        sign.append("appId=" + appId);
        sign.append("&fileId=" + fileId);
        sign.append("&nonce=" + nonce);
        sign.append("&time=" + time);
        sign.append("&version=1.0");
        sign.append("&" + appSecret);
        String signStr = AZTHelper.getSHA256Str(sign.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileId", fileId);
        String url = host + "/iCloudDoc/file/v1/filePreview";
        JSONObject json = null;
        try {
            logger.info("\u6587\u4ef6\u9884\u89c8url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u6587\u4ef6\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        String result = json.getString("data");
        return result;
    }

    private static String getSHA256Str(String str) {
        String encdeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static void main(String[] args) {
        JSONObject data = AZTHelper.upload(1L, "\u65b0\u589e\u51fa\u5e93.pdf", "https://qlh.baju.com.cn/ejc-file-web/attachment/filePreview?fileId=976898625164546094", null);
        System.out.println(JSON.toJSONString((Object)data));
    }
}

