package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static java.util.stream.Collectors.joining;

/**
 * @author yqls
 * @date 2025-05-12 14:46:36
 */
@Component
public class AZTHelper {
    private static Logger logger = LoggerFactory.getLogger(AZTHelper.class);

    private static String host = "http://10.60.231.72:9004";
    private static String appId = "dianziqianzhang";
    private static String appSecret = "ok4XOnvBzzKr2hgPV6l426m8IU";
    private static String keyWord = "领料人";

    @Value("${azt.host}")
    public void setHost(String host) {
        this.host = host;
    }

    @Value("${azt.appId}")
    private void setAppId(String appId) {
        this.appId = appId;
    }

    @Value("${azt.appSecret}")
    private void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Value("${azt.keyWord}")
    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }

    /**
     * 上传文档
     * @param billId
     * @param fileName
     * @param fileUrl
     * @param fileContent
     * @return
     */
    public static JSONObject upload(Long billId, String fileName, String fileUrl, String fileContent) {
        Map<String, Object> params = new HashMap<>();
        params.put("fileName", fileName);
        String fileSource = StringUtils.isNotEmpty(fileContent) ? "4" : "2";
        params.put("fileSource", fileSource);
        params.put("fileFormat", "pdf");
        params.put("businessId", String.valueOf(billId));
        params.put("fileUrl", fileUrl);
        params.put("fileContent", fileContent);

        // 按照参数Key字母升序排列拼成成字符串
        Map<String, String> headers = getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/upload";
        JSONObject json = null;
        try {
            logger.info("上传文档url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("上传文档结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    /**
     * 下载文档
     * @param fileId
     * @return
     */
    public static JSONObject download(String fileId) {
        Map<String, Object> params = new HashMap<>();
        params.put("fileId", fileId);
        params.put("downType", "2");

        // 按照参数Key字母升序排列拼成成字符串
        Map<String, String> headers = getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/download";
        JSONObject json = null;
        try {
            logger.info("下载文档url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("下载文档结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    /**
     * 文件预览
     * @param fileId
     * @return
     */
    public static String filePreview(String fileId) {
        Map<String, Object> params = new HashMap<>();
        params.put("fileId", fileId);

        // 按照参数Key字母升序排列拼成成字符串
        Map<String, String> headers = getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/filePreview";
        JSONObject json = null;
        try {
            logger.info("文件预览url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("文件预览结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        String result = json.getString("data");
        return result;
    }

    /**
     * 签章申请
     * @param billId
     * @param fileId
     * @param userName
     * @param idCard
     * @param mobile
     * @param notifyUrl
     * @return
     */
    public static JSONObject signApply(Long billId, String fileId, String userName, String idCard, String mobile, String notifyUrl) {
        JSONObject keyword = new JSONObject();
        keyword.put("keyword", keyWord);
        JSONArray keywords = new JSONArray();
        keywords.add(keyword);
        JSONObject location = new JSONObject();
        location.put("locationType", "2");
        location.put("keywords", keywords);
        JSONObject file = new JSONObject();
        file.put("fileId", fileId);
        file.put("location", location);
        JSONArray files = new JSONArray();
        files.add(file);

        JSONObject user = new JSONObject();
        user.put("userSource", "2");
        user.put("userType", "2");
        user.put("userName", userName);
        user.put("idCard", idCard);

        JSONObject usePerson = new JSONObject();
        usePerson.put("useName", userName);
        usePerson.put("useIdCard", idCard);
//        usePerson.put("bankCardNo", bankCardNo);
        usePerson.put("mobile", mobile);
//        usePerson.put("email", email);
        JSONObject sealConfig = new JSONObject();
        sealConfig.put("getType", "0");
        sealConfig.put("usePerson", usePerson);

        Map<String, Object> params = new HashMap<>();
        params.put("serialNo ", String.valueOf(billId));
        params.put("files", files);
        params.put("user", user);
        params.put("sealConfig", sealConfig);
        params.put("notifyUrl", notifyUrl);
        params.put("willInfo", "1");// 人脸

        // 按照参数Key字母升序排列拼成成字符串
        Map<String, String> headers = getHeaders(params);
        String url = host + "/iCloudDoc/apply/v1/signApply";
        JSONObject json = null;
        try {
            logger.info("签章申请url：{}，消息头：{}，参数：{}", url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params));
            String response = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
            logger.info("签章申请结果：{}", response);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    /**
     * 按照参数Key字母升序排列拼成成字符串
     * @param params
     * @return
     */
    private static Map<String, String> getHeaders(Map<String, Object> params) {
        Map<String, Object> signMap = new HashMap<>(params);
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring(time, 5);
        signMap.put("appId", appId);
        signMap.put("time", time);
        signMap.put("nonce", nonce);
        signMap.put("version", "1.0");

        String sign = signMap.entrySet().stream().filter(x->Objects.nonNull(x.getValue())).sorted(Map.Entry.comparingByKey()).
                map(x->x.getKey()+ "=" + x.getValue()).collect(joining("&"));
        sign = sign + "&" + appSecret;
        logger.info("安证通-sign:{}", sign);
        // sha256加密
        String signStr = AZTHelper.getSHA256Str(sign);

        Map<String, String> headers = new HashMap<>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);
        return headers;
    }

    /**
     * sha256加密
     * @param str
     * @return
     */
    private static String getSHA256Str(String str) {
        MessageDigest messageDigest;
        String encdeStr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString(hash);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static void main(String[] args) {
//        JSONObject data = upload(1L, "新增出库.pdf", "https://qlh.baju.com.cn/ejc-file-web/attachment/filePreview?fileId=976898625164546094", null);
//        System.out.println(JSONObject.toJSONString(data));
//        JSONObject data = download("F2025051611263079878247037812323");
//        System.out.println(JSONObject.toJSONString(data));
//        String url = filePreview("F2025051611263079878247037812323");
//        System.out.println(JSONObject.toJSONString(url));
        JSONObject data = signApply(1L, "F2025051611263079878247037812323", "李顺", "412727199208221636", "15903993810", "https://qlh.baju.com.cn/ejc-sdbjmaterial-web/outStore/updateSignState");
        System.out.println(JSONObject.toJSONString(data));
    }

}
