/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KhxtHelper {
    private static Logger logger = LoggerFactory.getLogger(KhxtHelper.class);
    private static CacheManager cacheManager;
    private static final String KHXT_CACHE_KEY_PREFIX = "KHXT::";
    private static String host;
    private static String userName;
    private static String secretKey;

    @Value(value="${khxt.host}")
    public void setHost(String host) {
        KhxtHelper.host = host;
    }

    @Value(value="${khxt.userName}")
    private void setUserName(String userName) {
        KhxtHelper.userName = userName;
    }

    @Value(value="${khxt.secretKey}")
    private void setSecretKey(String secretKey) {
        KhxtHelper.secretKey = secretKey;
    }

    @Autowired
    private void setCacheManager(CacheManager cacheManager) {
        KhxtHelper.cacheManager = cacheManager;
    }

    public static String getToken() {
        String key = "KHXT::ACCESS_TOKEN";
        String token = (String)((Object)cacheManager.get(key));
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userName", userName);
        params.put("secretKey", secretKey);
        String url = host + "/gfpt/user/getToken";
        try {
            String response = HttpTookit.getAndHeader((String)url, params);
            logger.info("\u83b7\u53d6\u4f9b\u65b9token\u63a5\u53e3-[\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString(params), response});
            JSONObject json = JSONObject.parseObject((String)response);
            if (BooleanUtils.isNotTrue((Boolean)json.getBoolean("success"))) {
                logger.error(null != json.get((Object)"message") ? json.get((Object)"message").toString() : "\u83b7\u53d6\u4f9b\u65b9token\u5931\u8d25\uff01");
                return null;
            }
            String result = json.getString("result");
            cacheManager.setex(key, (Serializable)((Object)result), 3000);
            return result;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u5f02\u5e38, ", (Throwable)e);
            return null;
        }
    }

    public static JSONArray getYQLSupplierBasicinfo(String gscode) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Access-Token", KhxtHelper.getToken());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("gscode", gscode);
        String url = host + "/gfptadmin/basicinfo/getYQLSupplierBasicinfo";
        try {
            String response = HttpTookit.get((String)url, params, headers);
            logger.info("\u83b7\u53d6\u4f9b\u65b9token\u63a5\u53e3-[\u5730\u5740\uff1a{}, \u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params), response});
            JSONObject json = JSONObject.parseObject((String)response);
            if (BooleanUtils.isNotTrue((Boolean)json.getBoolean("success"))) {
                logger.error(null != json.get((Object)"message") ? json.get((Object)"message").toString() : "\u83b7\u53d6\u4f9b\u65b9token\u5931\u8d25\uff01");
                return new JSONArray();
            }
            JSONArray result = json.getJSONArray("result");
            return result;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4f9b\u65b9token\u5f02\u5e38, ", (Throwable)e);
            return new JSONArray();
        }
    }

    public static void main(String[] args) {
        JSONArray data = KhxtHelper.getYQLSupplierBasicinfo("S2018070211");
        System.out.println(JSON.toJSONString((Object)data));
    }

    static {
        host = "https://khxt.baju.com.cn";
        userName = "bjyql";
        secretKey = "dzqz3d5f2a9c1e74f6b8e8d0c3a7b6e5d";
    }
}

