package com.ejianc.integration.sdbjmaterial.helper;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.options.LoadState;

import java.util.Base64;

/**
 * @author yqls
 * @date 2025-05-19 16:30:04
 */
public class UrlToPDF {

    public static String toPDF(String url){
        try (Playwright playwright = Playwright.create()) {
            Browser browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(true));
            Page page = browser.newPage();

            page.navigate(url);
            page.waitForLoadState(LoadState.NETWORKIDLE);

            byte[] pdfBytes = page.pdf(new Page.PdfOptions()
                    .setFormat("A4")
                    .setPrintBackground(true));
            browser.close();
            // 转换为 Base64
            return Base64.getEncoder().encodeToString(pdfBytes);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void main(String[] args) {
        String url = "https://qlh.baju.com.cn/ejc-sdbjmaterial-mobile/#/allocationOut/costAddCard?id=977255715733246034&_k=8nwuku&userid=303581417601122400";
        String str = toPDF(url);
        System.out.println(str);
    }
}
