/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AZTHelper {
    private static Logger logger = LoggerFactory.getLogger(AZTHelper.class);
    private static String host = "http://10.60.231.72:9004";
    private static String appId = "dianziqianzhang";
    private static String appSecret = "ok4XOnvBzzKr2hgPV6l426m8IU";
    private static String keyWord = "\u9886\u6599\u4eba";

    @Value(value="${azt.host}")
    public void setHost(String host) {
        AZTHelper.host = host;
    }

    @Value(value="${azt.appId}")
    private void setAppId(String appId) {
        AZTHelper.appId = appId;
    }

    @Value(value="${azt.appSecret}")
    private void setAppSecret(String appSecret) {
        AZTHelper.appSecret = appSecret;
    }

    @Value(value="${azt.keyWord}")
    public void setKeyWord(String keyWord) {
        AZTHelper.keyWord = keyWord;
    }

    public static JSONObject upload(Long billId, String fileName, String fileUrl, String fileContent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileName", fileName);
        String fileSource = StringUtils.isNotEmpty((CharSequence)fileContent) ? "4" : "2";
        params.put("fileSource", fileSource);
        params.put("fileFormat", "pdf");
        params.put("businessId", String.valueOf(billId));
        params.put("fileUrl", fileUrl);
        Map<String, String> headers = AZTHelper.getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/upload";
        params.put("fileContent", fileContent);
        JSONObject json = null;
        try {
            logger.info("\u4e0a\u4f20\u6587\u6863url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u4e0a\u4f20\u6587\u6863\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    public static JSONObject download(String fileId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileId", fileId);
        params.put("downType", "2");
        Map<String, String> headers = AZTHelper.getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/download";
        JSONObject json = null;
        try {
            logger.info("\u4e0b\u8f7d\u6587\u6863url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u4e0b\u8f7d\u6587\u6863\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    public static String filePreview(String fileId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileId", fileId);
        Map<String, String> headers = AZTHelper.getHeaders(params);
        String url = host + "/iCloudDoc/file/v1/filePreview";
        JSONObject json = null;
        try {
            logger.info("\u6587\u4ef6\u9884\u89c8url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u6587\u4ef6\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        String result = json.getString("data");
        return result;
    }

    public static JSONObject signApply(Long billId, String fileId, String userName, String idCard, String mobile, String notifyUrl) {
        JSONObject keyword = new JSONObject();
        keyword.put("keyword", (Object)keyWord);
        JSONArray keywords = new JSONArray();
        keywords.add((Object)keyword);
        JSONObject location = new JSONObject();
        location.put("locationType", (Object)"2");
        location.put("keywords", (Object)keywords);
        JSONObject file = new JSONObject();
        file.put("fileId", (Object)fileId);
        file.put("location", (Object)location);
        JSONArray files = new JSONArray();
        files.add((Object)file);
        JSONObject user = new JSONObject();
        user.put("userSource", (Object)"2");
        user.put("userType", (Object)"2");
        user.put("userName", (Object)userName);
        user.put("idCard", (Object)idCard);
        JSONObject usePerson = new JSONObject();
        usePerson.put("useName", (Object)userName);
        usePerson.put("useIdCard", (Object)idCard);
        usePerson.put("mobile", (Object)mobile);
        JSONObject sealConfig = new JSONObject();
        sealConfig.put("getType", (Object)"0");
        sealConfig.put("usePerson", (Object)usePerson);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serialNo ", String.valueOf(billId));
        params.put("files", files);
        params.put("user", user);
        params.put("sealConfig", sealConfig);
        params.put("notifyUrl", notifyUrl);
        params.put("willInfo", "1");
        Map<String, String> headers = AZTHelper.getHeaders(params);
        String url = host + "/iCloudDoc/apply/v1/signApply";
        JSONObject json = null;
        try {
            logger.info("\u7b7e\u7ae0\u7533\u8bf7url\uff1a{}\uff0c\u6d88\u606f\u5934\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString(headers), JSONObject.toJSONString(params)});
            String response = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
            logger.info("\u7b7e\u7ae0\u7533\u8bf7\u7ed3\u679c\uff1a{}", (Object)response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            throw new BusinessException(e.getCause());
        }
        if (json.getInteger("code") != 200) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject result = json.getJSONObject("data");
        return result;
    }

    private static Map<String, String> getHeaders(Map<String, Object> params) {
        HashMap<String, Object> signMap = new HashMap<String, Object>(params);
        String time = String.valueOf(System.currentTimeMillis());
        String nonce = StringUtils.substring((String)time, (int)5);
        signMap.put("appId", appId);
        signMap.put("time", time);
        signMap.put("nonce", nonce);
        signMap.put("version", "1.0");
        String sign = signMap.entrySet().stream().filter(x -> Objects.nonNull(x.getValue())).sorted(Map.Entry.comparingByKey()).map(x -> (String)x.getKey() + "=" + x.getValue()).collect(Collectors.joining("&"));
        sign = sign + "&" + appSecret;
        logger.info("\u5b89\u8bc1\u901a-sign:{}", (Object)sign);
        String signStr = AZTHelper.getSHA256Str(sign);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("version", "1.0");
        headers.put("appId", appId);
        headers.put("time", time);
        headers.put("nonce", nonce);
        headers.put("sign", signStr);
        return headers;
    }

    private static String getSHA256Str(String str) {
        String encdeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static void main(String[] args) {
        JSONObject data = AZTHelper.signApply(1L, "F2025051919233762413859603864287", "\u674e\u987a", "412727199208221636", "15903993810", "https://qlh.baju.com.cn/ejc-sdbjmaterial-web/outStore/updateSignState");
        System.out.println(JSONObject.toJSONString((Object)data));
    }
}

