/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private static final String SDBJPANHUO_ZC = "SDBJPANHUO_ZC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;

    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SDBJPANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (vo.getId() != null && vo.getId() > 0L) {
            List<LabeldetailEntity> listlb = entity.getLabels();
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        if ("1".equals(vo.getShelfType()) && (null == vo.getToolId() || vo.getToolId() <= 0L)) {
            long toolId = System.currentTimeMillis();
            entity.setToolId(toolId);
            entity.setType(0);
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsDetailsVO vo = (GoodsDetailsVO)BeanMapper.map((Object)((Object)entity), GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange.gt(GoodsEntity::getRotatableNums, (Object)0);
        int nums = super.count((Wrapper)lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.gt(GoodsEntity::getRotatableNums, (Object)0);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
        }
        if ("1".equals(entity.getShelfType())) {
            LambdaQueryWrapper lambdachange3 = Wrappers.lambdaQuery();
            lambdachange3.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdachange3.eq(GoodsEntity::getToolId, (Object)entity.getToolId());
            lambdachange3.orderBy(false, true, (Object[])new SFunction[]{GoodsEntity::getShelfTime});
            List listgoods = super.list((Wrapper)lambdachange3);
            ArrayList<GoodsToolVO> listtools = new ArrayList<GoodsToolVO>();
            GoodsToolVO toolVO = (GoodsToolVO)BeanMapper.map(listgoods.get(0), GoodsToolVO.class);
            toolVO.setDealrTime(((GoodsEntity)((Object)listgoods.get(0))).getShelfTime());
            toolVO.setName("\u8d44\u4ea7\u4e0a\u67b6");
            listtools.add(toolVO);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("tool_id", new Parameter("eq", (Object)entity.getToolId()));
            queryParam.getParams().put("type", new Parameter("eq", (Object)1));
            queryParam.getOrderMap().put("dealr_time", "asc");
            List listOrder = this.orderService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)listOrder)) {
                listOrder.forEach(e -> {
                    GoodsToolVO toolVo = new GoodsToolVO();
                    toolVo.setName("\u5468\u8f6c\u5165\u5e93");
                    toolVo.setProjectName(e.getBuyProjectName());
                    toolVo.setDealrTime(e.getDealrTime());
                    toolVo.setToolId(e.getToolId());
                    listtools.add(toolVo);
                });
            }
            vo.setToolDetails(listtools);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listc = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listc)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)listc.get(0))).getId());
        } else {
            vo.setIsCollect(Integer.valueOf(0));
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((GoodsMapper)this.baseMapper).getGoods(pages, queryWrapper, lon, lat);
    }

    @Override
    public ReportVO orgStatistics(Long orgId) {
        ReportVO goodsNumsIngVo;
        CommonResponse orgListResp;
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        if (null == orgId || orgId <= 0L) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ReportVO resVO = new ReportVO();
        ReportVO pronumsVo = ((GoodsMapper)this.baseMapper).getPronums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != pronumsVo) {
            resVO.setProNums(pronumsVo.getProNums() == null ? BigDecimal.ZERO : pronumsVo.getProNums());
        } else {
            resVO.setProNums(BigDecimal.ZERO);
        }
        ReportVO goodsNumsVo = ((GoodsMapper)this.baseMapper).getGoodsnums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != goodsNumsVo) {
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsAmount());
            if (null != goodsNumsVo.getShelfTime()) {
                int days = (int)((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / 86400000L);
                resVO.setDays(days);
            }
        } else {
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }
        if (null != (goodsNumsIngVo = ((GoodsMapper)this.baseMapper).getGoodsnumsIng(InvocationInfoProxy.getTenantid(), commonOrgIds))) {
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfAmount());
        } else {
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }
        ReportVO OrdernumsVo = ((GoodsMapper)this.baseMapper).getOrdernums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != OrdernumsVo) {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        } else {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        }
        return resVO;
    }

    @Override
    public List<ReportVO> periodStatistics(List<Long> commonOrgIds) {
        return ((GoodsMapper)this.baseMapper).getPeriodStatistics(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }

    @Override
    public List<ReportVO> proportion(List<Long> commonOrgIds, int type) {
        if (type == 0) {
            return ((GoodsMapper)this.baseMapper).getGoodsProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        if (1 == type) {
            return ((GoodsMapper)this.baseMapper).getGoodsIngProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        return ((GoodsMapper)this.baseMapper).getProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }

    @Override
    public GoodsVO receiveEquipment(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(GoodsEntity::getSourcePmId, (Object)vo.getSourcePmId());
        List list = super.list((Wrapper)lambda);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u8bbe\u5907\u5df2\u5b58\u5728");
        }
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SDBJPANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setShelfType("4");
        entity.setPmType(0);
        entity.setIsPack("0");
        entity.setDiscount(new BigDecimal(1));
        entity.setRotatableNums(new BigDecimal(1));
        CommonResponse dataOrgCommonResponse = this.orgApi.findBySourceId(vo.getOrgSourceId());
        if (!dataOrgCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO dataOrg = (OrgVO)dataOrgCommonResponse.getData();
        entity.setOrgId(dataOrg.getId());
        entity.setOrgName(dataOrg.getName());
        CommonResponse dataUserCommonResponse = this.userApi.findUserBySourceId(vo.getSellerSourceId());
        if (!dataUserCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        UserVO dataUser = (UserVO)dataUserCommonResponse.getData();
        entity.setSeller(dataUser.getId());
        entity.setSellerName(dataUser.getUserName());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return resvo;
    }

    @Override
    public String updateEquipmentStatus(GoodsVO goodsVO) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(GoodsEntity::getSourcePmId, (Object)goodsVO.getSourcePmId());
        GoodsEntity goodsEntity = (GoodsEntity)((Object)super.getOne((Wrapper)lambda));
        if (goodsEntity != null) {
            LambdaQueryWrapper orderlambda = Wrappers.lambdaQuery();
            orderlambda.eq(OrderEntity::getGoodsId, (Object)goodsEntity.getId());
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getOne((Wrapper)orderlambda));
            if (orderEntity == null) {
                super.removeById((Serializable)goodsEntity.getId());
            }
            if (orderEntity != null) {
                if (orderEntity.getType() == 0) {
                    throw new BusinessException("\u8be5\u8bbe\u5907\u6709\u6267\u884c\u4e2d\u7684\u8ba2\u5355,\u8bf7\u53d6\u6d88\u8ba2\u5355\u540e\u91cd\u8bd5!");
                }
                if (orderEntity.getType() == 1) {
                    // empty if block
                }
                if (orderEntity.getType() == 2) {
                    super.removeById((Serializable)goodsEntity.getId());
                }
            }
        }
        return "\u4fee\u6539\u6210\u529f";
    }
}

