package com.ejianc.business.orgcenter.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 董监高人员
 *
 * @author CJ
 * @Description:
 * @date 2021/9/28 16:26
 */
public class DirectorVO extends BaseVO {

    /**
     * 内部人员
     */
    public static final Integer EMP_INNER = 1;
    /**
     * 外部人员
     */
    public static final Integer EMP_OUTER = 1;
    private static final long serialVersionUID = -8138830144178956714L;

    /**
     * 人员状态： 启用
     */
    public static final Integer DIRECTOR_STATUS_VALID = 1;
    /**
     * 人员状态：停用
     */
    public static final Integer DIRECTOR_STATUS_INVALID = 0;

    /**
     * 人员编号
     */
    private String billCode;

    /**
     * 人员名称
     */
    private String directorName;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 岗位名称
     */
    private String postName;

    /**
     * 是否内部员工：1-内部员工，2-外部人员
     */
    private Integer directorType;

    /**
     * 对应内部人员档案Id
     */
    private Long sourceId;

    /**
     * 起停用状态: 1-启用，0-停用
     */
    private Integer status;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getDirectorName() {
        return directorName;
    }

    public void setDirectorName(String directorName) {
        this.directorName = directorName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public Integer getDirectorType() {
        return directorType;
    }

    public void setDirectorType(Integer directorType) {
        this.directorType = directorType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
