package com.ejianc.business.sddjsorg.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 组织机构实体
 * 
 * @author generator
 * 
 */
public class SddjsOrgVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 公司名称
    private String code; // 公司编号
    private String nameShortCn; // 公司名称中文缩写
    private String nameShortEn; // 公司名称英文缩写
    private Long orgNatureId; // 公司注册性质id
    private String orgNatureName; // 公司注册性质
    private Long directSuperiorId; // 直接上级单位id
    private String directSuperior; // 直接上级单位
    private Long directSuperiorOrgId; // 直接上级单位平台组织id
    private Long subjectCorporateManagementResponsibility; // 公司管理责任主体
    private String subjectCorporateManagementResponsibilityName; // 公司管理责任主体
    private Long registerCountryId; // 注册国家地区id
    private String registerCountryName; // 注册国家地区名称
    private String registerAreaV; // 注册所在地区value
    private String registerAreaName; // 注册所在地区name
    private String registerAddress; // 注册地详细地址
    private String registerIn; // 注册地境内/境外
    private Integer reportMerge; // 报表合并
    private Integer whetherReportToGroup; // 是否上报集团批复
    private String applyReason; // 申请原因、注销原因
    private String businessScope; // 营业范围
    private BigDecimal registerCapital; // 注册资本
    private Long currencyTypeId; // 注册资本币种id
    private String currencyTypeName; // 注册资本币种名称
    private Long controlStatus; // 控制状态id
    private String controlStatusName; // 控制状态
    private BigDecimal equityRatio; // 股权比例
    private Long legalRepresentative; // 法定人代表
    private String legalRepresentativeName; // 法定人代表
    private Long director; // 董事
    private String directorName; // 董事
    private Long supervisor; // 监事
    private String supervisorName; // 监事
    private Long generalManager; // 总经理
    private String generalManagerName; // 总经理
    private Long actingHolder; // 代持方
    private BigDecimal heldByEmployees; // 职工持有(%)
    private BigDecimal heldBySubsidiary; // 分子公司持有(%)
    private BigDecimal heldByLocal; // 当地居民或公司持有
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date dateIncorporation; // 成立日期
    private String unifiedSocialCreditCode; // 统一社会信用代码
    private String taxpayerNumber; // 纳税人识别号
    private String bankAccountNumber; // 银行基本账号
    private String useState; // 使用状态：use：在用，nouse：注销

    private Long orgId; // 平台组织id
    private Integer legalFlag; // 是否法人单位
    
    private List<OrgShareholderVO> orgShareholderList = new ArrayList<>(); // 组织申请单-股东清单
    
    private List<OrgApplyVO> orgApplyList = new ArrayList<>(); // 组织申请单-历史记录

    /*******************导出字段start****************/
    private String useStateName; // 使用状态
    private String dateIncorporationShow; // 成立日期
    private String actingHolderName; // 代持方
    /*******************导出字段end****************/

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    
    public String getNameShortCn() {
        return nameShortCn;
    }

    public void setNameShortCn(String nameShortCn) {
        this.nameShortCn = nameShortCn;
    }
    
    public String getNameShortEn() {
        return nameShortEn;
    }

    public void setNameShortEn(String nameShortEn) {
        this.nameShortEn = nameShortEn;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getOrgNatureId() {
        return orgNatureId;
    }

    @ReferDeserialTransfer
    public void setOrgNatureId(Long orgNatureId) {
        this.orgNatureId = orgNatureId;
    }
    
    public String getOrgNatureName() {
        return orgNatureName;
    }

    public void setOrgNatureName(String orgNatureName) {
        this.orgNatureName = orgNatureName;
    }

    @ReferSerialTransfer(referCode="sddjs-org")
    public Long getDirectSuperiorId() {
        return directSuperiorId;
    }

    @ReferDeserialTransfer
    public void setDirectSuperiorId(Long directSuperiorId) {
        this.directSuperiorId = directSuperiorId;
    }
    
    public String getDirectSuperior() {
        return directSuperior;
    }

    public void setDirectSuperior(String directSuperior) {
        this.directSuperior = directSuperior;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSubjectCorporateManagementResponsibility() {
        return subjectCorporateManagementResponsibility;
    }

    @ReferDeserialTransfer
    public void setSubjectCorporateManagementResponsibility(Long subjectCorporateManagementResponsibility) {
        this.subjectCorporateManagementResponsibility = subjectCorporateManagementResponsibility;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    @ReferDeserialTransfer
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    
    public String getRegisterAreaV() {
        return registerAreaV;
    }

    public void setRegisterAreaV(String registerAreaV) {
        this.registerAreaV = registerAreaV;
    }
    
    public String getRegisterAreaName() {
        return registerAreaName;
    }

    public void setRegisterAreaName(String registerAreaName) {
        this.registerAreaName = registerAreaName;
    }
    
    public String getRegisterAddress() {
        return registerAddress;
    }

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }
    
    public String getRegisterIn() {
        return registerIn;
    }

    public void setRegisterIn(String registerIn) {
        this.registerIn = registerIn;
    }
    
    public Integer getReportMerge() {
        return reportMerge;
    }

    public void setReportMerge(Integer reportMerge) {
        this.reportMerge = reportMerge;
    }
    
    public Integer getWhetherReportToGroup() {
        return whetherReportToGroup;
    }

    public void setWhetherReportToGroup(Integer whetherReportToGroup) {
        this.whetherReportToGroup = whetherReportToGroup;
    }
    
    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }
    
    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    
    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    @ReferDeserialTransfer
    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }
    
    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getControlStatus() {
        return controlStatus;
    }

    @ReferDeserialTransfer
    public void setControlStatus(Long controlStatus) {
        this.controlStatus = controlStatus;
    }
    
    public String getControlStatusName() {
        return controlStatusName;
    }

    public void setControlStatusName(String controlStatusName) {
        this.controlStatusName = controlStatusName;
    }
    
    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }

    @ReferSerialTransfer(referCode="sddjs-director")
    public Long getLegalRepresentative() {
        return legalRepresentative;
    }

    @ReferDeserialTransfer
    public void setLegalRepresentative(Long legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }
    
    public String getLegalRepresentativeName() {
        return legalRepresentativeName;
    }

    public void setLegalRepresentativeName(String legalRepresentativeName) {
        this.legalRepresentativeName = legalRepresentativeName;
    }

    @ReferSerialTransfer(referCode="sddjs-director")
    public Long getDirector() {
        return director;
    }

    @ReferDeserialTransfer
    public void setDirector(Long director) {
        this.director = director;
    }
    
    public String getDirectorName() {
        return directorName;
    }

    public void setDirectorName(String directorName) {
        this.directorName = directorName;
    }

    @ReferSerialTransfer(referCode="sddjs-director")
    public Long getSupervisor() {
        return supervisor;
    }

    @ReferDeserialTransfer
    public void setSupervisor(Long supervisor) {
        this.supervisor = supervisor;
    }
    
    public String getSupervisorName() {
        return supervisorName;
    }

    public void setSupervisorName(String supervisorName) {
        this.supervisorName = supervisorName;
    }

    @ReferSerialTransfer(referCode="sddjs-director")
    public Long getGeneralManager() {
        return generalManager;
    }

    @ReferDeserialTransfer
    public void setGeneralManager(Long generalManager) {
        this.generalManager = generalManager;
    }
    
    public String getGeneralManagerName() {
        return generalManagerName;
    }

    public void setGeneralManagerName(String generalManagerName) {
        this.generalManagerName = generalManagerName;
    }

    @ReferSerialTransfer(referCode="sddjs-director")
    public Long getActingHolder() {
        return actingHolder;
    }

    @ReferDeserialTransfer
    public void setActingHolder(Long actingHolder) {
        this.actingHolder = actingHolder;
    }
    
    public BigDecimal getHeldByEmployees() {
        return heldByEmployees;
    }

    public void setHeldByEmployees(BigDecimal heldByEmployees) {
        this.heldByEmployees = heldByEmployees;
    }
    
    public BigDecimal getHeldBySubsidiary() {
        return heldBySubsidiary;
    }

    public void setHeldBySubsidiary(BigDecimal heldBySubsidiary) {
        this.heldBySubsidiary = heldBySubsidiary;
    }
   
    public BigDecimal getHeldByLocal() {
        return heldByLocal;
    }

    public void setHeldByLocal(BigDecimal heldByLocal) {
        this.heldByLocal = heldByLocal;
    }

    public Date getDateIncorporation() {
        return dateIncorporation;
    }

    public void setDateIncorporation(Date dateIncorporation) {
        this.dateIncorporation = dateIncorporation;
    }

    public String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    public void setUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }

    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }
 
    public String getBankAccountNumber() {
        return bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public String getUseState() {
        return useState;
    }

    public void setUseState(String useState) {
        this.useState = useState;
    }

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getLegalFlag() {
		return legalFlag;
	}

	public void setLegalFlag(Integer legalFlag) {
		this.legalFlag = legalFlag;
	}

	public List<OrgShareholderVO> getOrgShareholderList() {
		return orgShareholderList;
	}

	public void setOrgShareholderList(List<OrgShareholderVO> orgShareholderList) {
		this.orgShareholderList = orgShareholderList;
	}

	public List<OrgApplyVO> getOrgApplyList() {
		return orgApplyList;
	}

	public void setOrgApplyList(List<OrgApplyVO> orgApplyList) {
		this.orgApplyList = orgApplyList;
	}

	public Long getDirectSuperiorOrgId() {
		return directSuperiorOrgId;
	}

	public void setDirectSuperiorOrgId(Long directSuperiorOrgId) {
		this.directSuperiorOrgId = directSuperiorOrgId;
	}

	public String getUseStateName() {
		return useStateName;
	}

	public void setUseStateName(String useStateName) {
		this.useStateName = useStateName;
	}

	public String getDateIncorporationShow() {
		return dateIncorporationShow;
	}

	public void setDateIncorporationShow(String dateIncorporationShow) {
		this.dateIncorporationShow = dateIncorporationShow;
	}

	public String getActingHolderName() {
		return actingHolderName;
	}

	public void setActingHolderName(String actingHolderName) {
		this.actingHolderName = actingHolderName;
	}

	public String getSubjectCorporateManagementResponsibilityName() {
		return subjectCorporateManagementResponsibilityName;
	}

	public void setSubjectCorporateManagementResponsibilityName(String subjectCorporateManagementResponsibilityName) {
		this.subjectCorporateManagementResponsibilityName = subjectCorporateManagementResponsibilityName;
	}
    
}
