/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.orgcenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.orgcenter.bean.DirectorEntity;
import com.ejianc.business.orgcenter.mapper.DirectorMapper;
import com.ejianc.business.orgcenter.service.IDirectorService;
import com.ejianc.business.orgcenter.vo.DirectorVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="directorService")
public class DirectorServiceImpl
extends BaseServiceImpl<DirectorMapper, DirectorEntity>
implements IDirectorService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DirectorMapper directorMapper;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            this.directorMapper.batchDelByIds(ids);
        }
    }

    @Override
    public void syncEmployeeDetails() {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"director_type", (Object)DirectorVO.EMP_INNER);
        List directorList = this.directorMapper.selectList((Wrapper)query);
        HashMap<Long, DirectorEntity> directorEntityMap = new HashMap<Long, DirectorEntity>();
        if (CollectionUtils.isNotEmpty((Collection)directorList)) {
            ArrayList<Long> employeeIds = new ArrayList<Long>();
            for (DirectorEntity director : directorList) {
                directorEntityMap.put(director.getId(), director);
                employeeIds.add(director.getId());
            }
            CommonResponse employeeListResp = this.employeeApi.getByIds(employeeIds);
            if (!employeeListResp.isSuccess()) {
                this.logger.error("\u540c\u6b65\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u6863\u6848\u5931\u8d25: {}", (Object)employeeListResp.getMsg());
                throw new BusinessException("\u540c\u6b65\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List empList = (List)employeeListResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)empList)) {
                DirectorEntity tmp = null;
                ArrayList<DirectorEntity> updateList = new ArrayList<DirectorEntity>();
                for (EmployeeVO emp : empList) {
                    tmp = (DirectorEntity)((Object)directorEntityMap.get(emp.getId()));
                    tmp.setPostName(emp.getPostName());
                    tmp.setOrgName(emp.getOrgName());
                    tmp.setBillCode(emp.getCode());
                    tmp.setDirectorName(emp.getName());
                    directorList.remove((Object)tmp);
                    updateList.add(tmp);
                }
                super.saveOrUpdateBatch(updateList);
                if (CollectionUtils.isNotEmpty((Collection)directorList)) {
                    this.directorMapper.batchDelByIds(directorList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                }
            }
        }
    }
}

