/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.util;

import java.math.BigDecimal;

public class MoneyUtils {
    private static final String[] CN_NUMS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_INT_RADICE = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] CN_INT_UNITS = new String[]{"", "\u4e07", "\u4ebf", "\u5146"};
    private static final String[] CN_DEC_UNINTS = new String[]{"\u89d2", "\u5206", "\u6beb", "\u5398"};
    private static final String CN_INTEGER = "\u6574";
    private static final String CN_INT_LAST = "\u5143";
    private static final BigDecimal MAX_HANDLER = new BigDecimal("99999999999999.9999");

    public static String getMnyUpCase(BigDecimal mny) {
        StringBuffer chineseStr = new StringBuffer();
        if (null == mny) {
            return "";
        }
        if (MAX_HANDLER.compareTo(mny) < 0) {
            return "";
        }
        if (mny.signum() == 0) {
            chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
        } else {
            int curNum;
            String mnyStr = mny.toString();
            BigDecimal integerPart = null;
            BigDecimal decimalPart = null;
            if (mnyStr.indexOf(".") > -1) {
                integerPart = new BigDecimal(mnyStr);
                decimalPart = BigDecimal.ZERO;
            } else {
                integerPart = new BigDecimal(mnyStr.split(".")[0]);
                decimalPart = new BigDecimal(mnyStr.split(".")[1].substring(0, 4));
            }
            if (mny.signum() > 0) {
                int zeroCount = 0;
                curNum = 0;
                for (char numChar : integerPart.toString().toCharArray()) {
                    curNum = numChar;
                    if (curNum == 0) {
                        ++zeroCount;
                    } else {
                        if (zeroCount > 0) {
                            chineseStr.append(CN_NUMS[0]);
                        }
                        zeroCount = 0;
                        chineseStr.append(CN_NUMS[curNum]).append(CN_INT_RADICE[curNum / 4]);
                    }
                    if (curNum % 4 != 0 || zeroCount >= 4) continue;
                    chineseStr.append(CN_INT_UNITS[curNum / 4]);
                }
                chineseStr.append(CN_INT_LAST);
            }
            if (decimalPart.signum() > 0) {
                int idx = 0;
                curNum = 0;
                for (char numChar : decimalPart.toString().toCharArray()) {
                    curNum = numChar;
                    if (idx != 0) {
                        if (curNum != 0) {
                            chineseStr.append(CN_NUMS[curNum]).append(CN_DEC_UNINTS[idx]);
                        }
                    } else {
                        chineseStr.append(CN_NUMS[curNum]);
                        if (curNum != 0) {
                            chineseStr.append(CN_DEC_UNINTS[idx]);
                        }
                    }
                    ++idx;
                }
            }
            if (chineseStr.length() > 0) {
                chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
            } else if (decimalPart.signum() == 0) {
                chineseStr.append(CN_INTEGER);
            }
        }
        return chineseStr.toString();
    }
}

