/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="production")
public class ProductionBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IProductionOrgService productionOrgService;
    private static final String BILL_CODE = "sddjs-production-org";
    @Autowired
    private IBillCodeApi billCodeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProductionEntity entity = (ProductionEntity)((Object)this.productionService.getById(billId));
        ProductionOrgEntity orgEntity = new ProductionOrgEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        orgEntity.setCode((String)billCode.getData());
        orgEntity.setName(entity.getName());
        orgEntity.setUnifiedSocialCreditCode(entity.getUnifiedSocialCreditCode());
        orgEntity.setInReacrd(entity.getInReacrd());
        orgEntity.setOutCapitalOrg(Long.valueOf(entity.getOutCapitalOrg()));
        orgEntity.setOutCapitalOrgName(entity.getOutCapitalOrgName());
        orgEntity.setRelationToOutOrg(entity.getReductionCapitalId());
        orgEntity.setRelationToOutOrgName(entity.getRelationToOutOrgName());
        orgEntity.setBeOwner(entity.getBeOwner());
        orgEntity.setMainCapitalOrgId(entity.getMainCapitalOrgId());
        orgEntity.setRelationToOutOrgName(entity.getMainCapitalOrgName());
        orgEntity.setRegisterCountryId(entity.getRegisterCountryId());
        orgEntity.setRegisterCountryName(entity.getRegisterCountryName());
        orgEntity.setRegisterIn(entity.getRegisterIn());
        orgEntity.setRegisterAddress(entity.getRegisterAddress());
        orgEntity.setRegisterDate(entity.getRegisterDate());
        orgEntity.setCurrencyTypeId(entity.getCurrencyTypeId());
        orgEntity.setCurrencyTypeName(entity.getCurrencyTypeName());
        orgEntity.setRegisterCapital(entity.getRegisterCapital());
        orgEntity.setRegisterCapitalBig(entity.getRegisterCapitalBig());
        orgEntity.setOrgTypeId(entity.getOrgTypeId());
        orgEntity.setOrgTypeName(entity.getOrgTypeName());
        orgEntity.setRegulatoryBodiesId(Long.valueOf(entity.getRegulatoryBodiesId()));
        orgEntity.setRegulatoryBodies(entity.getRegulatoryBodies());
        orgEntity.setOrgFormId(entity.getOrgFormId());
        orgEntity.setOrgFormName(entity.getOrgFormName());
        orgEntity.setMajorIndustriesId(entity.getMajorIndustriesId());
        orgEntity.setMajorIndustries(entity.getMajorIndustries());
        orgEntity.setProductLevel(entity.getProductLevel());
        orgEntity.setMangerLevel(entity.getMangerLevel());
        orgEntity.setBeListed(entity.getBeListed());
        orgEntity.setMergeTable(entity.getMergeTable());
        orgEntity.setBeClosed(entity.getBeClosed());
        orgEntity.setProductionId(entity.getId());
        this.productionOrgService.save((Object)orgEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

