/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Autowired
    private ProductionMapper productionMapper;

    @Override
    public CommonResponse<String> assignTask(Map<String, String> param) {
        try {
            String applyId = param.get("applyId");
            String userId = param.get("userId");
            String userName = param.get("userName");
            OrgApplyEntity orgApplyEntity = (OrgApplyEntity)((Object)this.orgApplyService.getById(Long.valueOf(applyId)));
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(Long.valueOf(userId));
            orgApplyEntity.setPendingStartTime(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u6307\u6d3e\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f");
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)applyId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (StringUtils.isNotBlank((String)contributionType)) {
            queryWrapper.eq((Object)"contribution_type", (Object)contributionType);
        } else {
            queryWrapper.ne((Object)"contribution_type", (Object)"\u73b0\u91d1");
        }
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<ProductionTypeItemEntity> queryProductionTypeItemList() {
        return this.productionTypeItemService.list();
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)applyId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId) {
        ArrayList<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  count(id) as  declaredNumberEnterprises,captail_type as  captailType"});
        query.eq((Object)"pid", (Object)applyId);
        query.groupBy((Object[])new String[]{"captail_type"});
        Map dataMap = this.orgShareholderService.getMap((Wrapper)query);
        for (Map.Entry entry : dataMap.entrySet()) {
            CapitalVO vo = new CapitalVO();
            vo.setCaptailType((String)dataMap.get("captailType"));
            vo.setDeclaredNumberEnterprises((Long)(dataMap.get("declaredNumberEnterprises") != null ? dataMap.get("declaredNumberEnterprises") : Integer.valueOf(0)));
            vo.setId(Long.valueOf(IdWorker.getId()));
            resp.add(vo);
        }
        return resp;
    }

    @Override
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unified_social_credit_code", (Object)unifiedSocialCreditCode);
        List list = this.productionMapper.selectList((Wrapper)queryWrapper);
        return list;
    }
}

