/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sddjsorg.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionEntity;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionFileEntity;
import com.ejianc.business.sddjsorg.service.IShareholderDecisionService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shareholderDecision")
public class ShareholderDecisionBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareholderDecisionService shareholderDecisionService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = (ShareholderDecisionEntity)((Object)this.shareholderDecisionService.selectById(billId));
        this.logger.info("\u80a1\u4e1c\u51b3\u7b56\u5355\u636e-\u3010{}\u3011\u6267\u884c\u63d0\u4ea4\u524d\u6821\u9a8c\u903b\u8f91", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if (CollectionUtils.isNotEmpty(e.getDocFiles())) {
            StringBuilder sp = new StringBuilder("\u63d0\u4ea4\u5931\u8d25\uff01\u8bf7\u4e0a\u4f20");
            boolean checkFail = false;
            for (ShareholderDecisionFileEntity file : e.getDocFiles()) {
                if (!file.getRequired().booleanValue() || !"submit".equals(file.getCheckTime()) || !StringUtils.isBlank((CharSequence)file.getFileIds())) continue;
                checkFail = true;
                sp.append("[").append(file.getFileSetName()).append("]");
            }
            if (checkFail) {
                sp.append("\u7684\u9644\u4ef6");
                return CommonResponse.error((String)sp.toString());
            }
        }
        return CommonResponse.success((String)"\u80a1\u4e1c\u51b3\u7b56\u5ba1\u6279\u524d\u6821\u9a8c\u901a\u8fc7\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = (ShareholderDecisionEntity)((Object)this.shareholderDecisionService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.shareholderDecisionService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u80a1\u4e1c\u51b3\u7b56\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 1) {
            ShareholderDecisionEntity e = (ShareholderDecisionEntity)((Object)this.shareholderDecisionService.selectById(billId));
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
            this.shareholderDecisionService.saveOrUpdate((Object)e, false);
        }
        return CommonResponse.success((String)"\u80a1\u4e1c\u51b3\u7b56\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = (ShareholderDecisionEntity)((Object)this.shareholderDecisionService.selectById(billId));
        this.logger.info("\u80a1\u4e1c\u51b3\u7b56\u5355\u636e-\u3010{}\u3011\u6267\u884c\u64a4\u56de\u903b\u8f91", (Object)JSONObject.toJSONString((Object)((Object)e)));
        e.setEffectiveDate(null);
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserName(null);
        this.shareholderDecisionService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u6267\u884c\u80a1\u4e1c\u51b3\u7b56\u5355\u636e\u64a4\u56de\u903b\u8f91\u6210\u529f! ");
    }
}

