package com.ejianc.business.capital.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 资本金实缴实体
 *
 * @author CJ
 * @Description:
 * @date 2021/10/15 16:26
 */
@TableName(value = "ejc_sddjsorg_capital_real_payment_apply")
public class CapitalRealPaymentApplyEntity extends BaseEntity {
    private static final long serialVersionUID = -58827177225245813L;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 申请组织: 单据录入上下文组织
     */
    @TableField(value = "apply_org_id")
    private Long applyOrgId;

    /**
     * 申请组织名称
     */
    @TableField(value = "apply_org_name")
    private String applyOrgName;

    /**
     * 单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 出资方Id
     */
    @TableField(value = "captail_id")
    private Long captailId;

    /**
     * 出资方名称
     */
    @TableField(value="captail_name")
    private String captailName;

    /**
     * 已实缴金额（不含本次）
     */
    @TableField(value="paid_capital")
    private BigDecimal paidCapital;

    /**
     * 本次申请实缴金额
     */
    @TableField(value="apply_amt")
    private BigDecimal applyAmt;

    /**
     * 累计申请实缴金额(含本次）
     */
    @TableField(value="total_paid_capital")
    private BigDecimal totalPaidCapital;

    /**
     * 注册资本
     */
    @TableField(value="register_capital")
    private BigDecimal registerCapital;

    /**
     * 注册资本币种id
     */
    @TableField(value="currency_type_id")
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    @TableField(value="currency_type_name")
    private String currencyTypeName;

    /**
     * 公司Id(组织机构）
     */
    @TableField(value = "sddjs_org_id")
    private Long sddjsOrgId;

    /**
     * 公司名称(组织机构）
     */
    @TableField(value = "sddjs_org_name")
    private String sddjsOrgName;

    /**
     * 本次已实缴金额
     */
    @TableField(value = "real_paid_amt")
    private BigDecimal realPaidAmt;

    /**
     * 申请原因
     */
    @TableField(value = "apply_reason")
    private String applyReason;

    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getCaptailId() {
        return captailId;
    }

    public void setCaptailId(Long captailId) {
        this.captailId = captailId;
    }

    public String getCaptailName() {
        return captailName;
    }

    public void setCaptailName(String captailName) {
        this.captailName = captailName;
    }

    public BigDecimal getPaidCapital() {
        return paidCapital;
    }

    public void setPaidCapital(BigDecimal paidCapital) {
        this.paidCapital = paidCapital;
    }

    public BigDecimal getApplyAmt() {
        return applyAmt;
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.applyAmt = applyAmt;
    }

    public BigDecimal getTotalPaidCapital() {
        return totalPaidCapital;
    }

    public void setTotalPaidCapital(BigDecimal totalPaidCapital) {
        this.totalPaidCapital = totalPaidCapital;
    }

    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public Long getSddjsOrgId() {
        return sddjsOrgId;
    }

    public void setSddjsOrgId(Long sddjsOrgId) {
        this.sddjsOrgId = sddjsOrgId;
    }

    public String getSddjsOrgName() {
        return sddjsOrgName;
    }

    public void setSddjsOrgName(String sddjsOrgName) {
        this.sddjsOrgName = sddjsOrgName;
    }

    public BigDecimal getRealPaidAmt() {
        return realPaidAmt;
    }

    public void setRealPaidAmt(BigDecimal realPaidAmt) {
        this.realPaidAmt = realPaidAmt;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
}
