package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.mapper.ProductionMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.mapper.ProductionOrgMapper;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.service.IProductionOrgService;

/**
 * 产权登记生成的公司-出资人情况
 * 
 * @author generator
 * 
 */
@Service("productionOrgService")
public class ProductionOrgServiceImpl extends BaseServiceImpl<ProductionOrgMapper, ProductionOrgEntity> implements IProductionOrgService{
     @Autowired
     private ProductionOrgMapper productionOrgMapper;
    /**
     * 根据产权id查询一条数据
     * @param productionId
     * @return
     */
    public ProductionOrgEntity getByProductionId(Long productionId) {
        QueryWrapper wrapper = new QueryWrapper<>();
        wrapper.eq("production_id",productionId);
        wrapper.eq("dr",0);
        ProductionOrgEntity entity =productionOrgMapper.selectOne(wrapper);
        return entity;
    }
}
