/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.capital.bean.CapitalRealPaymentApplyEntity;
import com.ejianc.business.capital.service.ICapitalRealPaymentApplyService;
import com.ejianc.business.capital.vo.CapitalRealPaymentApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/capitalRealPayApply/"})
public class CapitalRealPayApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICapitalRealPaymentApplyService capitalRealPaymentApplyService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE_RULL_CODE = "SDDJS_CAPITAL_APPLY01";

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<CapitalRealPaymentApplyVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("captailName");
        queryParam.getFuzzyFields().add("sddjsOrgName");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("applyOrgId", new Parameter("in", orgIds));
        IPage page = this.capitalRealPaymentApplyService.queryPage(queryParam, false);
        Page result = new Page();
        result.setTotal(page.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalRealPaymentApplyVO.class));
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setPages(page.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<CapitalRealPaymentApplyVO> saveOrUpdate(@RequestBody CapitalRealPaymentApplyVO vo) {
        CapitalRealPaymentApplyEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        if (null == vo.getId()) {
            saveEntity = (CapitalRealPaymentApplyEntity)((Object)BeanMapper.map((Object)vo, CapitalRealPaymentApplyEntity.class));
            CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_RULL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCodeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveEntity.setBillCode((String)billCodeResp.getData());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (CapitalRealPaymentApplyEntity)((Object)this.capitalRealPaymentApplyService.selectById(vo.getId()));
            saveEntity.setApplyAmt(vo.getApplyAmt());
            saveEntity.setCaptailId(vo.getCaptailId());
            saveEntity.setCaptailName(vo.getCaptailName());
            saveEntity.setApplyReason(vo.getApplyReason());
            saveEntity.setTotalPaidCapital(vo.getTotalPaidCapital());
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        this.capitalRealPaymentApplyService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), CapitalRealPaymentApplyVO.class));
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<CapitalRealPaymentApplyVO> queryDetail(@RequestParam(value="id") Long id) {
        CapitalRealPaymentApplyVO resp = null;
        CapitalRealPaymentApplyEntity dbEntity = (CapitalRealPaymentApplyEntity)((Object)this.capitalRealPaymentApplyService.selectById(id));
        if (null != dbEntity) {
            resp = (CapitalRealPaymentApplyVO)BeanMapper.map((Object)((Object)dbEntity), CapitalRealPaymentApplyVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<CapitalRealPaymentApplyVO> vos) {
        this.capitalRealPaymentApplyService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("captailName");
        param.getFuzzyFields().add("sddjsOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("applyOrgId", new Parameter("in", orgIds));
        List list = this.capitalRealPaymentApplyService.queryList(param);
        ArrayList<CapitalRealPaymentApplyVO> vos = new ArrayList<CapitalRealPaymentApplyVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CapitalRealPaymentApplyVO tmp = null;
            for (CapitalRealPaymentApplyEntity e : list) {
                tmp = (CapitalRealPaymentApplyVO)BeanMapper.map((Object)((Object)e), CapitalRealPaymentApplyVO.class);
                tmp.setCreateTimeStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)e.getCreateTime()));
                tmp.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                vos.add(tmp);
            }
        }
        HashMap<String, ArrayList<CapitalRealPaymentApplyVO>> beans = new HashMap<String, ArrayList<CapitalRealPaymentApplyVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("capitalRealPayApplyExport.xlsx", beans, response);
    }
}

