/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.capital.bean.CapitalRecRegistryEntity;
import com.ejianc.business.capital.bean.CapitalRecRegistrySubEntity;
import com.ejianc.business.capital.service.ICapitalRecRegistryService;
import com.ejianc.business.capital.vo.CapitalRecRegistrySubVO;
import com.ejianc.business.capital.vo.CapitalRecRegistryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/capitalRecRegistry/"})
public class CapitalRecRegistryController {
    @Autowired
    private ICapitalRecRegistryService capitalRecRegistryService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE_RULL_CODE = "SDDJS_CAPITAL_REC_REGISTRY01";
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<CapitalRecRegistryVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("captailNames");
        queryParam.getFuzzyFields().add("sddjsOrgName");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        IPage page = this.capitalRecRegistryService.queryPage(queryParam, false);
        Page result = new Page();
        result.setTotal(page.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalRecRegistryVO.class));
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setPages(page.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<CapitalRecRegistryVO> saveOrUpdate(@RequestBody CapitalRecRegistryVO vo) {
        CapitalRecRegistryEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        if (CollectionUtils.isEmpty((Collection)vo.getSubList())) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b9e\u7f34\u6536\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList capitalIdList = new ArrayList();
        BigDecimal curTotalRecAmt = BigDecimal.ZERO;
        StringBuilder captailNames = new StringBuilder();
        String returnMsg = "";
        for (CapitalRecRegistrySubVO sub : vo.getSubList()) {
            if ("del".equals(sub.getRowState())) continue;
            if (null != sub.getCurPayAmt()) {
                if (new BigDecimal("0").equals(sub.getCurPayAmt())) {
                    sub.setRowState("del");
                    if (!StringUtils.isBlank((CharSequence)returnMsg)) continue;
                    returnMsg = "\u672c\u6b21\u5b9e\u7f34\u91d1\u989d\u4e3a0\u7684\u884c\u6570\u636e\u5df2\u88ab\u5220\u9664\uff01";
                    continue;
                }
                if (capitalIdList.contains(sub.getCaptailId())) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u51fa\u8d44\u4eba\u91cd\u590d!");
                }
                captailNames.append(sub.getCaptailName()).append(",");
                curTotalRecAmt = curTotalRecAmt.add(sub.getCurPayAmt());
                if (!CollectionUtils.isNotEmpty((Collection)sub.getAttachIds())) continue;
                sub.setAttachFileIds(StringUtils.join((Iterable)sub.getAttachIds(), (String)","));
                continue;
            }
            sub.setRowState("del");
        }
        vo.setCurTotalRecAmt(curTotalRecAmt);
        vo.setCaptailNames(captailNames.substring(0, captailNames.length() - 1));
        if (null == vo.getId()) {
            saveEntity = (CapitalRecRegistryEntity)((Object)BeanMapper.map((Object)vo, CapitalRecRegistryEntity.class));
            CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_RULL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCodeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveEntity.setBillCode((String)billCodeResp.getData());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (CapitalRecRegistryEntity)((Object)this.capitalRecRegistryService.selectById(vo.getId()));
            saveEntity.setSubList(BeanMapper.mapList((Iterable)vo.getSubList(), CapitalRecRegistrySubEntity.class));
            saveEntity.setSddjsOrgId(vo.getSddjsOrgId());
            saveEntity.setSddjsOrgName(vo.getSddjsOrgName());
            saveEntity.setCurrencyTypeId(vo.getCurrencyTypeId());
            saveEntity.setCurrencyTypeName(vo.getCurrencyTypeName());
            saveEntity.setRemark(vo.getRemark());
            saveEntity.setRegisterCapital(vo.getRegisterCapital());
            saveEntity.setCurTotalRecAmt(vo.getCurTotalRecAmt());
            saveEntity.setCaptailNames(vo.getCaptailNames());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setUpdateUserCode(userContext.getUserCode());
        }
        this.capitalRecRegistryService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)("\u4fdd\u5b58\u6210\u529f\uff01" + returnMsg), (Object)BeanMapper.map((Object)((Object)saveEntity), CapitalRecRegistryVO.class));
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<CapitalRecRegistryVO> queryDetail(@RequestParam(value="id") Long id) {
        CapitalRecRegistryVO resp = null;
        CapitalRecRegistryEntity dbEntity = (CapitalRecRegistryEntity)((Object)this.capitalRecRegistryService.selectById(id));
        if (null != dbEntity && CollectionUtils.isNotEmpty((Collection)(resp = (CapitalRecRegistryVO)BeanMapper.map((Object)((Object)dbEntity), CapitalRecRegistryVO.class)).getSubList())) {
            resp.getSubList().forEach(sub -> {
                if (StringUtils.isNotBlank((CharSequence)sub.getAttachFileIds())) {
                    sub.setAttachIds(Arrays.asList(sub.getAttachFileIds().split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                } else {
                    sub.setAttachFileIds(null);
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<CapitalRecRegistryVO> vos) {
        for (CapitalRecRegistryVO vo : vos) {
            this.capitalRecRegistryService.removeById(vo.getId(), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("captailNames");
        param.getFuzzyFields().add("sddjsOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        List list = this.capitalRecRegistryService.queryList(param);
        ArrayList<CapitalRecRegistryVO> vos = new ArrayList<CapitalRecRegistryVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CapitalRecRegistryVO tmp = null;
            for (CapitalRecRegistryEntity e : list) {
                tmp = (CapitalRecRegistryVO)BeanMapper.map((Object)((Object)e), CapitalRecRegistryVO.class);
                tmp.setCreateTimeStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)e.getCreateTime()));
                tmp.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                vos.add(tmp);
            }
        }
        HashMap<String, ArrayList<CapitalRecRegistryVO>> beans = new HashMap<String, ArrayList<CapitalRecRegistryVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("capitalRecRegistryExport.xlsx", beans, response);
    }
}

