/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.production.vo.ConformanceContentVO;
import com.ejianc.business.production.vo.OrgApplyVOS;
import com.ejianc.business.production.vo.ProductionVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"production"})
public class ProductionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sddjs-production";
    @Autowired
    private IProductionService service;
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private IProductionOrgService productionOrgService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductionVO> saveOrUpdate(@RequestBody ProductionVO saveorUpdateVO) {
        boolean add = false;
        ProductionEntity entity = (ProductionEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            add = true;
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            saveorUpdateVO.setCreateTime(new Date());
        } else {
            saveorUpdateVO.setUpdateTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)saveorUpdateVO.getConformanceContentEntities())) {
            List list = saveorUpdateVO.getConformanceContentEntities();
            for (ConformanceContentVO vo : list) {
                if (!vo.getRequired().booleanValue() || vo.getFileIds() != null) continue;
                throw new BusinessException("\u5408\u89c4\u6027\u76ee\u5f55: " + vo.getName() + " \u5fc5\u987b\u4e0a\u4f20\u6587\u4ef6");
            }
        }
        OrgApplyEntity applyEntity = (OrgApplyEntity)((Object)this.orgApplyService.selectById(saveorUpdateVO.getSourceApplyId()));
        applyEntity.setProductionState("registering");
        if (add) {
            if (applyEntity.getProductionNum() != null) {
                applyEntity.setProductionNum(applyEntity.getProductionNum() + 1);
            } else {
                applyEntity.setProductionNum(1);
            }
        }
        this.orgApplyService.saveOrUpdate((Object)applyEntity);
        this.service.saveOrUpdate((Object)entity, false);
        ProductionVO vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/noRegister"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> noRegister(@RequestBody Map<String, Long> param) {
        Long applyId = param.get("applyId");
        OrgApplyEntity applyEntity = (OrgApplyEntity)((Object)this.orgApplyService.selectById(applyId));
        applyEntity.setProductionState("noregister");
        applyEntity.setProductionNum(0);
        this.orgApplyService.updateById((Object)applyEntity);
        return CommonResponse.success((String)"\u4e0d\u767b\u8bb0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionVO> queryDetail(Long id) {
        ProductionEntity entity = (ProductionEntity)((Object)this.service.selectById(id));
        ProductionVO vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryOrgDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVOS> queryOrgDetail(Long applyId, String productionTypeCode) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.orgApplyService.selectById(applyId));
        List<OrgShareholderEntity> currencyEntities = this.service.queryApplyShareholderByApplyIdList(applyId, "\u73b0\u91d1");
        List<OrgShareholderEntity> noneCurrencyEntities = this.service.queryApplyShareholderByApplyIdList(applyId, null);
        OrgApplyVOS vo = (OrgApplyVOS)BeanMapper.map((Object)((Object)entity), OrgApplyVOS.class);
        vo.setCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        vo.setNoneCurrencyEntities(BeanMapper.mapList(noneCurrencyEntities, OrgShareholderVO.class));
        List<ProductionTypeItemEntity> productionTypeItemEntityList = this.service.queryProductionTypeItemList(productionTypeCode);
        List contentVOS = BeanMapper.mapList(productionTypeItemEntityList, ConformanceContentVO.class);
        if (ListUtil.isNotEmpty((List)contentVOS)) {
            for (ConformanceContentVO contentVO : contentVOS) {
                contentVO.setFileSetId(contentVO.getId());
            }
        }
        vo.setConformanceContentEntities(contentVOS);
        List<OrgShareholderEntity> lnvestorsEntities = this.service.queryApplyShareholderByApplyIdAllList(applyId);
        vo.setInvestorsEntities(BeanMapper.mapList(lnvestorsEntities, OrgShareholderVO.class));
        List<CapitalVO> capitalList = this.service.queryApplyShareholderByApplyIdSumCaptailName(applyId);
        vo.setCapitalEntities(capitalList);
        vo.setId(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryHistoryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionVO> queryHistoryDetail(Long id) {
        ProductionVO vo = new ProductionVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ProductionEntity entity = (ProductionEntity)((Object)list.get(0));
            vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> queryListNum() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("productionState", new Parameter("in", (Object)"unregistered,registering"));
        param.getParams().put("fileState", new Parameter("eq", (Object)"filed"));
        List list = this.orgApplyService.queryList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)list.size());
    }

    @RequestMapping(value={"/queryStayList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryOrgList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileState", new Parameter("eq", (Object)"filed"));
        param.getParams().put("productionState", new Parameter("in", (Object)"unregistered,registering"));
        IPage page = this.orgApplyService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAlreadyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryAlreadyList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/assignTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assignTask(@RequestBody Map<String, String> param) {
        return this.service.assignTask(param);
    }

    @RequestMapping(value={"/excelStayExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelStayExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.orgApplyService.queryList(param);
        List orgApplyVOList = BeanMapper.mapList((Iterable)list, OrgApplyVO.class);
        for (OrgApplyVO r : orgApplyVOList) {
            if (StringUtils.isNotEmpty((CharSequence)r.getProductionState())) {
                switch (r.getProductionState()) {
                    case "unregistered": {
                        r.setProductionState("\u672a\u767b\u8bb0");
                    }
                    case "registered": {
                        r.setProductionState("\u5df2\u767b\u8bb0");
                    }
                    case "registering": {
                        r.setProductionState("\u767b\u8bb0\u4e2d");
                    }
                    case "noregister": {
                        r.setProductionState("\u4e0d\u767b\u8bb0");
                    }
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)r.getApplyType())) continue;
            if ("set".equals(r.getApplyType())) {
                r.setApplyTypeName("\u8bbe\u7acb\u7533\u8bf7");
                continue;
            }
            if ("change".equals(r.getApplyType())) {
                r.setApplyTypeName("\u53d8\u66f4\u7533\u8bf7");
                continue;
            }
            if ("del".equals(r.getApplyType())) {
                r.setApplyTypeName("\u6ce8\u9500\u7533\u8bf7");
                continue;
            }
            if ("merge".equals(r.getApplyType())) {
                r.setApplyTypeName("\u5408\u5e76\u7533\u8bf7");
                continue;
            }
            if ("divide".equals(r.getApplyType())) {
                r.setApplyTypeName("\u5206\u7acb\u7533\u8bf7");
                continue;
            }
            if (!"supplementary".equals(r.getApplyType())) continue;
            r.setApplyTypeName("\u8865\u5f55\u7533\u8bf7");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelAlreadyExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelAlreadyExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage page = this.service.queryPage(param, false);
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class);
        for (ProductionVO r : voList) {
            r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("production-register-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> refProductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.orgApplyService.queryList(param);
        List orgApplyVOList = BeanMapper.mapList((Iterable)list, OrgApplyVO.class);
        for (OrgApplyVO r : orgApplyVOList) {
            if (StringUtils.isNotEmpty((CharSequence)r.getProductionState())) {
                switch (r.getProductionState()) {
                    case "unregistered": {
                        r.setProductionState("\u672a\u767b\u8bb0");
                    }
                    case "registered": {
                        r.setProductionState("\u5df2\u767b\u8bb0");
                    }
                    case "registering": {
                        r.setProductionState("\u767b\u8bb0\u4e2d");
                    }
                    case "noregister": {
                        r.setProductionState("\u4e0d\u767b\u8bb0");
                    }
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)r.getApplyType())) continue;
            if ("set".equals(r.getApplyType())) {
                r.setApplyTypeName("\u8bbe\u7acb\u7533\u8bf7");
                continue;
            }
            if ("change".equals(r.getApplyType())) {
                r.setApplyTypeName("\u53d8\u66f4\u7533\u8bf7");
                continue;
            }
            if ("del".equals(r.getApplyType())) {
                r.setApplyTypeName("\u6ce8\u9500\u7533\u8bf7");
                continue;
            }
            if ("merge".equals(r.getApplyType())) {
                r.setApplyTypeName("\u5408\u5e76\u7533\u8bf7");
                continue;
            }
            if ("divide".equals(r.getApplyType())) {
                r.setApplyTypeName("\u5206\u7acb\u7533\u8bf7");
                continue;
            }
            if (!"supplementary".equals(r.getApplyType())) continue;
            r.setApplyTypeName("\u8865\u5f55\u7533\u8bf7");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }
}

