/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Autowired
    private ProductionMapper productionMapper;

    @Override
    public CommonResponse<String> assignTask(Map<String, String> param) {
        try {
            String applyId = param.get("applyId");
            String userId = param.get("userId");
            String userName = param.get("userName");
            OrgApplyEntity orgApplyEntity = (OrgApplyEntity)((Object)this.orgApplyService.getById(Long.valueOf(applyId)));
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(Long.valueOf(userId));
            orgApplyEntity.setPendingStartTime(new Date());
            this.orgApplyService.saveOrUpdate((Object)orgApplyEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u6307\u6d3e\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f");
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)applyId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (StringUtils.isNotBlank((String)contributionType)) {
            queryWrapper.eq((Object)"contribution_type", (Object)contributionType);
        } else {
            queryWrapper.ne((Object)"contribution_type", (Object)"\u73b0\u91d1");
        }
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<ProductionTypeItemEntity> queryProductionTypeItemList(String productionTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"production_type_code", (Object)productionTypeCode);
        return this.productionTypeItemService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)applyId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        return this.orgShareholderMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId) {
        ArrayList<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  sum(subscribed_capital) as  declaredNumberEnterprises,captail_type as  captailType"});
        query.eq((Object)"pid", (Object)applyId);
        query.groupBy((Object[])new String[]{"captail_type"});
        List listMaps = this.orgShareholderService.listMaps((Wrapper)query);
        for (int i = 0; i < listMaps.size(); ++i) {
            Map map = (Map)listMaps.get(i);
            CapitalVO vo = new CapitalVO();
            vo.setCaptailType((String)map.get("captailType"));
            vo.setDeclaredNumberEnterprises(map.get("declaredNumberEnterprises") != null ? new BigDecimal(map.get("declaredNumberEnterprises").toString()) : BigDecimal.ZERO.setScale(8));
            vo.setId(Long.valueOf(IdWorker.getId()));
            resp.add(vo);
        }
        return resp;
    }

    @Override
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unified_social_credit_code", (Object)unifiedSocialCreditCode);
        List list = this.productionMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<ProductionEntity> queryProductionByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_apply_id", (Object)applyId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{"1,3"});
        List list = this.productionMapper.selectList((Wrapper)queryWrapper);
        return list;
    }
}

