/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sddjsorg.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.OrgApplyFileEntity;
import com.ejianc.business.sddjsorg.bean.OrgApplyFileSetEntity;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionFileEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyFileService;
import com.ejianc.business.sddjsorg.service.IOrgApplyFileSetService;
import com.ejianc.business.sddjsorg.service.IShareholderDecisionFileService;
import com.ejianc.business.sddjsorg.vo.OrgApplyFileSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"orgApplyFileSet"})
public class OrgApplyFileSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareholderDecisionFileService shareholderDecisionFileService;
    @Autowired
    private IOrgApplyFileService orgApplyFileService;
    @Autowired
    private IOrgApplyFileSetService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgApplyFileSetVO> saveOrUpdate(@RequestBody OrgApplyFileSetVO saveorUpdateVO) {
        OrgApplyFileSetEntity entity = (OrgApplyFileSetEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrgApplyFileSetEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        OrgApplyFileSetVO vo = (OrgApplyFileSetVO)BeanMapper.map((Object)((Object)entity), OrgApplyFileSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyFileSetVO> queryDetail(Long id) {
        OrgApplyFileSetEntity entity = (OrgApplyFileSetEntity)((Object)this.service.selectById(id));
        OrgApplyFileSetVO vo = (OrgApplyFileSetVO)BeanMapper.map((Object)((Object)entity), OrgApplyFileSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgApplyFileSetVO> vos) {
        QueryParam param = new QueryParam();
        param.getParams().put("fileSetId", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (vos.get(0).getType().equals("decision")) {
            List exist = this.shareholderDecisionFileService.queryList(param);
            if (ListUtil.isNotEmpty((List)exist)) {
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u6570\u636e\u5df2\u88ab\u5f15\u7528\u4e0d\u5141\u8bb8\u5220\u9664\uff1a" + Strings.join((Iterable)Lists.newArrayList((Iterable)exist.stream().map(ShareholderDecisionFileEntity::getFileSetName).distinct().collect(Collectors.toList())), (char)',')));
            }
        } else {
            List exist = this.orgApplyFileService.queryList(param);
            if (ListUtil.isNotEmpty((List)exist)) {
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u6570\u636e\u5df2\u88ab\u5f15\u7528\u4e0d\u5141\u8bb8\u5220\u9664\uff1a" + Strings.join((Iterable)Lists.newArrayList((Iterable)exist.stream().map(OrgApplyFileEntity::getName).distinct().collect(Collectors.toList())), (char)',')));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyFileSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyFileSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryFileSetInfoList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OrgApplyFileSetVO>> queryFileSetInfoList(@RequestParam(value="applyTypeCode") String applyTypeCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)applyTypeCode));
        param.getParams().put("inUse", new Parameter("eq", (Object)true));
        List page = this.service.queryList(param, false);
        List pageData = BeanMapper.mapList((Iterable)page, OrgApplyFileSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OrgApplyFileSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrgApplyFileSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyFileSetVO>> refOrgApplyFileSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyFileSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

