/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sddjsorg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.SddjsOrgVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sddjsorg"})
public class SddjsOrgController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "sddjs-org";
    private static final String APPLY_BILL_CODE = "sddjs-org-apply";
    @Autowired
    private ISddjsOrgService service;
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SddjsOrgVO> saveOrUpdate(@RequestBody SddjsOrgVO saveorUpdateVO) {
        SddjsOrgEntity entity = (SddjsOrgEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SddjsOrgEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SddjsOrgVO vo = (SddjsOrgVO)BeanMapper.map((Object)((Object)entity), SddjsOrgVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SddjsOrgVO> queryDetail(Long id) {
        SddjsOrgEntity entity = (SddjsOrgEntity)((Object)this.service.selectById(id));
        SddjsOrgVO vo = (SddjsOrgVO)BeanMapper.map((Object)((Object)entity), SddjsOrgVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"in_use_org_id", (Object)id);
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.orgApplyService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            vo.setOrgApplyList(BeanMapper.mapList((Iterable)list, OrgApplyVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SddjsOrgVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SddjsOrgVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (this.sessionManager.getUserContext().getOrgType() != 1) {
            param.getParams().put("directSuperiorOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SddjsOrgVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (this.sessionManager.getUserContext().getOrgType() != 1) {
            param.getParams().put("directSuperiorOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, SddjsOrgVO.class);
        for (SddjsOrgVO vo : vos) {
            if ("use".equals(vo.getUseState())) {
                vo.setUseStateName("\u5728\u7528");
            } else {
                vo.setUseStateName("\u5df2\u6ce8\u9500");
            }
            vo.setDateIncorporationShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)vo.getDateIncorporation()));
            try {
                JSONArray jArray;
                if (vo.getActingHolder() == null || (jArray = ReferObjectUtil.getReferEntityValue((String)vo.getActingHolder().toString(), (String)"idm-user")) == null || jArray.size() <= 0) continue;
                JSONObject json = (JSONObject)jArray.get(0);
                vo.setActingHolderName(json.get((Object)"name").toString());
            }
            catch (Exception exception) {}
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("orgExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrgData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SddjsOrgVO>> refOrgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("useState", new Parameter("eq", (Object)"use"));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"om") != null) {
            param.getParams().put("orgId", new Parameter("ne", null));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SddjsOrgVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryChangeDetail(Long changeId) {
        SddjsOrgEntity entity = (SddjsOrgEntity)((Object)this.service.selectById(changeId));
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        Long id = IdWorker.getId();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(APPLY_BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        vo.setCode((String)billCode.getData());
        vo.setInUseOrgId(entity.getId());
        vo.setApplyType("change");
        vo.setId(id);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setTenantId(InvocationInfoProxy.getTenantid());
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(null);
        vo.setOrgApplyFileList(null);
        vo.setProductionState("unregistered");
        vo.setProductionNum(Integer.valueOf(0));
        vo.setFileTime(null);
        vo.setFileState(null);
        vo.setFileUser(null);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "businessLicense", id.toString(), "BT211012000000004", "businessLicense");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "articles", id.toString(), "BT211012000000004", "articles");
        if (vo.getOrgShareholderList() != null && vo.getOrgShareholderList().size() > 0) {
            vo.getOrgShareholderList().forEach(older -> {
                older.setCreateTime(null);
                older.setCreateUserCode(null);
                older.setTenantId(InvocationInfoProxy.getTenantid());
                older.setUpdateTime(null);
                older.setUpdateUserCode(null);
                older.setPid(null);
                older.setRowState("add");
            });
        }
        vo.setChangeOldContent(JSONObject.toJSONString((Object)vo));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCancellationDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryCancellationDetail(Long changeId) {
        SddjsOrgEntity entity = (SddjsOrgEntity)((Object)this.service.selectById(changeId));
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        Long id = IdWorker.getId();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(APPLY_BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        vo.setCode((String)billCode.getData());
        vo.setInUseOrgId(entity.getId());
        vo.setApplyType("del");
        vo.setOrgCode(entity.getCode());
        vo.setApplyReason(null);
        vo.setId(id);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setTenantId(InvocationInfoProxy.getTenantid());
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(null);
        vo.setOrgApplyFileList(null);
        vo.setProductionState("unregistered");
        vo.setProductionNum(Integer.valueOf(0));
        vo.setFileTime(null);
        vo.setFileState(null);
        vo.setFileUser(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

