/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MoneyUtils {
    private static final String[] CN_NUMS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_INT_RADICE = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] CN_INT_UNITS = new String[]{"", "\u4e07", "\u4ebf", "\u5146"};
    private static final String[] CN_DEC_UNINTS = new String[]{"\u89d2", "\u5206", "\u6beb", "\u5398"};
    private static final String CN_INTEGER = "\u6574";
    private static final String CN_INT_LAST = "\u5143";
    private static final BigDecimal MAX_HANDLER = new BigDecimal("99999999999999.9999");

    public static String getMnyUpCase(BigDecimal mny) {
        StringBuffer chineseStr = new StringBuffer();
        if (null == mny) {
            return "";
        }
        if (MAX_HANDLER.compareTo(mny) < 0) {
            return "";
        }
        if (mny.signum() == 0) {
            chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
        } else {
            String mnyStr = mny.toString();
            BigDecimal integerPart = null;
            BigDecimal decimalPart = null;
            if (mnyStr.indexOf(".") < 0) {
                integerPart = new BigDecimal(mnyStr);
                decimalPart = BigDecimal.ZERO;
            } else {
                String[] mnyArr = mnyStr.split("\\.");
                integerPart = new BigDecimal(mnyArr[0]);
                decimalPart = mnyArr[1].length() > 4 ? new BigDecimal(mnyArr[1].substring(0, 4)) : new BigDecimal(mnyArr[1]);
            }
            if (mny.signum() > 0) {
                int zeroCount = 0;
                int curNum = 0;
                String integerPartStr = integerPart.toString();
                List numStr = Stream.iterate(0, n -> {
                    n = n + 1;
                    return n;
                }).limit(integerPartStr.length()).map(n -> "" + integerPartStr.charAt((int)n)).collect(Collectors.toList());
                int numLen = numStr.size();
                for (int i = 0; i < numLen; ++i) {
                    curNum = Integer.valueOf((String)numStr.get(i));
                    int p = numLen - i - 1;
                    int q = p / 4;
                    int m = p % 4;
                    if (curNum == 0) {
                        ++zeroCount;
                    } else {
                        if (zeroCount > 0) {
                            chineseStr.append(CN_NUMS[0]);
                        }
                        zeroCount = 0;
                        chineseStr.append(CN_NUMS[curNum]).append(CN_INT_RADICE[m]);
                    }
                    if (m != 0 || zeroCount >= 4) continue;
                    chineseStr.append(CN_INT_UNITS[q]);
                }
                chineseStr.append(CN_INT_LAST);
            }
            if (decimalPart.signum() > 0) {
                String decimalParttStr = decimalPart.toString();
                List numStr = Stream.iterate(0, n -> {
                    n = n + 1;
                    return n;
                }).limit(decimalParttStr.length()).map(n -> "" + decimalParttStr.charAt((int)n)).collect(Collectors.toList());
                int numLen = numStr.size();
                int curNum = 0;
                for (int i = 0; i < numLen; ++i) {
                    curNum = Integer.valueOf((String)numStr.get(i));
                    if (i != 0) {
                        if (curNum == 0) continue;
                        chineseStr.append(CN_NUMS[curNum]).append(CN_DEC_UNINTS[i]);
                        continue;
                    }
                    chineseStr.append(CN_NUMS[curNum]);
                    if (curNum == 0) continue;
                    chineseStr.append(CN_DEC_UNINTS[i]);
                }
            }
            if (chineseStr.length() == 0) {
                chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
            } else if (decimalPart.compareTo(BigDecimal.ZERO) == 0) {
                chineseStr.append(CN_INTEGER);
            }
        }
        return chineseStr.toString();
    }
}

