package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.vo.*;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;

/**
 * 产权登记主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("production")
public class ProductionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sddjs-production";//此处需要根据实际修改
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IProductionService service;

    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private IProductionOrgService productionOrgService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionVO> saveOrUpdate(@RequestBody ProductionVO saveorUpdateVO) {
        boolean add = false;
    	ProductionEntity entity = BeanMapper.map(saveorUpdateVO, ProductionEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            add = true;
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            saveorUpdateVO.setCreateTime(new Date());
        }else{
            saveorUpdateVO.setUpdateTime(new Date());
        }

        if(CollectionUtils.isNotEmpty(saveorUpdateVO.getConformanceContentEntities())){
            List<ConformanceContentVO> list =saveorUpdateVO.getConformanceContentEntities();
            for (ConformanceContentVO vo:list){
                if(vo.getRequired() && vo.getFileIds() ==null){
                    throw new BusinessException("合规性目录: "+vo.getName()+" 必须上传文件");
                }
            }
        }

        OrgApplyEntity applyEntity =orgApplyService.selectById(saveorUpdateVO.getSourceApplyId());
        applyEntity.setProductionState("registering");
        if(add){
            if(applyEntity.getProductionNum() !=null){
                applyEntity.setProductionNum(applyEntity.getProductionNum()+1);
            }else{
                applyEntity.setProductionNum(1);
            }
        }
        orgApplyService.saveOrUpdate(applyEntity);//更新 登记状态  登记中
    	service.saveOrUpdate(entity, false);
    	ProductionVO vo = BeanMapper.map(entity, ProductionVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 不登记调用
     * @return
     */
    @RequestMapping(value = "/noRegister", method = RequestMethod.POST)
    @ResponseBody
    public  CommonResponse<String> noRegister(@RequestBody Map<String,Long> param){
        Long applyId =param.get("applyId");
        OrgApplyEntity applyEntity =orgApplyService.selectById(applyId);
        return service.updateNoRegister(applyEntity);
    }



    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryDetail(Long id) {
    	ProductionEntity entity = service.selectById(id);
    	ProductionVO vo = BeanMapper.map(entity, ProductionVO.class);
        //productionOrgService.saveOrUpdateOrgProduction(entity);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询待登记详情
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryOrgDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgApplyVOS> queryOrgDetail(Long applyId,String productionTypeCode) {
        OrgApplyEntity entity = orgApplyService.selectById(applyId);
        List<OrgShareholderEntity> currencyEntities =service.queryApplyShareholderByApplyIdList(applyId,"现金");
        List<OrgShareholderEntity> noneCurrencyEntities =service.queryApplyShareholderByApplyIdList(applyId,null);

        OrgApplyVOS vo = BeanMapper.map(entity, OrgApplyVOS.class);

        vo.setCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        vo.setNoneCurrencyEntities(BeanMapper.mapList(noneCurrencyEntities, OrgShareholderVO.class));
        List<ProductionTypeItemEntity> productionTypeItemEntityList =service.queryProductionTypeItemList(productionTypeCode);
        //List<OrgShareholderEntity> acquisitionEquityVOList =service.queryApplyShareholderByApplyIdAllList(applyId);
        //vo.setAcquisitionEquityEntities(BeanMapper.mapList(acquisitionEquityVOList, OrgShareholderVO.class));
        List<ConformanceContentVO> contentVOS = BeanMapper.mapList(productionTypeItemEntityList,ConformanceContentVO.class);
        if(ListUtil.isNotEmpty(contentVOS)){
            for (ConformanceContentVO contentVO : contentVOS) {
                contentVO.setFileSetId(contentVO.getId());
            }
        }
        vo.setConformanceContentEntities(contentVOS);
        List<OrgShareholderEntity> lnvestorsEntities =service.queryApplyShareholderByApplyIdAllList(applyId);
        vo.setInvestorsEntities(BeanMapper.mapList(lnvestorsEntities,OrgShareholderVO.class));
        List<CapitalVO> capitalList =service.queryApplyShareholderByApplyIdSumCaptailName(applyId);
        vo.setCapitalEntities(capitalList);
        vo.setId(null);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 根据申请id查询历史记录数据
     * @param applyId
     * @return
     */
    @RequestMapping(value = "/queryHistoryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryHistoryDetail(Long id) {
        ProductionVO vo = new ProductionVO();
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();

        List<ProductionEntity> list =service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            ProductionEntity entity = list.get(0);
            vo =BeanMapper.map(entity, ProductionVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVO> vos) {
        service.removeByIds(vos.stream().map(ProductionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表 数据量
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> queryListNum() {
        QueryParam param = new QueryParam();

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));//已归档的

        List<OrgApplyEntity> list = orgApplyService.queryList(param,false);

        return CommonResponse.success("查询列表数据成功！",list.size());
    }

    /**
     * @Description queryList 校验待处理的申请单是否可以处理
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/checkCanDeal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkCanDeal(Long applyId) {
        OrgApplyEntity applyEntity = orgApplyService.selectById(applyId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));//已归档的
        param.getParams().put("inUseOrgId", new Parameter(QueryParam.EQ, applyEntity.getInUseOrgId()));//当前申请单的在用组织
        param.getParams().put("createTime", new Parameter(QueryParam.LT, DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,applyEntity.getCreateTime())));//当前申请单之前的申请单
        List<OrgApplyEntity> list = orgApplyService.queryList(param,false);
        return CommonResponse.success("校验待处理成功！",ListUtil.isEmpty(list));
    }

    /**
     * @Description queryList 查询列表（待登记）
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryStayList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryOrgList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));//已归档的
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //登记状态 未登记或者登记中
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));

        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.NE,  InvocationInfoProxy.getUsercode()));
            }
            param.getParams().remove("hasMyRegist");
        }
        //是否法人单位 1是法人，0非法人
//        param.getParams().put("legalFlag", new Parameter(QueryParam.IN, 1));

        IPage<OrgApplyEntity> page = orgApplyService.queryPage(param,false);
        IPage<OrgApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表（待登记）
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAlreadyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryAlreadyList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //param.getParams().put("currentProcessor", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.NE,  InvocationInfoProxy.getUsercode()));
            }
            param.getParams().remove("hasMyRegist");
        }
        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 指派
     * @param applyId
     * @param userId
     * @param userName
     * @return
     */
    @RequestMapping(value = "/assignTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assignTask(@RequestBody Map<String,String> param) {
        OrgApplyEntity orgApplyEntity =orgApplyService.getById(param.get("applyId"));
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);

        String[] receivers = new String[]{param.get("userId").toString()};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("notice");
        parameter.setSubject("您有一个新的指派处理：【产权登记指派 】   公司："+orgApplyEntity.getName());// 标题
        String url = baseHost + "ejc-sddjsorg-frontend/#/propertyRightRegistration";
        parameter.setContent("您有一个新的指派处理：【产权登记登记指派 】   公司："+orgApplyEntity.getName()+"。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
        return service.assignTask(param);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelStayExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelStayExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.NE,  InvocationInfoProxy.getUsercode()));
            }
            param.getParams().remove("hasMyRegist");
        }
        param.getParams().put("productionState", new Parameter(QueryParam.IN, "unregistered,registering"));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "filed"));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgApplyEntity> list = orgApplyService.queryList(param);
        List<OrgApplyVO> orgApplyVOList = BeanMapper.mapList(list, OrgApplyVO.class);
        for(OrgApplyVO r : orgApplyVOList){
            if(StringUtils.isNotEmpty(r.getProductionState())){
                if(r.getProductionState().equals("unregistered")){
                    r.setProductionState("未登记");
                }else if(r.getProductionState().equals("registered")){
                    r.setProductionState("已登记");
                }else if(r.getProductionState().equals("registering")){
                    r.setProductionState("登记中");
                }else if(r.getProductionState().equals("noregister")){
                    r.setProductionState("不登记");
                }
            }
            if(StringUtils.isNotEmpty(r.getApplyType())){
                if("set".equals(r.getApplyType())){
                    r.setApplyTypeName("设立申请");
                }else if("change".equals(r.getApplyType())){
                    r.setApplyTypeName("变更申请");
                }else if("del".equals(r.getApplyType())){
                    r.setApplyTypeName("注销申请");
                }else if("merge".equals(r.getApplyType())){
                    r.setApplyTypeName("合并申请");
                }else if("divide".equals(r.getApplyType())){
                    r.setApplyTypeName("分立申请");
                }else if("supplementary".equals(r.getApplyType())){
                    r.setApplyTypeName("补录申请");
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelAlreadyExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelAlreadyExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ProductionEntity> page = service.queryPage(param,false);
        List<ProductionVO> voList =  BeanMapper.mapList(page.getRecords(), ProductionVO.class);
        for (ProductionVO r:voList){
            r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
            if(StringUtils.isNotEmpty(r.getApplyType())){
                if("set".equals(r.getApplyType())){
                    r.setApplyTypeName("设立");
                }else if("change".equals(r.getApplyType())){
                    r.setApplyTypeName("变更");
                }else if("del".equals(r.getApplyType())){
                    r.setApplyTypeName("注销");
                }else if("merge".equals(r.getApplyType())){
                    r.setApplyTypeName("合并");
                }else if("divide".equals(r.getApplyType())){
                    r.setApplyTypeName("分立");
                }else if("supplementary".equals(r.getApplyType())){
                    r.setApplyTypeName("补录");
                }
            }

            if(r.getInReacrd() != null){
                if(r.getInReacrd().equals(true)){
                    r.setInReacrdName("备案");
                }else{
                    r.setInReacrdName("未备案");
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("production-register-export.xlsx", beans, response);

    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProductionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> refProductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("registerCountryName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgApplyEntity> list = orgApplyService.queryList(param);
        List<OrgApplyVO> orgApplyVOList = BeanMapper.mapList(list, OrgApplyVO.class);
        for(OrgApplyVO r : orgApplyVOList){
            if(StringUtils.isNotEmpty(r.getProductionState())){
                switch (r.getProductionState()){
                    case "unregistered":
                        r.setProductionState("未登记");
                    case "registered":
                        r.setProductionState("已登记");
                    case "registering":
                        r.setProductionState("登记中");
                    case "noregister":
                        r.setProductionState("不登记");
                }
            }
            if(StringUtils.isNotEmpty(r.getApplyType())){
                if("set".equals(r.getApplyType())){
                    r.setApplyTypeName("设立申请");
                }else if("change".equals(r.getApplyType())){
                    r.setApplyTypeName("变更申请");
                }else if("del".equals(r.getApplyType())){
                    r.setApplyTypeName("注销申请");
                }else if("merge".equals(r.getApplyType())){
                    r.setApplyTypeName("合并申请");
                }else if("divide".equals(r.getApplyType())){
                    r.setApplyTypeName("分立申请");
                }else if("supplementary".equals(r.getApplyType())){
                    r.setApplyTypeName("补录申请");
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", orgApplyVOList);
        ExcelExport.getInstance().export("production-stay-export.xlsx", beans, response);
    }
}
