package com.ejianc.business.sddjsorg.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 组织机构申请单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("orgApply")
public class OrgApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${common.env.base-host}")
	private String baseHost;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sddjs-org-apply";//此处需要根据实际修改

    @Autowired
    private IOrgApplyService service;
    @Autowired
    private IOrgShareholderService orgShareholderService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IPushMessageApi pushMessageApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrgApplyVO> saveOrUpdate(@RequestBody OrgApplyVO saveorUpdateVO) {
    	if("set".equals(saveorUpdateVO.getApplyType())||"supplementary".equals(saveorUpdateVO.getApplyType())){
        	this.checkRepetition(saveorUpdateVO);
    	}
    	OrgApplyEntity entity = BeanMapper.map(saveorUpdateVO, OrgApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setProductionState("unregistered");//登记状态 未登记
            entity.setProductionNum(0);//发生产权登记单数量
        }
    	service.saveOrUpdate(entity, false);
    	OrgApplyVO vo = BeanMapper.map(entity, OrgApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    public void checkRepetition(OrgApplyVO saveorUpdateVO) {
    	//校验公司名称
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ,saveorUpdateVO.getName()));
        List<String> applyType = new ArrayList<>();
        applyType.add("set");//设立申请
        applyType.add("supplementary");//补录申请
        queryParam.getParams().put("applyType", new Parameter(QueryParam.IN,applyType));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        if(saveorUpdateVO.getId()!=null){
        	queryParam.getParams().put("id", new Parameter(QueryParam.NE,saveorUpdateVO.getId()));
        }
        List<OrgApplyEntity> list = service.queryList(queryParam, false);
        if(list!=null&&list.size()>0){
            //已存在，不允许修改
            throw new BusinessException("保存失败！已经存在公司名称为["+saveorUpdateVO.getName()+"]的组织机构");
        }
        //校验统一社会信用代码
        if(StringUtils.isNotBlank(saveorUpdateVO.getUnifiedSocialCreditCode())){
        	QueryParam queryParamCode = new QueryParam();
            queryParamCode.getParams().put("unifiedSocialCreditCode", new Parameter(QueryParam.EQ,saveorUpdateVO.getUnifiedSocialCreditCode()));
            queryParamCode.getParams().put("applyType", new Parameter(QueryParam.IN,applyType));
            queryParamCode.getParams().put("tenantId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
            if(saveorUpdateVO.getId()!=null){
            	queryParamCode.getParams().put("id", new Parameter(QueryParam.NE,saveorUpdateVO.getId()));
            }
            List<OrgApplyEntity> listCode = service.queryList(queryParamCode, false);
            if(listCode!=null&&listCode.size()>0){
                //已存在，不允许修改
                throw new BusinessException("保存失败！已经存在统一社会信用代码为["+saveorUpdateVO.getUnifiedSocialCreditCode()+"]的组织机构");
            }
        }
        
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryDetail(Long id) {
    	OrgApplyEntity entity = service.selectById(id);
    	OrgApplyVO vo = BeanMapper.map(entity, OrgApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgApplyVO> vos) {
        service.removeByIds(vos.stream().map(OrgApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OrgApplyEntity> page = service.queryPage(param,false);
        IPage<OrgApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("nameShortCn");
        fuzzyFields.add("nameShortEn");
        fuzzyFields.add("orgNatureName");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("registerAreaName");
        fuzzyFields.add("actingHolderName");
        String type = "";
        if(param.getParams().get("type") != null){
        	type = param.getParams().get("type").getValue().toString();
        	param.getParams().remove("type");
        }
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        
        List<OrgApplyEntity> list = service.queryList(param);
        List<OrgApplyVO> vos = BeanMapper.mapList(list, OrgApplyVO.class);
        //todo:字段翻译等等
        for(OrgApplyVO vo : vos){
        	if("set".equals(vo.getApplyType())){
        		vo.setApplyTypeName("设立申请");
        	}else if("change".equals(vo.getApplyType())){
        		vo.setApplyTypeName("变更申请");
        	}else if("del".equals(vo.getApplyType())){
        		vo.setApplyTypeName("注销申请");
        	}else if("merge".equals(vo.getApplyType())){
        		vo.setApplyTypeName("合并申请");
        	}else if("divide".equals(vo.getApplyType())){
        		vo.setApplyTypeName("分立申请");
        	}else if("supplementary".equals(vo.getApplyType())){
        		vo.setApplyTypeName("补录申请");
        	}
        	vo.setCreateDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss", vo.getCreateTime()));
        	if(vo.getPendingStartTime()!=null){
        		vo.setPendingStartDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss", vo.getPendingStartTime()));
        	}
        	if(vo.getFileTime()!=null){
        		vo.setFileDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss", vo.getFileTime()));
        	}

            if(StringUtils.isNotEmpty(vo.getProductionState())){
                if(vo.getProductionState().equals("unregistered")){
                    vo.setProductionStateName("未登记");
                }else if(vo.getProductionState().equals("registered")){
                    vo.setProductionStateName("已登记");
                }else if(vo.getProductionState().equals("registering")){
                    vo.setProductionStateName("登记中");
                }else if(vo.getProductionState().equals("noregister")){
                    vo.setProductionStateName("不登记");
                }
            }

        	if(vo.getBillState()==0){
        		vo.setBillStateName("自由态");
        	}else if(vo.getBillState()==1){
        		vo.setBillStateName("已提交");
        	}else if(vo.getBillState()==2){
        		vo.setBillStateName("审批中");
        	}else if(vo.getBillState()==3){
        		vo.setBillStateName("审批通过");
        	}else if(vo.getBillState()==4){
        		vo.setBillStateName("审批驳回");
        	}else if(vo.getBillState()==5){
        		vo.setBillStateName("审批中");
        	}


        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);

        String fileName = "orgApplyExport.xlsx";
        if (StringUtils.isNotBlank(type)) {
            //申请中
            if ("apply".equals(type)) {
                fileName = "orgApplyExport.xlsx";
            }
            //待归档
            if ("toFile".equals(type)) {
                fileName = "orgTofileExport.xlsx";
            }
            //已归档
            if ("filed".equals(type)) {
                fileName = "orgFiledExport.xlsx";
            }
        }
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOrgApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> refOrgApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OrgApplyEntity> page = service.queryPage(param,false);
        IPage<OrgApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
	}

    /**
     * @Description 参照--股东信息表
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOrgShareholderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrgShareholderVO>> refOrgShareholderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("orgApplyId")!=null){
                param.getParams().put("pid", new Parameter(QueryParam.EQ, _con.get("orgApplyId").toString()));
            }else{
            	return CommonResponse.success("查询参照数据失败，组织机构申请id不能为空");
            }
        }else{
        	return CommonResponse.success("查询参照数据失败，组织机构申请id不能为空");
        }

        IPage<OrgShareholderEntity> page = orgShareholderService.queryPage(param,false);
        IPage<OrgShareholderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgShareholderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
	}

	/**
     * @Description queryDetail 归档
     * @param id
     */
    @RequestMapping(value = "/file", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> file(Long id) {
    	
        return service.file(id);
    }

	/**
     * @Description queryDetail 取消归档
     * @param id
     */
    @RequestMapping(value = "/unfile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> unfile(Long id) {
    	
        return service.unfile(id);
    }
    
    /**
     * @Description saveOrUpdate 指派
     */
    @RequestMapping(value = "/assign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody OrgApplyVO saveorUpdateVO) {
    	OrgApplyEntity entity = service.selectById(saveorUpdateVO.getId());
    	entity.setCurrentProcessor(saveorUpdateVO.getCurrentProcessor());
    	entity.setCurrentProcessorName(saveorUpdateVO.getCurrentProcessorName());
    	entity.setPendingStartTime(new Date());
    	service.saveOrUpdate(entity, false);
    	
    	//发送信息给指派人
    	logger.info("发送消息开始！===========");
		PushMsgParameter parameter = new PushMsgParameter();
		List<String> channel = new ArrayList<>();
		// 系统消息
		channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        
		String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
		parameter.setReceivers(receivers);// 收信人
		parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
		parameter.setMsgType("notice");
		parameter.setSubject("您有一个新的指派待处理：【组织机构设立申请】   公司："+entity.getName());// 标题
        String url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/setApplyCard?id="+entity.getId();
        parameter.setContent("您有一个新的指派待处理：【组织机构设立申请】   公司："+entity.getName()+"。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        if("change".equals(saveorUpdateVO.getApplyType())){//变更
            url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/changeCard?id="+entity.getId();
            parameter.setSubject("您有一个新的指派待处理：【组织机构变更申请】   公司："+entity.getName());// 标题
            parameter.setContent("您有一个新的指派待处理：【组织机构变更申请】   公司："+entity.getName()+"。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        }
        if("del".equals(saveorUpdateVO.getApplyType())){//变更
            url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id="+entity.getId();
            parameter.setSubject("您有一个新的指派待处理：【组织机构注销申请】   公司："+entity.getName());// 标题
            parameter.setContent("您有一个新的指派待处理：【组织机构注销申请】   公司："+entity.getName()+"。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        }
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setSendUserId(InvocationInfoProxy.getUserid());
		try {
			CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
			if (result.isSuccess()) {
				logger.error("消息发送成功---------------->" + result.getMsg());
			} else {
				logger.error("消息发送失败---------------->" + result.getMsg());
			}
		} catch (Exception e) {
			logger.error("调用消息中心RPC服务异常--------------" + e);
		}
    	return CommonResponse.success("指派成功！");
    }

    /**
     * @Description saveOrUpdate 补充信息
     */
    @RequestMapping(value = "/supplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrgApplyVO> supplement(@RequestBody OrgApplyVO saveorUpdateVO) {
    	if("set".equals(saveorUpdateVO.getApplyType())||"supplementary".equals(saveorUpdateVO.getApplyType())){
        	this.checkRepetition(saveorUpdateVO);
    	}
    	OrgApplyEntity entity = BeanMapper.map(saveorUpdateVO, OrgApplyEntity.class);
    	service.saveOrUpdate(entity, false);
    	
    	//发送信息给指派人
    	logger.info("发送消息开始！===========");
		PushMsgParameter parameter = new PushMsgParameter();
		List<String> channel = new ArrayList<>();
		// 系统消息
		channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        
		String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
		parameter.setReceivers(receivers);// 收信人
		parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
		parameter.setMsgType("notice");
		parameter.setSubject("【组织机构设立申请】   公司："+entity.getName()+"已完成补充信息");// 标题
		String url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/setApplyCard?id="+entity.getId();
        parameter.setContent("【组织机构设立申请】   公司："+entity.getName()+"已完成补充信息。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        if("change".equals(saveorUpdateVO.getApplyType())){//变更
            url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/changeCard?id="+entity.getId();
            parameter.setSubject("【组织机构变更申请】   公司："+entity.getName()+"已完成补充信息");// 标题
            parameter.setContent("【组织机构变更申请】   公司："+entity.getName()+"已完成补充信息。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        }
        if("del".equals(saveorUpdateVO.getApplyType())){//变更
            url = baseHost + "ejc-sddjsorg-frontend/#/orgApply/cancellationCard?id="+entity.getId();
            parameter.setSubject("【组织机构注销申请】   公司："+entity.getName()+"已完成补充信息");// 标题
            parameter.setContent("【组织机构注销申请】   公司："+entity.getName()+"已完成补充信息。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
        }
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setSendUserId(InvocationInfoProxy.getUserid());
		try {
			CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
			if (result.isSuccess()) {
				logger.error("消息发送成功---------------->" + result.getMsg());
			} else {
				logger.error("消息发送失败---------------->" + result.getMsg());
			}
		} catch (Exception e) {
			logger.error("调用消息中心RPC服务异常--------------" + e);
		}
    	OrgApplyVO vo = BeanMapper.map(entity, OrgApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryNumber", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryNumber() {
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
    	List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
    	//申请中
    	QueryWrapper<OrgApplyEntity> applyingWrapper = new QueryWrapper<>();
    	List<String> applyType = new ArrayList<>();
    	applyType.add("set");
    	applyType.add("change");
    	applyType.add("del");
    	applyType.add("merge");
    	applyType.add("divide");
		applyingWrapper.in("apply_type", applyType );
    	List<Integer> billState = new ArrayList<>();
    	billState.add(0);
    	billState.add(2);
    	billState.add(5);
		applyingWrapper.in("bill_state", billState );
		applyingWrapper.eq("dr", 0);
		applyingWrapper.in("apply_org_id", orgIds);
    	Integer applyingNumber = service.count(applyingWrapper);
    	//待归档
    	QueryWrapper<OrgApplyEntity> tofileWrapper = new QueryWrapper<>();
    	tofileWrapper.in("apply_type", applyType );
    	tofileWrapper.eq("file_state", "toFile" );
    	tofileWrapper.eq("dr", 0);
    	tofileWrapper.in("apply_org_id", orgIds);
    	Integer tofileNumber = service.count(tofileWrapper);
    	//已归档
    	QueryWrapper<OrgApplyEntity> filedWrapper = new QueryWrapper<>();
    	filedWrapper.in("apply_type", applyType );
    	filedWrapper.eq("file_state", "filed" );
    	filedWrapper.eq("dr", 0);
    	filedWrapper.in("apply_org_id", orgIds);
    	Integer filedNumber = service.count(filedWrapper);
    	JSONObject json = new JSONObject();
    	json.put("applyingNumber", applyingNumber);
    	json.put("tofileNumber", tofileNumber);
    	json.put("filedNumber", filedNumber);
        return CommonResponse.success("查询详情数据成功！",json);
    }
}
