package com.ejianc.business.production.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.production.bean.AcquisitionEquityEntity;
import com.ejianc.business.production.bean.CapitalEntity;
import com.ejianc.business.production.bean.CapitalReductionEntity;
import com.ejianc.business.production.bean.ConformanceContentEntity;
import com.ejianc.business.production.bean.CurrencyEntity;
import com.ejianc.business.production.bean.NoneCurrencyEntity;
import com.ejianc.business.production.bean.ReformNewShareholderEntity;
import com.ejianc.business.production.bean.ResidualPropertyEntity;
import com.ejianc.business.production.bean.TransferInfoEntity;
/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sddjsorg_production")
public class ProductionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private java.lang.String code; // 登记单号
    @TableField(value="name")
    private java.lang.String name; // 名称
    @TableField(value="unified_social_credit_code")
    private java.lang.String unifiedSocialCreditCode; // 统一社会信用代码
    @TableField(value="in_reacrd")
    private Boolean inReacrd; // 是否在集团备案
    @TableField(value="out_capital_org")
    private java.lang.String outCapitalOrg; // 国家出资企业id
    @TableField(value="out_capital_org_name")
    private java.lang.String outCapitalOrgName; // 国家出资企业名称
    @TableField(value="relation_to_out_org")
    private java.lang.Long relationToOutOrg; // 与国家出资企业的关系id
    @TableField(value="relation_to_out_org_name")
    private java.lang.String relationToOutOrgName; // 与国家出资企业的关系名称
    @TableField(value="be_owner")
    private java.lang.Boolean beOwner; // 是否国家出资企业业主
    @TableField(value="main_capital_org_id")
    private java.lang.Long mainCapitalOrgId; // 主要出资人id
    @TableField(value="main_capital_org_name")
    private java.lang.String mainCapitalOrgName; // 主要出资人名称
    @TableField(value="register_country_id")
    private java.lang.Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private java.lang.String registerCountryName; // 注册国家名称
    @TableField(value="register_in")
    private java.lang.String registerIn; // 注册地境内/境外
    @TableField(value="register_address")
    private java.lang.String registerAddress; // 注册地
    @TableField(value="date_incorporation")
    private java.util.Date dateIncorporation; // 注册日期
    @TableField(value="register_capital")
    private java.math.BigDecimal registerCapital; // 注册资本
    @TableField(value="currency_type_id")
    private java.lang.Long currencyTypeId; // 注册资本币种id
    @TableField(value="currency_type_name")
    private java.lang.String currencyTypeName; // 注册资本币种名称
    @TableField(value="register_capital_big")
    private java.lang.String registerCapitalBig; // 注册资本大写
    @TableField(value="org_type_id")
    private java.lang.Long orgTypeId; // 企业类别id
    @TableField(value="org_type")
    private java.lang.String orgType; // 企业类别
    @TableField(value="org_type_name")
    private java.lang.String orgTypeName; // 企业类别名称
    @TableField(value="regulatory_bodies_id")
    private java.lang.String regulatoryBodiesId; // 国资监管机构id


    @TableField(value="regulatory_bodies")
    private java.lang.String regulatoryBodies; // 国资监管机构
    @TableField(value="org_form_id")
    private java.lang.Long orgFormId; // 组织形式
    @TableField(value="org_form")
    private java.lang.String orgForm; // 组织形式
    @TableField(value="org_form_name")
    private java.lang.String orgFormName; // 组织形式
    @TableField(value="major_industries_id")
    private java.lang.String majorIndustriesId; // 主要行业
    @TableField(value="major_industries")
    private java.lang.String majorIndustries; // 主要行业
    @TableField(value="product_level")
    private java.lang.String productLevel; // 企业产权级次
    @TableField(value="manger_level")
    private java.lang.String mangerLevel; // 企业管理级次
    @TableField(value="merge_table")
    private Boolean mergeTable; // 是否并表
    @TableField(value="be_listed")
    private Boolean beListed; // 是否上市公司
    @TableField(value="be_closed")
    private java.lang.Boolean beClosed; // 是否存在休眠/停业/歇业等情况
    @TableField(value="decision_program")
    private java.lang.String decisionProgram; // 决策或批复程序
    private String decisionProgramName;// 决策或批复程序名称
    @TableField(value="decision_date")
    private java.util.Date decisionDate; // 决策或批复日期
    @TableField(value="no_economic_behavior")
    private java.lang.String noEconomicBehavior; // 无经济行为决策或批复文件理由描述
    @TableField(value="decision_other_memo")
    private java.lang.String decisionOtherMemo; // 经济行为决策或批复文件-其他说明情况
    @TableField(value="acquirer")
    private java.lang.Long acquirer; // 收购方名称
    @TableField(value="acquirer_name")
    private java.lang.String acquirerName; // 收购方名称
    @TableField(value="acquirer_unicode")
    private java.lang.String acquirerUnicode; // 收购方统一社会信用代码
    @TableField(value="proportion_transferred_equity")
    private java.math.BigDecimal proportionTransferredEquity; // 转让股权比例
    @TableField(value="has_central_enterprises_funded")
    private java.lang.Boolean hasCentralEnterprisesFunded; // 标的企业是否有央企出资
    @TableField(value="asset_appraisal_filing_no")
    private java.lang.String assetAppraisalFilingNo; // 资产评估备案编号
    @TableField(value="assessed_value_net_assets")
    private java.math.BigDecimal assessedValueNetAssets; // 净资产评估值
    @TableField(value="assessed_value_net_assets_big")
    private String assessedValueNetAssetsBig; // 净资产评估值(大写)
    @TableField(value="capital_increase")
    private java.lang.Long capitalIncrease; // 增资情形
    @TableField(value="capital_increase_name")
    private java.lang.String capitalIncreaseName; // 增资情形
    @TableField(value="asset_appraisal_filing_num")
    private java.lang.String assetAppraisalFilingNum; // 资产评估备案编号
    @TableField(value="capital_assessed_value_assets")
    private java.math.BigDecimal capitalAssessedValueAssets; // 增资企业净资产评估值
    @TableField(value="capital_equivalent")
    private java.math.BigDecimal capitalEquivalent; // 增资评估折合(元/注册资本)
    @TableField(value="capital_equivalent_big")
    private java.lang.String capitalEquivalentBig; // 增资评估折合(元/注册资本)(大写)
    @TableField(value="capital_increase_price")
    private java.math.BigDecimal capitalIncreasePrice; // 增资价格(元/注册资本)
    @TableField(value="capital_increase_price_big")
    private java.lang.String capitalIncreasePriceBig; // 增资价格(元/注册资本)(大写)
    @TableField(value="has_assessment_filing_form")
    private java.lang.Boolean hasAssessmentFilingForm; // 有无评估备案表或核准文件
    @TableField(value="intermediary")
    private java.lang.String intermediary; // 中介结构名称
    @TableField(value="appraisal_report_no")
    private java.lang.String appraisalReportNo; // 评估报告号
    @TableField(value="filing_approval_org")
    private java.lang.String filingApprovalOrg; // 备案或核准单位名称
    @TableField(value="filing_approval_code")
    private java.lang.String filingApprovalCode; // 备案号或核准文件号
    @TableField(value="capital_other_memo")
    private java.lang.String capitalOtherMemo; // 标的企业-其他需说明的情况
    @TableField(value="reduction_capital_id")
    private java.lang.Long reductionCapitalId; // 减资情形ID
    @TableField(value="reduction_capital")
    private java.lang.String reductionCapital; // 减资情形
    @TableField(value="reduction_capital_total")
    private java.math.BigDecimal reductionCapitalTotal; // 减少资本总额
    @TableField(value="reduction_capital_total_big")
    private java.lang.String reductionCapitalTotalBig; // 减少资本总额(大写)
    @TableField(value="reduction_capital_pricing_basis")
    private java.lang.String reductionCapitalPricingBasis; // 作价依据
    @TableField(value="central_enterprises_all_out")
    private java.lang.Boolean centralEnterprisesAllOut; // 减资-中央企业出资人是否全部退出
    @TableField(value="reduction_capital_value_assets")
    private java.math.BigDecimal reductionCapitalValueAssets; // 减资企业净资产评估值
    @TableField(value="reduction_capital_value_assets_big")
    private java.lang.String reductionCapitalValueAssetsBig; // 减资企业净资产评估值(大写)
    @TableField(value="has_employee_congress")
    private java.lang.Boolean hasEmployeeCongress; // 有无职工代表大会决议
    @TableField(value="employee_congress_opinions")
    private java.lang.String employeeCongressOpinions; // 职工代表大会意见
    @TableField(value="employee_congress_other_memo")
    private java.lang.String employeeCongressOtherMemo; // 职工代表大会-其他需说明的情况
    @TableField(value="transfer_type")
    private java.lang.String transferType; // 划转类型
    @TableField(value="transfer_type_name")
    private java.lang.String transferTypeName; // 划转类型名称
    @TableField(value="registration_property_rights")
    private java.lang.String registrationPropertyRights; // 产权登记情形
    @TableField(value="registration_property_rights_id")
    private java.lang.Long registrationPropertyRightsId; // 产权登记情形Id
    @TableField(value="introduction_new_shareholders")
    private java.lang.Boolean introductionNewShareholders; // 是否引入新股东-改制
    @TableField(value="reform_org_net_assets_audit")
    private java.math.BigDecimal reformOrgNetAssetsAudit; // 改制企业净资产审计值
    @TableField(value="reform_org_net_assets_audit_big")
    private java.lang.String reformOrgNetAssetsAuditBig; // 改制企业净资产审计值(大写)
    @TableField(value="has_non_monetary_contribution")
    private java.lang.Boolean hasNonMonetaryContribution; // 有无非货币出资
    @TableField(value="has_property_distribution")
    private java.lang.Integer hasPropertyDistribution; // 有无财产分配情况
    @TableField(value="production_type_name")
    private java.lang.String productionTypeName; // 产权登记单类型名称：
    @TableField(value="production_type_code")
    private java.lang.String productionTypeCode; // 产权登记单类型编码：
    @TableField(value="source_apply_id")
    private java.lang.Long sourceApplyId; // 产权登记单来源于哪个申请单
    @TableField(value="org_id")
    private java.lang.Long orgId; // 创建单据组织id
    @TableField(value="create_user_name")
    private java.lang.String createUserName; // 创建人
    @TableField(value="apply_type")
    private String applyType; //登记属性  即申请单类型 ，set:设立，change：变更，del：注销，merge：合并，divide：分立，supplementary:补录
    @TableField(value="route_url")
    private String routeUrl;//路由url
    @TableField(value="use_status")
    private Boolean useStatus;//使用状态
    @TableField(value="investors_before")
    private String investorsBefore;
    @TableField(value="investors_after")
    private String investorsAfter;
    @TableField(value="history_record")
    private String historyRecord;

    private java.lang.Long initiatorId; // 发起方企业id
    @TableField(value="initiator_name")
    private java.lang.String initiatorName; // 发起方企业名称
    @TableField(value="initiator_unified_social_credit_code")//发起方信用代码
    private String initiatorUnifiedSocialCreditCode;
    @TableField(value="invested_enterprise_valuation_filing_code")
    private java.lang.String investedEnterpriseValuationFilingCode; // 被投资企业的资产评估备案编号
    @TableField(value="invested_enterprise_assets_appraisal_value")
    private java.math.BigDecimal investedEnterpriseAssetsAppraisalValue; // 被投资企业净资产评估值
    @TableField(value="invested_enterprise_assets_appraisal_value_big")
    private java.lang.String investedEnterpriseAssetsAppraisalValueBig; // 被投资企业净资产评估值(大写)
    @TableField(value="funded_enterprise_equity_ratio")
    private java.math.BigDecimal fundedEnterpriseEquityRatio; // 出资企业因本次股权投资占被投资企业股权比例
    @TableField(value="involving_invested_enterprises_contribution")
    private java.lang.Boolean involvingInvestedEnterprisesContribution; // 是否涉及被投资企业主要出资人变动
    @TableField(value="involving_invested_enterprises_share_contribution")
    private java.lang.Boolean involvingInvestedEnterprisesShareContribution; // 是否涉及用于股权投资的企业主要出资人变动
    @TableField(value="approval_there_assessment_record_document")
    private java.lang.Boolean approvalThereAssessmentRecordDocument; // 有无评估备案表或核准文件
    @TableField(value="approval_intermediary_structure_name")
    private java.lang.String approvalIntermediaryStructureName; // 中介结构名称
    @TableField(value="approval_record_or_approved_name")
    private java.lang.String approvalRecordOrApprovedName; // 备案或核准单位名称
    @TableField(value="approval_record_or_approved_file")
    private java.lang.String approvalRecordOrApprovedFile; // 备案号或核准文件号
    @TableField(value="approval_other_requiring_explanation")
    private java.lang.String approvalOtherRequiringExplanation; // 其他需说明的情况
    @TableField(value="none_currency_there_assessment_record_document")
    private java.lang.Boolean noneCurrencyThereAssessmentRecordDocument; // 非货币-有无评估备案表或核准文件
    @TableField(value="none_currency_intermediary_structure_name")
    private java.lang.String noneCurrencyIntermediaryStructureName; // 非货币--中介结构名称
    @TableField(value="none_currency_record_or_approved_name")
    private java.lang.String noneCurrencyRecordOrApprovedName; // 非货币---备案或核准单位名称
    @TableField(value="none_currency_record_or_approved_file")
    private java.lang.String noneCurrencyRecordOrApprovedFile; // 非货币---备案号或核准文件号
    @TableField(value="none_currency_evaluation_report_no")
    private java.lang.String noneCurrencyEvaluationReportNo; // 评估报告号
    @TableField(value="none_currency_other_requiring_explanation")
    private java.lang.String noneCurrencyOtherRequiringExplanation; // 非货币---其他需说明的情况
    @TableField(value="investment_amount")
    private java.math.BigDecimal investmentAmount; // 投资金额
    @TableField(value="investment_amount_big")
    private String investmentAmountBig; // 投资金额大写
    @TableField(value="equity_ratio")
    private BigDecimal equityRatio; // 股权比例
    @TableField(value="transaction_org_name")
    private java.lang.String transactionOrgName; // 产权交易机构名称
    @TableField(value="transaction_project_code")
    private java.lang.String transactionProjectCode; // 项目编号
    @TableField(value="transaction_end_date")
    private java.util.Date transactionEndDate; // 项目发布/截止日期
    @TableField(value="listing_price")
    private java.math.BigDecimal listingPrice; // 挂牌价格
    @TableField(value="transaction_price")
    private BigDecimal transactionPrice;//成交价格
    @TableField(value="transaction_price_big")
    private String transactionPriceBig;//成交价格(大写)

    @TableField(value="declare_enterprise_type")
    private java.lang.String declareEnterpriseType; // 申报企业类型
    @TableField(value="transferee_nature")
    private java.lang.String transfereeNature; // 受让性质
    @TableField(value="transferee_enterprise_id")
    private java.lang.Long transfereeEnterpriseId; //  受让方企业id
    @TableField(value="transferee_enterprise_name")
    private java.lang.String transfereeEnterpriseName; // 受让方企业名称
    @TableField(value="transferee_unified_social_credit_code")
    private java.lang.String transfereeUnifiedSocialCreditCode; // 受让方统一社会信用代码
    @TableField(value="pricing_basis")
    private java.lang.String pricingBasis; // 作价依据
    @TableField(value="transferee_type")
    private java.lang.String transfereeType; // 转让类型
    @TableField(value="in_use_org_id")
    private Long inUseOrgId; // 在用组织id
    @TableField(exist=false)
    @SubEntity(serviceName="acquisitionEquityService")
    private List<AcquisitionEquityEntity> acquisitionEquityEntities = new ArrayList<>(); // 产权登记-收购股权明细
    @TableField(exist=false)
    @SubEntity(serviceName="capitalService")
    private List<CapitalEntity> capitalEntities = new ArrayList<>(); // 产权登记--资本状况
    @TableField(exist=false)
    @SubEntity(serviceName="capitalReductionService")
    private List<CapitalReductionEntity> capitalReductionEntities = new ArrayList<>(); // 产权登记-减资方情况
    @TableField(exist=false)
    @SubEntity(serviceName="conformanceContentService")
    private List<ConformanceContentEntity> conformanceContentEntities = new ArrayList<>(); // 产权登记-合规性目录
    @TableField(exist=false)
    @SubEntity(serviceName="currencyService")
    private List<CurrencyEntity> currencyEntities = new ArrayList<>(); // 产权登记-货币出资情况
    @TableField(exist=false)
    @SubEntity(serviceName="noneCurrencyService")
    private List<NoneCurrencyEntity> noneCurrencyEntities = new ArrayList<>(); // 产权登记-非货币出资
    @TableField(exist=false)
    @SubEntity(serviceName="reformNewShareholderService")
    private List<ReformNewShareholderEntity> reformNewShareholderEntities = new ArrayList<>(); // 产权登记-改制新股东
    @TableField(exist=false)
    @SubEntity(serviceName="residualPropertyService")
    private List<ResidualPropertyEntity> residualPropertyEntities = new ArrayList<>(); // 产权登记-剩余财产分配情况
    @TableField(exist=false)
    @SubEntity(serviceName="transferInfoService")
    private List<TransferInfoEntity> transferInfoEntities = new ArrayList<>(); // 产权登记-划转方案信息

    @TableField(exist=false)
    @SubEntity(serviceName="investorsService")
    private List<InvestorsEntity> investorsEntities = new ArrayList<>(); // 产权登记-出资人情况
    /*@TableField(exist=false)
    @SubEntity(serviceName="transfererService")
    private List<TransfererEntity> transfererEntities = new ArrayList<>(); //转让方
    @TableField(exist=false)
    @SubEntity(serviceName="transferorService")
    private List<TransferorEntity> transferorEntities = new ArrayList<>(); //受让方*/
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    /**
     * 名称
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 名称
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 统一社会信用代码
     */
    public java.lang.String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setUnifiedSocialCreditCode(java.lang.String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }
    /**
     * 是否在集团备案
     */
    public Boolean getInReacrd() {
        return inReacrd;
    }

    public void setInReacrd(Boolean inReacrd) {
        this.inReacrd = inReacrd;
    }

    /**
     * 国家出资企业id
     */
    public String getOutCapitalOrg() {
        return outCapitalOrg;
    }

    public void setOutCapitalOrg(String outCapitalOrg) {
        this.outCapitalOrg = outCapitalOrg;
    }

    /**
     * 国家出资企业名称
     */
    public java.lang.String getOutCapitalOrgName() {
        return outCapitalOrgName;
    }

    /**
     * 国家出资企业名称
     */
    public void setOutCapitalOrgName(java.lang.String outCapitalOrgName) {
        this.outCapitalOrgName = outCapitalOrgName;
    }
    /**
     * 与国家出资企业的关系id
     */
    public Long getRelationToOutOrg() {
        return relationToOutOrg;
    }

    public void setRelationToOutOrg(Long relationToOutOrg) {
        this.relationToOutOrg = relationToOutOrg;
    }

    /**
     * 与国家出资企业的关系名称
     */
    public java.lang.String getRelationToOutOrgName() {
        return relationToOutOrgName;
    }

    /**
     * 与国家出资企业的关系名称
     */
    public void setRelationToOutOrgName(java.lang.String relationToOutOrgName) {
        this.relationToOutOrgName = relationToOutOrgName;
    }
    /**
     * 是否国家出资企业业主
     */
    public Boolean getBeOwner() {
        return beOwner;
    }

    public void setBeOwner(Boolean beOwner) {
        this.beOwner = beOwner;
    }

    /**
     * 主要出资人id
     */
    public java.lang.Long getMainCapitalOrgId() {
        return mainCapitalOrgId;
    }

    /**
     * 主要出资人id
     */
    public void setMainCapitalOrgId(java.lang.Long mainCapitalOrgId) {
        this.mainCapitalOrgId = mainCapitalOrgId;
    }
    /**
     * 主要出资人名称
     */
    public java.lang.String getMainCapitalOrgName() {
        return mainCapitalOrgName;
    }

    /**
     * 主要出资人名称
     */
    public void setMainCapitalOrgName(java.lang.String mainCapitalOrgName) {
        this.mainCapitalOrgName = mainCapitalOrgName;
    }
    /**
     * 注册国家id
     */
    public java.lang.Long getRegisterCountryId() {
        return registerCountryId;
    }

    /**
     * 注册国家id
     */
    public void setRegisterCountryId(java.lang.Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    /**
     * 注册国家名称
     */
    public java.lang.String getRegisterCountryName() {
        return registerCountryName;
    }

    /**
     * 注册国家名称
     */
    public void setRegisterCountryName(java.lang.String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    /**
     * 注册地境内/境外
     */
    public java.lang.String getRegisterIn() {
        return registerIn;
    }

    /**
     * 注册地境内/境外
     */
    public void setRegisterIn(java.lang.String registerIn) {
        this.registerIn = registerIn;
    }
    /**
     * 注册地
     */
    public java.lang.String getRegisterAddress() {
        return registerAddress;
    }

    /**
     * 注册地
     */
    public void setRegisterAddress(java.lang.String registerAddress) {
        this.registerAddress = registerAddress;
    }
    /**
     * 注册日期
     */
    public Date getDateIncorporation() {
        return dateIncorporation;
    }

    public void setDateIncorporation(Date dateIncorporation) {
        this.dateIncorporation = dateIncorporation;
    }

    /**
     * 注册资本
     */
    public java.math.BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    /**
     * 注册资本
     */
    public void setRegisterCapital(java.math.BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }
    /**
     * 注册资本币种id
     */
    public java.lang.Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    /**
     * 注册资本币种id
     */
    public void setCurrencyTypeId(java.lang.Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }
    /**
     * 注册资本币种名称
     */
    public java.lang.String getCurrencyTypeName() {
        return currencyTypeName;
    }

    /**
     * 注册资本币种名称
     */
    public void setCurrencyTypeName(java.lang.String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }
    /**
     * 注册资本大写
     */
    public java.lang.String getRegisterCapitalBig() {
        return registerCapitalBig;
    }

    /**
     * 注册资本大写
     */
    public void setRegisterCapitalBig(java.lang.String registerCapitalBig) {
        this.registerCapitalBig = registerCapitalBig;
    }
    /**
     * 企业类别id
     */
    public java.lang.Long getOrgTypeId() {
        return orgTypeId;
    }

    /**
     * 企业类别id
     */
    public void setOrgTypeId(java.lang.Long orgTypeId) {
        this.orgTypeId = orgTypeId;
    }
    /**
     * 企业类别名称
     */
    public java.lang.String getOrgTypeName() {
        return orgTypeName;
    }

    /**
     * 企业类别名称
     */
    public void setOrgTypeName(java.lang.String orgTypeName) {
        this.orgTypeName = orgTypeName;
    }

    public String getRegulatoryBodiesId() {
        return regulatoryBodiesId;
    }

    public void setRegulatoryBodiesId(String regulatoryBodiesId) {
        this.regulatoryBodiesId = regulatoryBodiesId;
    }

    /**
     * 国资监管机构
     */
    public java.lang.String getRegulatoryBodies() {
        return regulatoryBodies;
    }

    /**
     * 国资监管机构
     */
    public void setRegulatoryBodies(java.lang.String regulatoryBodies) {
        this.regulatoryBodies = regulatoryBodies;
    }
    /**
     * 组织形式
     */
    public java.lang.Long getOrgFormId() {
        return orgFormId;
    }

    /**
     * 组织形式
     */
    public void setOrgFormId(java.lang.Long orgFormId) {
        this.orgFormId = orgFormId;
    }
    /**
     * 组织形式
     */
    public java.lang.String getOrgFormName() {
        return orgFormName;
    }

    /**
     * 组织形式
     */
    public void setOrgFormName(java.lang.String orgFormName) {
        this.orgFormName = orgFormName;
    }
    /**
     * 主要行业
     */
    public String getMajorIndustriesId() {
        return majorIndustriesId;
    }

    public void setMajorIndustriesId(String majorIndustriesId) {
        this.majorIndustriesId = majorIndustriesId;
    }

    /**
     * 主要行业
     */
    public java.lang.String getMajorIndustries() {
        return majorIndustries;
    }

    /**
     * 主要行业
     */
    public void setMajorIndustries(java.lang.String majorIndustries) {
        this.majorIndustries = majorIndustries;
    }
    /**
     * 企业产权级次
     */
    public java.lang.String getProductLevel() {
        return productLevel;
    }

    /**
     * 企业产权级次
     */
    public void setProductLevel(java.lang.String productLevel) {
        this.productLevel = productLevel;
    }
    /**
     * 企业管理级次
     */
    public java.lang.String getMangerLevel() {
        return mangerLevel;
    }

    /**
     * 企业管理级次
     */
    public void setMangerLevel(java.lang.String mangerLevel) {
        this.mangerLevel = mangerLevel;
    }
    /**
     * 是否并表
     */
    public Boolean getMergeTable() {
        return mergeTable;
    }

    public void setMergeTable(Boolean mergeTable) {
        this.mergeTable = mergeTable;
    }

    /**
     * 是否上市公司
     */
    public Boolean getBeListed() {
        return beListed;
    }

    public void setBeListed(Boolean beListed) {
        this.beListed = beListed;
    }

    public Boolean getBeClosed() {
        return beClosed;
    }

    public void setBeClosed(Boolean beClosed) {
        this.beClosed = beClosed;
    }

    /**
     * 决策或批复程序
     */
    public String getDecisionProgram() {
        return decisionProgram;
    }

    public void setDecisionProgram(String decisionProgram) {
        this.decisionProgram = decisionProgram;
    }

    /**
     * 决策或批复日期
     */
    public java.util.Date getDecisionDate() {
        return decisionDate;
    }

    /**
     * 决策或批复日期
     */
    public void setDecisionDate(java.util.Date decisionDate) {
        this.decisionDate = decisionDate;
    }
    /**
     * 无经济行为决策或批复文件理由描述
     */
    public java.lang.String getNoEconomicBehavior() {
        return noEconomicBehavior;
    }

    /**
     * 无经济行为决策或批复文件理由描述
     */
    public void setNoEconomicBehavior(java.lang.String noEconomicBehavior) {
        this.noEconomicBehavior = noEconomicBehavior;
    }
    /**
     * 经济行为决策或批复文件-其他说明情况
     */
    public java.lang.String getDecisionOtherMemo() {
        return decisionOtherMemo;
    }

    /**
     * 经济行为决策或批复文件-其他说明情况
     */
    public void setDecisionOtherMemo(java.lang.String decisionOtherMemo) {
        this.decisionOtherMemo = decisionOtherMemo;
    }
    /**
     * 收购方名称
     */
    public java.lang.Long getAcquirer() {
        return acquirer;
    }

    /**
     * 收购方名称
     */
    public void setAcquirer(java.lang.Long acquirer) {
        this.acquirer = acquirer;
    }
    /**
     * 收购方名称
     */
    public java.lang.String getAcquirerName() {
        return acquirerName;
    }

    /**
     * 收购方名称
     */
    public void setAcquirerName(java.lang.String acquirerName) {
        this.acquirerName = acquirerName;
    }
    /**
     * 收购方统一社会信用代码
     */
    public java.lang.String getAcquirerUnicode() {
        return acquirerUnicode;
    }

    /**
     * 收购方统一社会信用代码
     */
    public void setAcquirerUnicode(java.lang.String acquirerUnicode) {
        this.acquirerUnicode = acquirerUnicode;
    }
    /**
     * 转让股权比例
     */
    public java.math.BigDecimal getProportionTransferredEquity() {
        return proportionTransferredEquity;
    }

    /**
     * 转让股权比例
     */
    public void setProportionTransferredEquity(java.math.BigDecimal proportionTransferredEquity) {
        this.proportionTransferredEquity = proportionTransferredEquity;
    }
    /**
     * 标的企业是否有央企出资
     */
    public Boolean getHasCentralEnterprisesFunded() {
        return hasCentralEnterprisesFunded;
    }

    public void setHasCentralEnterprisesFunded(Boolean hasCentralEnterprisesFunded) {
        this.hasCentralEnterprisesFunded = hasCentralEnterprisesFunded;
    }

    /**
     * 资产评估备案编号
     */
    public java.lang.String getAssetAppraisalFilingNo() {
        return assetAppraisalFilingNo;
    }

    /**
     * 资产评估备案编号
     */
    public void setAssetAppraisalFilingNo(java.lang.String assetAppraisalFilingNo) {
        this.assetAppraisalFilingNo = assetAppraisalFilingNo;
    }
    /**
     * 净资产评估值
     */
    public java.math.BigDecimal getAssessedValueNetAssets() {
        return assessedValueNetAssets;
    }

    /**
     * 净资产评估值
     */
    public void setAssessedValueNetAssets(java.math.BigDecimal assessedValueNetAssets) {
        this.assessedValueNetAssets = assessedValueNetAssets;
    }
    /**
     * 增资情形
     */
    public java.lang.Long getCapitalIncrease() {
        return capitalIncrease;
    }

    /**
     * 增资情形
     */
    public void setCapitalIncrease(java.lang.Long capitalIncrease) {
        this.capitalIncrease = capitalIncrease;
    }
    /**
     * 增资情形
     */
    public java.lang.String getCapitalIncreaseName() {
        return capitalIncreaseName;
    }

    /**
     * 增资情形
     */
    public void setCapitalIncreaseName(java.lang.String capitalIncreaseName) {
        this.capitalIncreaseName = capitalIncreaseName;
    }
    /**
     * 资产评估备案编号
     */
    public java.lang.String getAssetAppraisalFilingNum() {
        return assetAppraisalFilingNum;
    }

    /**
     * 资产评估备案编号
     */
    public void setAssetAppraisalFilingNum(java.lang.String assetAppraisalFilingNum) {
        this.assetAppraisalFilingNum = assetAppraisalFilingNum;
    }
    /**
     * 增资企业净资产评估值
     */
    public java.math.BigDecimal getCapitalAssessedValueAssets() {
        return capitalAssessedValueAssets;
    }

    /**
     * 增资企业净资产评估值
     */
    public void setCapitalAssessedValueAssets(java.math.BigDecimal capitalAssessedValueAssets) {
        this.capitalAssessedValueAssets = capitalAssessedValueAssets;
    }
    /**
     * 增资评估折合(元/注册资本)
     */
    public java.math.BigDecimal getCapitalEquivalent() {
        return capitalEquivalent;
    }

    /**
     * 增资评估折合(元/注册资本)
     */
    public void setCapitalEquivalent(java.math.BigDecimal capitalEquivalent) {
        this.capitalEquivalent = capitalEquivalent;
    }
    /**
     * 增资评估折合(元/注册资本)(大写)
     */
    public java.lang.String getCapitalEquivalentBig() {
        return capitalEquivalentBig;
    }

    /**
     * 增资评估折合(元/注册资本)(大写)
     */
    public void setCapitalEquivalentBig(java.lang.String capitalEquivalentBig) {
        this.capitalEquivalentBig = capitalEquivalentBig;
    }
    /**
     * 增资价格(元/注册资本)
     */
    public java.math.BigDecimal getCapitalIncreasePrice() {
        return capitalIncreasePrice;
    }

    /**
     * 增资价格(元/注册资本)
     */
    public void setCapitalIncreasePrice(java.math.BigDecimal capitalIncreasePrice) {
        this.capitalIncreasePrice = capitalIncreasePrice;
    }
    /**
     * 增资价格(元/注册资本)(大写)
     */
    public java.lang.String getCapitalIncreasePriceBig() {
        return capitalIncreasePriceBig;
    }

    /**
     * 增资价格(元/注册资本)(大写)
     */
    public void setCapitalIncreasePriceBig(java.lang.String capitalIncreasePriceBig) {
        this.capitalIncreasePriceBig = capitalIncreasePriceBig;
    }
    /**
     * 有无评估备案表或核准文件
     */
    public Boolean getHasAssessmentFilingForm() {
        return hasAssessmentFilingForm;
    }

    public void setHasAssessmentFilingForm(Boolean hasAssessmentFilingForm) {
        this.hasAssessmentFilingForm = hasAssessmentFilingForm;
    }

    /**
     * 中介结构名称
     */
    public java.lang.String getIntermediary() {
        return intermediary;
    }

    /**
     * 中介结构名称
     */
    public void setIntermediary(java.lang.String intermediary) {
        this.intermediary = intermediary;
    }
    /**
     * 评估报告号
     */
    public java.lang.String getAppraisalReportNo() {
        return appraisalReportNo;
    }

    /**
     * 评估报告号
     */
    public void setAppraisalReportNo(java.lang.String appraisalReportNo) {
        this.appraisalReportNo = appraisalReportNo;
    }
    /**
     * 备案或核准单位名称
     */
    public java.lang.String getFilingApprovalOrg() {
        return filingApprovalOrg;
    }

    /**
     * 备案或核准单位名称
     */
    public void setFilingApprovalOrg(java.lang.String filingApprovalOrg) {
        this.filingApprovalOrg = filingApprovalOrg;
    }
    /**
     * 备案号或核准文件号
     */
    public java.lang.String getFilingApprovalCode() {
        return filingApprovalCode;
    }

    /**
     * 备案号或核准文件号
     */
    public void setFilingApprovalCode(java.lang.String filingApprovalCode) {
        this.filingApprovalCode = filingApprovalCode;
    }
    /**
     * 标的企业-其他需说明的情况
     */
    public java.lang.String getCapitalOtherMemo() {
        return capitalOtherMemo;
    }

    /**
     * 标的企业-其他需说明的情况
     */
    public void setCapitalOtherMemo(java.lang.String capitalOtherMemo) {
        this.capitalOtherMemo = capitalOtherMemo;
    }
    /**
     * 减资情形
     */
    public java.lang.String getReductionCapital() {
        return reductionCapital;
    }

    /**
     * 减资情形
     */
    public void setReductionCapital(java.lang.String reductionCapital) {
        this.reductionCapital = reductionCapital;
    }
    /**
     * 减少资本总额
     */
    public java.math.BigDecimal getReductionCapitalTotal() {
        return reductionCapitalTotal;
    }

    /**
     * 减少资本总额
     */
    public void setReductionCapitalTotal(java.math.BigDecimal reductionCapitalTotal) {
        this.reductionCapitalTotal = reductionCapitalTotal;
    }
    /**
     * 减少资本总额(大写)
     */
    public java.lang.String getReductionCapitalTotalBig() {
        return reductionCapitalTotalBig;
    }

    /**
     * 减少资本总额(大写)
     */
    public void setReductionCapitalTotalBig(java.lang.String reductionCapitalTotalBig) {
        this.reductionCapitalTotalBig = reductionCapitalTotalBig;
    }
    /**
     * 作价依据
     */
    public java.lang.String getReductionCapitalPricingBasis() {
        return reductionCapitalPricingBasis;
    }

    /**
     * 作价依据
     */
    public void setReductionCapitalPricingBasis(java.lang.String reductionCapitalPricingBasis) {
        this.reductionCapitalPricingBasis = reductionCapitalPricingBasis;
    }
    /**
     * 减资-中央企业出资人是否全部退出
     */
    public Boolean getCentralEnterprisesAllOut() {
        return centralEnterprisesAllOut;
    }

    public void setCentralEnterprisesAllOut(Boolean centralEnterprisesAllOut) {
        this.centralEnterprisesAllOut = centralEnterprisesAllOut;
    }

    /**
     * 减资企业净资产评估值
     */
    public java.math.BigDecimal getReductionCapitalValueAssets() {
        return reductionCapitalValueAssets;
    }

    /**
     * 减资企业净资产评估值
     */
    public void setReductionCapitalValueAssets(java.math.BigDecimal reductionCapitalValueAssets) {
        this.reductionCapitalValueAssets = reductionCapitalValueAssets;
    }
    /**
     * 减资企业净资产评估值(大写)
     */
    public java.lang.String getReductionCapitalValueAssetsBig() {
        return reductionCapitalValueAssetsBig;
    }

    /**
     * 减资企业净资产评估值(大写)
     */
    public void setReductionCapitalValueAssetsBig(java.lang.String reductionCapitalValueAssetsBig) {
        this.reductionCapitalValueAssetsBig = reductionCapitalValueAssetsBig;
    }
    /**
     * 有无职工代表大会决议
     */
    public Boolean getHasEmployeeCongress() {
        return hasEmployeeCongress;
    }

    public void setHasEmployeeCongress(Boolean hasEmployeeCongress) {
        this.hasEmployeeCongress = hasEmployeeCongress;
    }

    /**
     * 职工代表大会意见
     */
    public java.lang.String getEmployeeCongressOpinions() {
        return employeeCongressOpinions;
    }

    /**
     * 职工代表大会意见
     */
    public void setEmployeeCongressOpinions(java.lang.String employeeCongressOpinions) {
        this.employeeCongressOpinions = employeeCongressOpinions;
    }
    /**
     * 职工代表大会-其他需说明的情况
     */
    public java.lang.String getEmployeeCongressOtherMemo() {
        return employeeCongressOtherMemo;
    }

    /**
     * 职工代表大会-其他需说明的情况
     */
    public void setEmployeeCongressOtherMemo(java.lang.String employeeCongressOtherMemo) {
        this.employeeCongressOtherMemo = employeeCongressOtherMemo;
    }
    /**
     * 划转类型
     */
    public java.lang.String getTransferType() {
        return transferType;
    }

    /**
     * 划转类型
     */
    public void setTransferType(java.lang.String transferType) {
        this.transferType = transferType;
    }
    /**
     * 产权登记情形
     */
    public java.lang.String getRegistrationPropertyRights() {
        return registrationPropertyRights;
    }

    /**
     * 产权登记情形
     */
    public void setRegistrationPropertyRights(java.lang.String registrationPropertyRights) {
        this.registrationPropertyRights = registrationPropertyRights;
    }
    /**
     * 是否引入新股东-改制
     */
    public Boolean getIntroductionNewShareholders() {
        return introductionNewShareholders;
    }

    public void setIntroductionNewShareholders(Boolean introductionNewShareholders) {
        this.introductionNewShareholders = introductionNewShareholders;
    }

    /**
     * 改制企业净资产审计值
     */
    public java.math.BigDecimal getReformOrgNetAssetsAudit() {
        return reformOrgNetAssetsAudit;
    }

    /**
     * 改制企业净资产审计值
     */
    public void setReformOrgNetAssetsAudit(java.math.BigDecimal reformOrgNetAssetsAudit) {
        this.reformOrgNetAssetsAudit = reformOrgNetAssetsAudit;
    }
    /**
     * 改制企业净资产审计值(大写)
     */
    public java.lang.String getReformOrgNetAssetsAuditBig() {
        return reformOrgNetAssetsAuditBig;
    }

    /**
     * 改制企业净资产审计值(大写)
     */
    public void setReformOrgNetAssetsAuditBig(java.lang.String reformOrgNetAssetsAuditBig) {
        this.reformOrgNetAssetsAuditBig = reformOrgNetAssetsAuditBig;
    }

    /**
     * 有无非货币出资
     */
    public Boolean getHasNonMonetaryContribution() {
        return hasNonMonetaryContribution;
    }

    public void setHasNonMonetaryContribution(Boolean hasNonMonetaryContribution) {
        this.hasNonMonetaryContribution = hasNonMonetaryContribution;
    }

    /**
     * 有无财产分配情况
     */
    public java.lang.Integer getHasPropertyDistribution() {
        return hasPropertyDistribution;
    }

    /**
     * 有无财产分配情况
     */
    public void setHasPropertyDistribution(java.lang.Integer hasPropertyDistribution) {
        this.hasPropertyDistribution = hasPropertyDistribution;
    }

    public String getProductionTypeName() {
        return productionTypeName;
    }

    public void setProductionTypeName(String productionTypeName) {
        this.productionTypeName = productionTypeName;
    }

    public String getProductionTypeCode() {
        return productionTypeCode;
    }

    public void setProductionTypeCode(String productionTypeCode) {
        this.productionTypeCode = productionTypeCode;
    }

    /**
     * 产权登记单来源于哪个申请单
     */
    public java.lang.Long getSourceApplyId() {
        return sourceApplyId;
    }

    /**
     * 产权登记单来源于哪个申请单
     */
    public void setSourceApplyId(java.lang.Long sourceApplyId) {
        this.sourceApplyId = sourceApplyId;
    }
    /**
     * 创建单据组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 创建单据组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 创建人
     */
    public java.lang.String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人
     */
    public void setCreateUserName(java.lang.String createUserName) {
        this.createUserName = createUserName;
    }
    
    /**
     * 产权登记-收购股权明细
     */
    public List<AcquisitionEquityEntity> getAcquisitionEquityEntities() {
        return acquisitionEquityEntities;
    }

    /**
     * 产权登记-收购股权明细
     */
    public void setAcquisitionEquityEntities(List<AcquisitionEquityEntity> acquisitionEquityEntities) {
        this.acquisitionEquityEntities = acquisitionEquityEntities;
    }
    /**
     * 产权登记--资本状况
     */
    public List<CapitalEntity> getCapitalEntities() {
        return capitalEntities;
    }

    /**
     * 产权登记--资本状况
     */
    public void setCapitalEntities(List<CapitalEntity> capitalEntities) {
        this.capitalEntities = capitalEntities;
    }
    /**
     * 产权登记-减资方情况
     */
    public List<CapitalReductionEntity> getCapitalReductionEntities() {
        return capitalReductionEntities;
    }

    /**
     * 产权登记-减资方情况
     */
    public void setCapitalReductionEntities(List<CapitalReductionEntity> capitalReductionEntities) {
        this.capitalReductionEntities = capitalReductionEntities;
    }
    /**
     * 产权登记-合规性目录
     */
    public List<ConformanceContentEntity> getConformanceContentEntities() {
        return conformanceContentEntities;
    }

    /**
     * 产权登记-合规性目录
     */
    public void setConformanceContentEntities(List<ConformanceContentEntity> conformanceContentEntities) {
        this.conformanceContentEntities = conformanceContentEntities;
    }
    /**
     * 产权登记-货币出资情况
     */
    public List<CurrencyEntity> getCurrencyEntities() {
        return currencyEntities;
    }

    /**
     * 产权登记-货币出资情况
     */
    public void setCurrencyEntities(List<CurrencyEntity> currencyEntities) {
        this.currencyEntities = currencyEntities;
    }
    /**
     * 产权登记-非货币出资
     */
    public List<NoneCurrencyEntity> getNoneCurrencyEntities() {
        return noneCurrencyEntities;
    }

    /**
     * 产权登记-非货币出资
     */
    public void setNoneCurrencyEntities(List<NoneCurrencyEntity> noneCurrencyEntities) {
        this.noneCurrencyEntities = noneCurrencyEntities;
    }
    /**
     * 产权登记-改制新股东
     */
    public List<ReformNewShareholderEntity> getReformNewShareholderEntities() {
        return reformNewShareholderEntities;
    }

    /**
     * 产权登记-改制新股东
     */
    public void setReformNewShareholderEntities(List<ReformNewShareholderEntity> reformNewShareholderEntities) {
        this.reformNewShareholderEntities = reformNewShareholderEntities;
    }
    /**
     * 产权登记-剩余财产分配情况
     */
    public List<ResidualPropertyEntity> getResidualPropertyEntities() {
        return residualPropertyEntities;
    }

    /**
     * 产权登记-剩余财产分配情况
     */
    public void setResidualPropertyEntities(List<ResidualPropertyEntity> residualPropertyEntities) {
        this.residualPropertyEntities = residualPropertyEntities;
    }
    /**
     * 产权登记-划转方案信息
     */
    public List<TransferInfoEntity> getTransferInfoEntities() {
        return transferInfoEntities;
    }

    /**
     * 产权登记-划转方案信息
     */
    public void setTransferInfoEntities(List<TransferInfoEntity> transferInfoEntities) {
        this.transferInfoEntities = transferInfoEntities;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getOrgForm() {
        return orgForm;
    }

    public void setOrgForm(String orgForm) {
        this.orgForm = orgForm;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getDecisionProgramName() {
        return decisionProgramName;
    }

    public void setDecisionProgramName(String decisionProgramName) {
        this.decisionProgramName = decisionProgramName;
    }

    public String getTransferTypeName() {
        return transferTypeName;
    }

    public void setTransferTypeName(String transferTypeName) {
        this.transferTypeName = transferTypeName;
    }

    public List<InvestorsEntity> getInvestorsEntities() {
        return investorsEntities;
    }

    public void setInvestorsEntities(List<InvestorsEntity> investorsEntities) {
        this.investorsEntities = investorsEntities;
    }

    public Long getReductionCapitalId() {
        return reductionCapitalId;
    }

    public void setReductionCapitalId(Long reductionCapitalId) {
        this.reductionCapitalId = reductionCapitalId;
    }

    public Long getRegistrationPropertyRightsId() {
        return registrationPropertyRightsId;
    }

    public void setRegistrationPropertyRightsId(Long registrationPropertyRightsId) {
        this.registrationPropertyRightsId = registrationPropertyRightsId;
    }

    public String getRouteUrl() {
        return routeUrl;
    }

    public void setRouteUrl(String routeUrl) {
        this.routeUrl = routeUrl;
    }

    public Boolean getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(Boolean useStatus) {
        this.useStatus = useStatus;
    }

    public String getInvestorsBefore() {
        return investorsBefore;
    }

    public void setInvestorsBefore(String investorsBefore) {
        this.investorsBefore = investorsBefore;
    }

    public String getInvestorsAfter() {
        return investorsAfter;
    }

    public void setInvestorsAfter(String investorsAfter) {
        this.investorsAfter = investorsAfter;
    }

    public String getHistoryRecord() {
        return historyRecord;
    }

    public void setHistoryRecord(String historyRecord) {
        this.historyRecord = historyRecord;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public String getInvestedEnterpriseValuationFilingCode() {
        return investedEnterpriseValuationFilingCode;
    }

    public void setInvestedEnterpriseValuationFilingCode(String investedEnterpriseValuationFilingCode) {
        this.investedEnterpriseValuationFilingCode = investedEnterpriseValuationFilingCode;
    }

    public BigDecimal getInvestedEnterpriseAssetsAppraisalValue() {
        return investedEnterpriseAssetsAppraisalValue;
    }

    public void setInvestedEnterpriseAssetsAppraisalValue(BigDecimal investedEnterpriseAssetsAppraisalValue) {
        this.investedEnterpriseAssetsAppraisalValue = investedEnterpriseAssetsAppraisalValue;
    }

    public String getInvestedEnterpriseAssetsAppraisalValueBig() {
        return investedEnterpriseAssetsAppraisalValueBig;
    }

    public void setInvestedEnterpriseAssetsAppraisalValueBig(String investedEnterpriseAssetsAppraisalValueBig) {
        this.investedEnterpriseAssetsAppraisalValueBig = investedEnterpriseAssetsAppraisalValueBig;
    }

    public BigDecimal getFundedEnterpriseEquityRatio() {
        return fundedEnterpriseEquityRatio;
    }

    public void setFundedEnterpriseEquityRatio(BigDecimal fundedEnterpriseEquityRatio) {
        this.fundedEnterpriseEquityRatio = fundedEnterpriseEquityRatio;
    }

    public Boolean getInvolvingInvestedEnterprisesContribution() {
        return involvingInvestedEnterprisesContribution;
    }

    public void setInvolvingInvestedEnterprisesContribution(Boolean involvingInvestedEnterprisesContribution) {
        this.involvingInvestedEnterprisesContribution = involvingInvestedEnterprisesContribution;
    }

    public Boolean getInvolvingInvestedEnterprisesShareContribution() {
        return involvingInvestedEnterprisesShareContribution;
    }

    public void setInvolvingInvestedEnterprisesShareContribution(Boolean involvingInvestedEnterprisesShareContribution) {
        this.involvingInvestedEnterprisesShareContribution = involvingInvestedEnterprisesShareContribution;
    }

    public Boolean getApprovalThereAssessmentRecordDocument() {
        return approvalThereAssessmentRecordDocument;
    }

    public void setApprovalThereAssessmentRecordDocument(Boolean approvalThereAssessmentRecordDocument) {
        this.approvalThereAssessmentRecordDocument = approvalThereAssessmentRecordDocument;
    }

    public String getApprovalIntermediaryStructureName() {
        return approvalIntermediaryStructureName;
    }

    public void setApprovalIntermediaryStructureName(String approvalIntermediaryStructureName) {
        this.approvalIntermediaryStructureName = approvalIntermediaryStructureName;
    }

    public String getApprovalRecordOrApprovedName() {
        return approvalRecordOrApprovedName;
    }

    public void setApprovalRecordOrApprovedName(String approvalRecordOrApprovedName) {
        this.approvalRecordOrApprovedName = approvalRecordOrApprovedName;
    }

    public String getApprovalRecordOrApprovedFile() {
        return approvalRecordOrApprovedFile;
    }

    public void setApprovalRecordOrApprovedFile(String approvalRecordOrApprovedFile) {
        this.approvalRecordOrApprovedFile = approvalRecordOrApprovedFile;
    }

    public String getApprovalOtherRequiringExplanation() {
        return approvalOtherRequiringExplanation;
    }

    public void setApprovalOtherRequiringExplanation(String approvalOtherRequiringExplanation) {
        this.approvalOtherRequiringExplanation = approvalOtherRequiringExplanation;
    }

    public Boolean getNoneCurrencyThereAssessmentRecordDocument() {
        return noneCurrencyThereAssessmentRecordDocument;
    }

    public void setNoneCurrencyThereAssessmentRecordDocument(Boolean noneCurrencyThereAssessmentRecordDocument) {
        this.noneCurrencyThereAssessmentRecordDocument = noneCurrencyThereAssessmentRecordDocument;
    }

    public String getNoneCurrencyIntermediaryStructureName() {
        return noneCurrencyIntermediaryStructureName;
    }

    public void setNoneCurrencyIntermediaryStructureName(String noneCurrencyIntermediaryStructureName) {
        this.noneCurrencyIntermediaryStructureName = noneCurrencyIntermediaryStructureName;
    }

    public String getNoneCurrencyRecordOrApprovedName() {
        return noneCurrencyRecordOrApprovedName;
    }

    public void setNoneCurrencyRecordOrApprovedName(String noneCurrencyRecordOrApprovedName) {
        this.noneCurrencyRecordOrApprovedName = noneCurrencyRecordOrApprovedName;
    }

    public String getNoneCurrencyRecordOrApprovedFile() {
        return noneCurrencyRecordOrApprovedFile;
    }

    public void setNoneCurrencyRecordOrApprovedFile(String noneCurrencyRecordOrApprovedFile) {
        this.noneCurrencyRecordOrApprovedFile = noneCurrencyRecordOrApprovedFile;
    }

    public String getNoneCurrencyEvaluationReportNo() {
        return noneCurrencyEvaluationReportNo;
    }

    public void setNoneCurrencyEvaluationReportNo(String noneCurrencyEvaluationReportNo) {
        this.noneCurrencyEvaluationReportNo = noneCurrencyEvaluationReportNo;
    }

    public String getNoneCurrencyOtherRequiringExplanation() {
        return noneCurrencyOtherRequiringExplanation;
    }

    public void setNoneCurrencyOtherRequiringExplanation(String noneCurrencyOtherRequiringExplanation) {
        this.noneCurrencyOtherRequiringExplanation = noneCurrencyOtherRequiringExplanation;
    }

    public String getInitiatorUnifiedSocialCreditCode() {
        return initiatorUnifiedSocialCreditCode;
    }

    public void setInitiatorUnifiedSocialCreditCode(String initiatorUnifiedSocialCreditCode) {
        this.initiatorUnifiedSocialCreditCode = initiatorUnifiedSocialCreditCode;
    }

    public BigDecimal getInvestmentAmount() {
        return investmentAmount;
    }

    public void setInvestmentAmount(BigDecimal investmentAmount) {
        this.investmentAmount = investmentAmount;
    }

    public String getInvestmentAmountBig() {
        return investmentAmountBig;
    }

    public void setInvestmentAmountBig(String investmentAmountBig) {
        this.investmentAmountBig = investmentAmountBig;
    }

    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }

    public String getTransactionOrgName() {
        return transactionOrgName;
    }

    public void setTransactionOrgName(String transactionOrgName) {
        this.transactionOrgName = transactionOrgName;
    }

    public String getTransactionProjectCode() {
        return transactionProjectCode;
    }

    public void setTransactionProjectCode(String transactionProjectCode) {
        this.transactionProjectCode = transactionProjectCode;
    }

    public Date getTransactionEndDate() {
        return transactionEndDate;
    }

    public void setTransactionEndDate(Date transactionEndDate) {
        this.transactionEndDate = transactionEndDate;
    }

    public BigDecimal getListingPrice() {
        return listingPrice;
    }

    public void setListingPrice(BigDecimal listingPrice) {
        this.listingPrice = listingPrice;
    }
/*
    public List<TransfererEntity> getTransfererEntities() {
        return transfererEntities;
    }*/

    /*public void setTransfererEntities(List<TransfererEntity> transfererEntities) {
        this.transfererEntities = transfererEntities;
    }

    public List<TransferorEntity> getTransferorEntities() {
        return transferorEntities;
    }

    public void setTransferorEntities(List<TransferorEntity> transferorEntities) {
        this.transferorEntities = transferorEntities;
    }*/

    public String getAssessedValueNetAssetsBig() {
        return assessedValueNetAssetsBig;
    }

    public void setAssessedValueNetAssetsBig(String assessedValueNetAssetsBig) {
        this.assessedValueNetAssetsBig = assessedValueNetAssetsBig;
    }

    public BigDecimal getTransactionPrice() {
        return transactionPrice;
    }

    public void setTransactionPrice(BigDecimal transactionPrice) {
        this.transactionPrice = transactionPrice;
    }

    public String getTransactionPriceBig() {
        return transactionPriceBig;
    }

    public void setTransactionPriceBig(String transactionPriceBig) {
        this.transactionPriceBig = transactionPriceBig;
    }

    public Long getInUseOrgId() {
        return inUseOrgId;
    }

    public void setInUseOrgId(Long inUseOrgId) {
        this.inUseOrgId = inUseOrgId;
    }
}
