package com.ejianc.business.production.service;

import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.production.vo.OrgApplyVOS;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.production.bean.ProductionEntity;

import java.util.List;
import java.util.Map;

/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
public interface IProductionService extends IBaseService<ProductionEntity> {

    /**
     * 指派
     * @param param
     * @return
     */
    public CommonResponse<String> assignTask(Map<String,String> param);

    /**
     * 根据申请id 和出资类型查询数据
     * @param applyId
     * @param contributionType
     * @return
     */
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType);

    /**
     * 查询产权登记类型子数据
     * @return
     */
    public List<ProductionTypeItemEntity>  queryProductionTypeItemList(String productionTypeCode);

    /**
     * 根据id查询所以出资情况
     * @param applyId
     * @return
     */
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId);

    /**
     * 根据出资人类别进行汇总
     * @param applyId
     * @return
     */
    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId);

    /**
     * 验证（收购企业） 收购手动输入的编号是否重复
     * @param unifiedSocialCreditCode
     * @return
     */
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode);


    //public ProductionEntity queryHistory(Long applyId);

    /**
     * 根据applyId查询数据
     * @param applyId
     * @return
     */
    public List<ProductionEntity> queryProductionByApplyId(Long applyId);

    /**
     * 不登记
     * @param applyEntity
     * @return
     */
    public CommonResponse<String>  updateNoRegister(OrgApplyEntity applyEntity);

    public OrgApplyVOS queryDel(Long inUseOrgId);
}
