package com.ejianc.business.sddjsorg.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.ejianc.business.sddjsorg.bean.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sddjsorg.mapper.OrgApplyMapper;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.capital.bean.CapitalRealPaymentApplyEntity;
import com.ejianc.business.capital.bean.CapitalRecRegistryEntity;
import com.ejianc.business.capital.service.ICapitalRealPaymentApplyService;
import com.ejianc.business.capital.service.ICapitalRecRegistryService;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.business.sddjsorg.service.IShareholderDecisionService;
import com.ejianc.business.sddjsorg.vo.OrgApplyFileVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;

/**
 * 组织机构申请单
 * 
 * @author generator
 * 
 */
@Service("orgApplyService")
public class OrgApplyServiceImpl extends BaseServiceImpl<OrgApplyMapper, OrgApplyEntity> implements IOrgApplyService{
	
	@Autowired
	private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ISddjsOrgService sddjsOrgService;
    @Autowired
    private IAttachmentApi attachmentApi;
	@Autowired
	private ICapitalRecRegistryService capitalRecRegistryService;
	@Autowired
	private ICapitalRealPaymentApplyService capitalRealPaymentApplyService;
	@Autowired
	private IShareholderDecisionService shareholderDecisionService;

	@Override
	public CommonResponse<String> file(Long id) {
    	OrgApplyEntity entity = this.selectById(id);
    	
        //如果该公司是法人公司，则校验表体【工商信息】的“成立日期”、“统一社会信息代码”、“营业执照”是否有值，如果没有，则不允许归档
    	if((entity.getLegalFlag()!=null)&&(entity.getLegalFlag()==1)&&("set".equals(entity.getApplyType())||"change".equals(entity.getApplyType())||"merge".equals(entity.getApplyType()))){
    		if(entity.getDateIncorporation()==null){
    			return CommonResponse.error("归档失败！请先维护工商信息[成立日期]");
    		}
    		if(StringUtils.isBlank(entity.getUnifiedSocialCreditCode())){
    			return CommonResponse.error("归档失败！请先维护工商信息[统一社会信息代码]");
    		}
    		//营业执照
    		CommonResponse<List<AttachmentVO>> attact = attachmentApi.queryListBySourceId(id, "BT211012000000004", "businessLicense", null);
    		if(attact.isSuccess()){
    			if(!(attact.getData()!=null||attact.getData().size()>0)){
    				return CommonResponse.error("归档失败！请先维护工商信息[营业执照]");
    			}
    		}else{
    			return CommonResponse.error("查询营业执照异常，请稍后再试");
    		}
    	}
    	List<OrgApplyFileEntity> orgApplyFileList = entity.getOrgApplyFileList();
    	if(orgApplyFileList!=null&&orgApplyFileList.size()>0){
    		for(OrgApplyFileEntity fileEntity : orgApplyFileList){
                if("file".equals(fileEntity.getCheckTime())&&fileEntity.getRequired()){
                    if(StringUtils.isBlank(fileEntity.getFileId())){
                    	return CommonResponse.error("档案信息：【"+fileEntity.getName()+"】不能为空，请先上传档案信息");
                    }
                }
            }
    	}
    	if("set".equals(entity.getApplyType()) || ("merge".equals(entity.getApplyType()) && "newSet".equals(entity.getMergeType()))){
    		//设立申请--生成组织机构
    		//生成组织机构
    		SddjsOrgEntity sddjsOrgEntity = BeanMapper.map(entity, SddjsOrgEntity.class);
    		sddjsOrgEntity.setId(null);
    		sddjsOrgEntity.setCreateTime(null);
    		sddjsOrgEntity.setCreateUserCode(null);
    		sddjsOrgEntity.setTenantId(InvocationInfoProxy.getTenantid());
    		sddjsOrgEntity.setUpdateTime(null);
    		sddjsOrgEntity.setUpdateUserCode(null);
    		if(sddjsOrgEntity.getOrgShareholderList()!=null&&sddjsOrgEntity.getOrgShareholderList().size()>0){
    			sddjsOrgEntity.getOrgShareholderList().forEach(older -> {
    				older.setId(null);
    				older.setCreateTime(null);
    				older.setCreateUserCode(null);
    				older.setTenantId(InvocationInfoProxy.getTenantid());
    				older.setUpdateTime(null);
    				older.setUpdateUserCode(null);
    				older.setPid(null);
    				older.setRowState("add");
    			});
    		}
    		sddjsOrgEntity.setUseState("use");
    		sddjsOrgService.saveOrUpdate(sddjsOrgEntity, false);
        	//营业执照
        	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "businessLicense", sddjsOrgEntity.getId().toString(), "BT211012000000004", "businessLicense");
        	//公司章程
        	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "articles", sddjsOrgEntity.getId().toString(), "BT211012000000004", "articles");
    		
        	entity.setInUseOrgId(sddjsOrgEntity.getId());
    	}else if("change".equals(entity.getApplyType()) || ("merge".equals(entity.getApplyType()) && "receive".equals(entity.getMergeType()))){
    		//变更申请--修改组织机构信息
    		SddjsOrgEntity oldsddjsOrgEntity = sddjsOrgService.selectById(entity.getInUseOrgId());
    		SddjsOrgEntity newsddjsOrgEntity = BeanMapper.map(entity, SddjsOrgEntity.class);
    		newsddjsOrgEntity.setId(oldsddjsOrgEntity.getId());
    		newsddjsOrgEntity.setCreateTime(oldsddjsOrgEntity.getCreateTime());
    		newsddjsOrgEntity.setCreateUserCode(oldsddjsOrgEntity.getCreateUserCode());
    		newsddjsOrgEntity.setTenantId(oldsddjsOrgEntity.getTenantId());
    		newsddjsOrgEntity.setUpdateTime(oldsddjsOrgEntity.getUpdateTime());
    		newsddjsOrgEntity.setUpdateUserCode(oldsddjsOrgEntity.getUpdateUserCode());
    		newsddjsOrgEntity.setVersion(oldsddjsOrgEntity.getVersion());
    		newsddjsOrgEntity.setOrgId(oldsddjsOrgEntity.getOrgId());
    		newsddjsOrgEntity.setUseState(oldsddjsOrgEntity.getUseState());
    		if(newsddjsOrgEntity.getOrgShareholderList()!=null&&newsddjsOrgEntity.getOrgShareholderList().size()>0){
    			newsddjsOrgEntity.getOrgShareholderList().forEach(older -> {
    				older.setId(null);
    				older.setCreateTime(null);
    				older.setCreateUserCode(null);
    				older.setTenantId(InvocationInfoProxy.getTenantid());
    				older.setUpdateTime(null);
    				older.setUpdateUserCode(null);
    				older.setPid(null);
    				older.setRowState("add");
    			});
    		}
    		if(oldsddjsOrgEntity.getOrgShareholderList()!=null&&oldsddjsOrgEntity.getOrgShareholderList().size()>0){
    			oldsddjsOrgEntity.getOrgShareholderList().forEach(older -> {
    				older.setRowState("del");
    				newsddjsOrgEntity.getOrgShareholderList().add(older);
    			});
    		}
        	//营业执照
    		CommonResponse<List<AttachmentVO>> businessLicenselist = attachmentApi.queryListBySourceId(oldsddjsOrgEntity.getId(), "BT211012000000004", "businessLicense", null);
    		if(businessLicenselist.isSuccess()&&businessLicenselist.getData()!=null&&businessLicenselist.getData().size()>0){
    			String ids = "";
    			for(AttachmentVO att : businessLicenselist.getData()){
    				if(ids.length()>0){
    					ids += (","+att.getId());
        			}else{
        				ids += att.getId();
        			}
    			}
    			attachmentApi.delete(ids);
    		}
    		//公司章程
    		CommonResponse<List<AttachmentVO>> articleslist = attachmentApi.queryListBySourceId(oldsddjsOrgEntity.getId(), "BT211012000000004", "articles", null);
    		if(articleslist.isSuccess()&&articleslist.getData()!=null&&articleslist.getData().size()>0){
    			String ids = "";
    			for(AttachmentVO att : articleslist.getData()){
    				if(ids.length()>0){
    					ids += (","+att.getId());
        			}else{
        				ids += att.getId();
        			}
    			}
    			attachmentApi.delete(ids);
    		}
    		sddjsOrgService.saveOrUpdate(newsddjsOrgEntity, false);
        	//营业执照
        	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "businessLicense", newsddjsOrgEntity.getId().toString(), "BT211012000000004", "businessLicense");
        	//公司章程
        	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "articles", newsddjsOrgEntity.getId().toString(), "BT211012000000004", "articles");
    	}else if("del".equals(entity.getApplyType())){
    		//注销申请--修改组织机构信息
    		SddjsOrgEntity oldsddjsOrgEntity = sddjsOrgService.selectById(entity.getInUseOrgId());
    		oldsddjsOrgEntity.setUseState("nouse");
    		sddjsOrgService.saveOrUpdate(oldsddjsOrgEntity, false);
    	}

		/**
		 *  合并 注销所有子表
		 */
		if("merge".equals(entity.getApplyType())){
			List<OrgCancelEntity> orgCancelList = entity.getOrgCancelList();
			if(ListUtil.isNotEmpty(orgCancelList)){
				for (OrgCancelEntity cancelEntity : orgCancelList) {
					//注销 --修改组织机构信息
					SddjsOrgEntity oldsddjsOrgEntity = sddjsOrgService.selectById(cancelEntity.getInstitutionId());
					oldsddjsOrgEntity.setUseState("nouse");
					sddjsOrgService.saveOrUpdate(oldsddjsOrgEntity, false);
				}
			}
		}
		entity.setFileState("filed");
    	entity.setFileTime(new Date());
    	entity.setFileUser(sessionManager.getUserContext().getUserName());
    	this.saveOrUpdate(entity, false);
        return CommonResponse.success("归档成功！");
	}

	@Override
	public CommonResponse<String> unfile(Long id) {
		OrgApplyEntity entity = this.selectById(id);
		if(!"unregistered".equals(entity.getProductionState())){
			//非未登记状态不能弃审
			return CommonResponse.error("该申请已做产权登记，不能取消归档！");
		}
		if("merge".equals(entity.getApplyType())){
			//非未登记状态不能弃审
			return CommonResponse.error("合并申请不支持取消归档！");
		}
    	if("set".equals(entity.getApplyType())){
    		//判断该组织是否已做注销或变更，若是则不能取消归档
        	QueryWrapper<OrgApplyEntity> applyingWrapper = new QueryWrapper<>();
        	List<String> applyType = new ArrayList<>();
        	applyType.add("change");
        	applyType.add("del");
    		applyingWrapper.in("apply_type", applyType );
    		applyingWrapper.eq("dr", 0);
    		applyingWrapper.eq("in_use_org_id", entity.getInUseOrgId());
        	Integer applyingNumber = this.count(applyingWrapper);
        	if(applyingNumber>0){
        		return CommonResponse.error("该申请组织已存在变更或注销单，不能取消归档！");
        	}

			//判断是否资本金收款登记
			QueryWrapper<CapitalRecRegistryEntity> capitalRecRegistryQueryWrapper = new QueryWrapper<>();
			capitalRecRegistryQueryWrapper.eq("sddjs_org_id", entity.getInUseOrgId());
			List<CapitalRecRegistryEntity> registrylist = capitalRecRegistryService.list(capitalRecRegistryQueryWrapper);
			if(registrylist!=null&&registrylist.size()>0){
				return CommonResponse.error("该申请已做资本金收款登记，不能弃审！");
			}
			//判断是否资本金实缴
			QueryWrapper<CapitalRealPaymentApplyEntity> capitalRealPaymentApplyQueryWrapper = new QueryWrapper<>();
			capitalRealPaymentApplyQueryWrapper.eq("sddjs_org_id", entity.getInUseOrgId());
			List<CapitalRealPaymentApplyEntity> paymentApplyList = capitalRealPaymentApplyService.list(capitalRealPaymentApplyQueryWrapper);
			if(paymentApplyList!=null&&registrylist.size()>0){
				return CommonResponse.error("该申请已做资本金实缴，不能弃审！");
			}
			//股东决策
			QueryWrapper<ShareholderDecisionEntity> shareholderDecisionQueryWrapper = new QueryWrapper<>();
			shareholderDecisionQueryWrapper.eq("sddjs_org_id", entity.getInUseOrgId());
			List<ShareholderDecisionEntity> shareholderDecisionList = shareholderDecisionService.list(shareholderDecisionQueryWrapper);
			if(shareholderDecisionList!=null&&shareholderDecisionList.size()>0){
				return CommonResponse.error("该申请已做股东决策，不能弃审！");
			}
        	
    		//删除组织机构信息
    		sddjsOrgService.removeById(entity.getInUseOrgId(), false);
    		entity.setInUseOrgId(null);
    	}else if("change".equals(entity.getApplyType())){
    		//变更申请--恢复组织机构信息
    		SddjsOrgEntity nowsddjsOrgEntity = sddjsOrgService.selectById(entity.getInUseOrgId());
    		if(StringUtils.isBlank(entity.getChangeOldContent())){
    			throw new BusinessException("未获取到变更前的内容，不允许取消归档");
    		}
    		JSONObject oldChangeContent = JSONObject.parseObject(entity.getChangeOldContent());
    		SddjsOrgEntity oldsddjsOrgEntity = BeanMapper.map(oldChangeContent, SddjsOrgEntity.class);
    		SddjsOrgEntity newsddjsOrgEntity = BeanMapper.map(oldsddjsOrgEntity, SddjsOrgEntity.class);
    		//初始化时修改的数据，现在还原回去
    		newsddjsOrgEntity.setVersion(nowsddjsOrgEntity.getVersion());
    		newsddjsOrgEntity.setId(nowsddjsOrgEntity.getId());
    		newsddjsOrgEntity.setCreateTime(nowsddjsOrgEntity.getCreateTime());
    		newsddjsOrgEntity.setCreateUserCode(nowsddjsOrgEntity.getCreateUserCode());
    		newsddjsOrgEntity.setTenantId(nowsddjsOrgEntity.getTenantId());
        	newsddjsOrgEntity.setUpdateTime(nowsddjsOrgEntity.getUpdateTime());
        	newsddjsOrgEntity.setUpdateUserCode(nowsddjsOrgEntity.getUpdateUserCode());
        	newsddjsOrgEntity.setUseState(nowsddjsOrgEntity.getUseState());
        	newsddjsOrgEntity.setOrgId(nowsddjsOrgEntity.getOrgId());
        	
    		if(newsddjsOrgEntity.getOrgShareholderList()!=null&&newsddjsOrgEntity.getOrgShareholderList().size()>0){
    			newsddjsOrgEntity.getOrgShareholderList().forEach(older -> {
    				older.setId(null);
    				older.setCreateTime(null);
    				older.setCreateUserCode(null);
    				older.setTenantId(InvocationInfoProxy.getTenantid());
    				older.setUpdateTime(null);
    				older.setUpdateUserCode(null);
    				older.setPid(null);
    				older.setRowState("add");
    			});
    		}
    		if(oldsddjsOrgEntity.getOrgShareholderList()!=null&&oldsddjsOrgEntity.getOrgShareholderList().size()>0){
    			oldsddjsOrgEntity.getOrgShareholderList().forEach(older -> {
    				older.setRowState("del");
    				newsddjsOrgEntity.getOrgShareholderList().add(older);
    			});
    		}
    		sddjsOrgService.saveOrUpdate(newsddjsOrgEntity, false);
    	}else if("del".equals(entity.getApplyType())){
    		//注销申请--修改组织机构信息
    		SddjsOrgEntity oldsddjsOrgEntity = sddjsOrgService.selectById(entity.getInUseOrgId());
    		oldsddjsOrgEntity.setUseState("use");
    		sddjsOrgService.saveOrUpdate(oldsddjsOrgEntity, false);
    	}
		
    	entity.setFileState("toFile");
    	entity.setFileTime(null);
    	entity.setFileUser(null);
    	this.saveOrUpdate(entity, false);
        return CommonResponse.success("取消归档成功！");
	}
    
}
