package com.ejianc.business.projectapply.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ExecutiveAgentEntity;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.bean.ProjectChangeEntity;
import com.ejianc.business.projectapply.service.IExecutiveAgentService;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.service.IProjectChangeService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.business.projectapply.vo.ProjectChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 项目变更实体
 *
 * @author CJ
 * @Description: 项目变更实体
 * @date 2021/9/8 17:14
 */
@RestController
@RequestMapping("/projectChange/")
public class ProjectChangeController {

    @Autowired
    private IProjectApplyService projectApplyService;

    @Autowired
    private IProjectChangeService projectChangeService;
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetails")
    public CommonResponse<ProjectApplyVO> queryDetails(@RequestParam(value = "id") Long id) {
        ProjectApplyVO resp = null;

        ProjectApplyEntity dbEntity = projectApplyService.selectById(id);
        if(null != dbEntity) {
            resp = BeanMapper.map(dbEntity, ProjectApplyVO.class);
        	QueryWrapper<ProjectChangeEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("project_id", id);
        	queryWrapper.orderByDesc("create_time");
    		List<ProjectChangeEntity> list = projectChangeService.list(queryWrapper);
    		List<ProjectChangeVO> backList = new ArrayList<>();
    		if(list!=null&&list.size()>0){
    			backList = BeanMapper.mapList(list, ProjectChangeVO.class);
    		}
    		resp.setProjectChangeList(backList);
        }

        return CommonResponse.success("查询详情成功！", resp);
    	
    }


    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<ProjectApplyVO> saveChange(@RequestBody ProjectApplyVO vo) {
    	return projectChangeService.saveChange(vo);
    	
    }
    
}
