package com.ejianc.business.projectapply.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * 项目申请实体
 *
 * @author CJ
 * @Description: 项目申请实体
 * @date 2021/9/6 10:07
 */
public class ProjectApplyVO extends BaseVO {
    private static final long serialVersionUID = 1204119316669479517L;

    /**
     * 项目状态：启用
     */
    public static final Integer PROJECT_STATUS_OPEN = 1;
    /**
     * 项目状态：停用
     */
    public static final Integer PROJECT_STATUS_DISCONTINUED = 0;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 项目状态：0-停用，1-启用
     */
    private Integer status;

    /**
     * 项目是否需要拆分
     */
    private Boolean projectSplit;

    /**
     * 项目所在国家地区
     */
    private Long belongArea;

    /**
     * 项目所在国家地区名称
     */
    private String belongAreaName;

    /**
     * 项目分类：国内-国内项目，国外-国外项目
     */
    private String projectClassification;

    /**
     * 项目中文名称
     */
    private String cnName;

    /**
     * 项目英文名称，当项目为国外项目时，该项必填
     */
    private String enName;

    /**
     * 项目类型
     */
    private Long projectType;

    /**
     * 项目业主Id
     */
    private Long businessEntrepreneur;

    /**
     * 项目业主名称
     */
    private String businessEntrepreneurName;

    /**
     * 计划开工
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date projectStartDate;

    /**
     * 竣工日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date projectFinishDate;

    /**
     * 计划工期（天）
     */
    private Integer planDaysLimit;

    /**
     * 项目曾用名
     */
    private String usedNames;

    /**
     * 备注
     */
    private String remark;

    /**
     * 执行主体子表
     */
    List<ExecutiveAgentVO> executiveAgentList;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    /***  页面展示使用 ***/
    /**
     * 执行主体名称
     */
    private String executiveAgentNames;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 项目类型名称
     */
    private String projectTypeName;

    /**
     * 项目编码
     */
    private String billCode;

    /**
     * 申请人Id
     */
    private Long applyUserId;
    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请部门Id
     */
    private Long applyDeptId;
    /**
     * 申请部门名称
     */
    private String applyDeptName;

    /**
     * 变更记录子表
     */
    List<ProjectChangeVO> projectChangeList;

    /*** 导出使用字段  ****/

    /**
     * 单据审批状态名称
     */
    private String billStateName;

    /**
     * 项目拆分展示名称
     */
    private String splitTypeDisplay;

    /**
     * 创建时间字符串
     */
    private String createTimeStr;

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public String getSplitTypeDisplay() {
        return splitTypeDisplay;
    }

    public void setSplitTypeDisplay(String splitTypeDisplay) {
        this.splitTypeDisplay = splitTypeDisplay;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getApplyDeptId() {
        return applyDeptId;
    }

    @ReferDeserialTransfer
    public void setApplyDeptId(Long applyDeptId) {
        this.applyDeptId = applyDeptId;
    }

    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getExecutiveAgentNames() {
        return executiveAgentNames;
    }

    public void setExecutiveAgentNames(String executiveAgentNames) {
        this.executiveAgentNames = executiveAgentNames;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Boolean getProjectSplit() {
        return projectSplit;
    }

    public void setProjectSplit(Boolean projectSplit) {
        this.projectSplit = projectSplit;
    }

    public Long getBelongArea() {
        return belongArea;
    }

    @ReferDeserialTransfer
    public void setBelongArea(Long belongArea) {
        this.belongArea = belongArea;
    }


    public String getProjectClassification() {
        return projectClassification;
    }

    public void setProjectClassification(String projectClassification) {
        this.projectClassification = projectClassification;
    }

    public String getCnName() {
        return cnName;
    }

    public void setCnName(String cnName) {
        this.cnName = cnName;
    }

    public String getEnName() {
        return enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public Long getProjectType() {
        return projectType;
    }

    @ReferDeserialTransfer
    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public Long getBusinessEntrepreneur() {
        return businessEntrepreneur;
    }

    @ReferDeserialTransfer
    public void setBusinessEntrepreneur(Long businessEntrepreneur) {
        this.businessEntrepreneur = businessEntrepreneur;
    }

    public String getBusinessEntrepreneurName() {
        return businessEntrepreneurName;
    }

    public void setBusinessEntrepreneurName(String businessEntrepreneurName) {
        this.businessEntrepreneurName = businessEntrepreneurName;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getProjectFinishDate() {
        return projectFinishDate;
    }

    public void setProjectFinishDate(Date projectFinishDate) {
        this.projectFinishDate = projectFinishDate;
    }

    public Integer getPlanDaysLimit() {
        return planDaysLimit;
    }

    public void setPlanDaysLimit(Integer planDaysLimit) {
        this.planDaysLimit = planDaysLimit;
    }

    public String getUsedNames() {
        return usedNames;
    }

    public void setUsedNames(String usedNames) {
        this.usedNames = usedNames;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<ExecutiveAgentVO> getExecutiveAgentList() {
        return executiveAgentList;
    }

    public void setExecutiveAgentList(List<ExecutiveAgentVO> executiveAgentList) {
        this.executiveAgentList = executiveAgentList;
    }

    public String getBelongAreaName() {
        return belongAreaName;
    }

    public void setBelongAreaName(String belongAreaName) {
        this.belongAreaName = belongAreaName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

	public List<ProjectChangeVO> getProjectChangeList() {
		return projectChangeList;
	}

	public void setProjectChangeList(List<ProjectChangeVO> projectChangeList) {
		this.projectChangeList = projectChangeList;
	}
    
}
