package com.ejianc.business.projectapply.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ExecutiveAgentEntity;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.service.IExecutiveAgentService;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 项目信息
 *
 * @author CJ
 * @Description: 项目申请控制器
 * @date 2021/9/6 10:10
 */
@RestController
@RequestMapping("/projectInfo/")
public class ProjectInfoController {

    @Autowired
    private IProjectApplyService projectApplyService;

    @Autowired
    private IExecutiveAgentService executiveAgentService;
    
    @Autowired
    private IOrgApi orgApi;

    /**
     * 分页查询项目申请列表
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "queryList")
    public CommonResponse<IPage<ProjectApplyVO>> queryList(@RequestBody QueryParam queryParam) {
    	Parameter range = queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
		queryParam.getParams().put("billState", new Parameter("in","1,3"));//默认查询审批通过的数据
    	Parameter orgIdParam = queryParam.getParams().get("orgId");
        List<Long> orgIds =new ArrayList<>();
        Long orgId = (orgIdParam!=null&&orgIdParam.getValue()!=null)?Long.parseLong(orgIdParam.getValue().toString()):InvocationInfoProxy.getOrgId();
        if("selfAndBelow".equals(range.getValue())) {
            //查询本下
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
            }
            orgIds = childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        } else {
            //查询本级
            orgIds.add(orgId);
        }

        Map<String, Parameter> params = queryParam.getParams();
        String billState = null != params.get("billState") ? params.get("billState").toString() : null;
        String createTime = null != params.get("createTime") ? params.get("createTime").toString() : null;
        String projectSplit = null != params.get("projectSplit") ? params.get("projectSplit").toString() : null;
        long count = projectApplyService.countPage(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds);
        IPage<ProjectApplyVO> page = new Page<>();
        if(count > 0) {
            long pageSize = page.getSize();
            long pageNum = page.getCurrent();
            pageNum = pageNum - 1 < 0 ? 0 : pageNum - 1;
            long startLine = pageNum * pageSize;
            List<ProjectApplyVO> records = projectApplyService.pageList(queryParam.getSearchText(), billState,
                    createTime, projectSplit, orgIds, startLine, pageSize, queryParam.getOrderMap().get("createTime"));


            page.setCurrent(pageNum);
            page.setSize(pageSize);
            page.setTotal(count);
            page.setRecords(records);
        }
        return CommonResponse.success("分页查询成功！", page);
    }

    /**
     * 查询项目拆分详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryExecutiveAgentList")
    public CommonResponse<List<ExecutiveAgentVO>> queryExecutiveAgentList(@RequestParam(value = "projectId") Long projectId) {
    	QueryWrapper<ExecutiveAgentEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("project_apply_id", projectId);
		List<ExecutiveAgentEntity> list = executiveAgentService.list(queryWrapper);
		List<ExecutiveAgentVO> backList = new ArrayList<>();
		if(list!=null&&list.size()>0){
			backList = BeanMapper.mapList(list, ExecutiveAgentVO.class);
		}
        return CommonResponse.success("查询详情成功！", backList);
    }

    /**
     * 变更启用状态
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "changeStatus")
    public CommonResponse<String> changeStatus(@RequestBody List<ProjectApplyVO> dataList) {
    	List<Long> projectIds = new ArrayList<>();
    	if(dataList!=null&&dataList.size()>0){
    		for(ProjectApplyVO vo : dataList){
    			projectIds.add(vo.getId());
    		}
    	}else{
    		return CommonResponse.error("数据不能为空");
    	}
    	List<ProjectApplyEntity> list = (List<ProjectApplyEntity>) projectApplyService.listByIds(projectIds);
    	if(!(list!=null&&list.size()>0)){
    		return CommonResponse.error("数据不能为空");
    	}
    	Boolean status = true;//启用状态
    	if(ProjectApplyVO.PROJECT_STATUS_OPEN.equals(list.get(0).getStatus())){
    		//目前状态为启用，要将其停用
    		status = false;
    	}
        for(ProjectApplyEntity entity : list){
        	if(status){
        		entity.setStatus(ProjectApplyVO.PROJECT_STATUS_OPEN);//启用
        	}else{
        		entity.setStatus(ProjectApplyVO.PROJECT_STATUS_DISCONTINUED);//停用
        	}
        }
        projectApplyService.saveOrUpdateBatch(list, list.size(), false);
        return CommonResponse.success((status?"启用":"停用")+"成功！");
    }
    
    //查询变更详情页面
    
}
