package com.ejianc.business.projectapply.service;

import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 项目申请服务
 *
 * @author CJ
 * @Description:
 * @date 2021/9/6 9:58
 */
public interface IProjectApplyService extends IBaseService<ProjectApplyEntity> {
    /**
     * 查询匹配数据总数
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @return
     */
    long countPage(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds);

    /**
     * 分页查询匹配的项目列表
     *
     * @param searchText
     * @param billState
     * @param createTime
     * @param projectSplit
     * @param orgIds
     * @param startLine
     * @param pageSize
     * @param createTimeOrderType
     * @return
     */
    List<ProjectApplyVO> pageList(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds, long startLine, long pageSize, String createTimeOrderType);

}
