/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ExecutiveAgentVO;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectApply/"})
public class ProjectApplyController {
    private final String BILL_CODE_RULE = "PRJ-APPLY-01";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<ProjectApplyVO>> pageList(@RequestBody QueryParam queryParam) {
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", this.queryPage(queryParam));
    }

    private IPage<ProjectApplyVO> queryPage(QueryParam queryParam) {
        String projectSplit;
        Parameter range = (Parameter)queryParam.getParams().get("range");
        queryParam.getParams().remove("range");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if ("selfAndBelow".equals(range.getValue())) {
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgIds = ((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds.add(InvocationInfoProxy.getOrgId());
        }
        Map params = queryParam.getParams();
        String billState = null != params.get("billState") ? ((Parameter)params.get("billState")).getValue().toString() : null;
        String createTime = null != params.get("createTime") ? ((Parameter)params.get("createTime")).getValue().toString() : null;
        String string = projectSplit = null != params.get("projectSplit") ? ((Parameter)params.get("projectSplit")).getValue().toString() : null;
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            Object[] rangeArr = createTime.split(",");
            rangeArr[0] = rangeArr[0] + " 00:00:00";
            rangeArr[1] = rangeArr[1] + " 23:59:59";
            createTime = StringUtils.join((Object[])rangeArr, (String)",");
        }
        long count = this.projectApplyService.countPage(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds);
        Page page = new Page();
        if (count > 0L) {
            long pageSize = page.getSize();
            long pageNum = page.getCurrent();
            pageNum = pageNum - 1L < 0L ? 0L : pageNum - 1L;
            long startLine = pageNum * pageSize;
            List<ProjectApplyVO> records = this.projectApplyService.pageList(queryParam.getSearchText(), billState, createTime, projectSplit, orgIds, startLine, pageSize, (String)queryParam.getOrderMap().get("createTime"));
            page.setCurrent(pageNum);
            page.setSize(pageSize);
            page.setTotal(count);
            page.setRecords(records);
        }
        return page;
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ProjectApplyVO> saveOrUpdate(@RequestBody ProjectApplyVO vo) {
        ProjectApplyVO resp = null;
        ProjectApplyEntity saveEntity = null;
        HashSet<String> repeatCheck = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getExecutiveAgentList())) {
            StringBuilder executiveAgentNames = new StringBuilder();
            String repeatCheckStr = null;
            for (ExecutiveAgentVO e : vo.getExecutiveAgentList()) {
                if ("del".equals(e.getRowState())) continue;
                executiveAgentNames.append(e.getExecutiveAgentName()).append(",");
                e.setProjectSplit(vo.getProjectSplit());
                repeatCheckStr = this.getRepeatCheckStr(e.getSplitType(), e.getExecutiveAgentId());
                if (e.getProjectSplit().booleanValue() && repeatCheck.contains(repeatCheckStr)) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u884c\u4e3b\u4f53\u91cd\u590d\uff01");
                }
                repeatCheck.add(repeatCheckStr);
            }
            vo.setExecutiveAgentNames(executiveAgentNames.substring(0, executiveAgentNames.length() - 1));
        }
        if (StringUtils.isBlank((CharSequence)vo.getExecutiveAgentNames())) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u884c\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        saveEntity = (ProjectApplyEntity)((Object)BeanMapper.map((Object)vo, ProjectApplyEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        if (null == vo.getId()) {
            CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode("PRJ-APPLY-01", InvocationInfoProxy.getTenantid());
            if (!billCodeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveEntity.setBillCode((String)billCodeResp.getData());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setStatus(ProjectApplyVO.PROJECT_STATUS_OPEN);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            ProjectApplyEntity dbEntity = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(vo.getId()));
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setBillCode(dbEntity.getBillCode());
            saveEntity.setBillState(dbEntity.getBillState());
        }
        this.projectApplyService.saveOrUpdate((Object)saveEntity, false);
        resp = (ProjectApplyVO)BeanMapper.map((Object)((Object)saveEntity), ProjectApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    private String getRepeatCheckStr(String splitType, Long executiveAgentId) {
        if (StringUtils.isBlank((CharSequence)splitType)) {
            return executiveAgentId.toString();
        }
        if (splitType.indexOf(",") < 0) {
            return splitType + executiveAgentId;
        }
        Object[] typeArr = splitType.split(",");
        Arrays.sort(typeArr, String.CASE_INSENSITIVE_ORDER);
        return StringUtils.join((Object[])typeArr, (String)",") + executiveAgentId;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectApplyVO> queryDetail(@RequestParam(value="id") Long id) {
        ProjectApplyVO resp = null;
        ProjectApplyEntity dbEntity = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(id));
        if (null != dbEntity) {
            resp = (ProjectApplyVO)BeanMapper.map((Object)((Object)dbEntity), ProjectApplyVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectApplyVO> vos) {
        for (ProjectApplyVO vo2 : vos) {
            if (!BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo2.getBillState()) && !BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo2.getBillState())) continue;
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u80fd\u5220\u9664\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff01");
        }
        vos.forEach(vo -> this.projectApplyService.removeById(vo.getId(), false));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List voList = null;
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ProjectApplyVO> page = this.queryPage(queryParam);
        voList = page.getRecords();
        voList.forEach(vo -> {
            vo.setCreateTimeStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)vo.getCreateTime()));
            vo.setSplitTypeDisplay(vo.getProjectSplit() != false ? "\u62c6\u5206" : "\u975e\u62c6\u5206");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("sdsjProject-export.xlsx", beans, response);
    }
}

