/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectapply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.projectapply.bean.ExecutiveAgentEntity;
import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.bean.ProjectChangeEntity;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.service.IProjectChangeService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectApply")
public class ProjectApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectApplyService projectApplyService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${oms.splitPrjBelongOrgName}")
    private String splitPrjBelongOrgName;
    @Value(value="${oms.splitPrjBelongOrgType}")
    private Integer splitPrjBelongOrgType;
    @Autowired
    private IProjectChangeService projectChangeService;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectApplyEntity e = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.projectApplyService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u9879\u76ee\u7533\u8bf7\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrgVO org;
        String msg;
        ProjectApplyEntity e = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(billId));
        e.setEffectiveDate(new Date());
        if (state == 1) {
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.generateOrgInfo(e, org = new OrgVO())))) {
            return CommonResponse.error((String)msg);
        }
        CommonResponse orgSaveResp = this.orgApi.saveOrgInfo(org);
        if (!orgSaveResp.isSuccess()) {
            this.logger.error("\u751f\u6210\u9879\u76ee\u7533\u8bf7\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)orgSaveResp.getMsg());
            return CommonResponse.error((String)"\u751f\u6210\u9879\u76ee\u7533\u8bf7\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25! ");
        }
        this.projectApplyService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u9879\u76ee\u7533\u8bf7\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private String generateOrgInfo(ProjectApplyEntity e, OrgVO org) {
        org.setId(Long.valueOf(IdWorker.getId()));
        org.setShortName(e.getCnName());
        org.setName(e.getCnName());
        org.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        OrgVO parent = null;
        if (e.getProjectSplit().booleanValue()) {
            OrgVO query = new OrgVO();
            query.setName(this.splitPrjBelongOrgName);
            query.setTenantId(InvocationInfoProxy.getTenantid());
            query.setOrgType(this.splitPrjBelongOrgType);
            CommonResponse parentOrgInfoResp = this.orgApi.findOneByOrgVO(query);
            if (!parentOrgInfoResp.isSuccess()) {
                this.logger.error("\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-{}\uff0c\u7c7b\u578b-{}\u7684\u7ec4\u7ec7\u5931\u8d25\uff01", (Object)this.splitPrjBelongOrgName, (Object)this.splitPrjBelongOrgType);
                return "\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-" + this.splitPrjBelongOrgName + "\uff0c\u7c7b\u578b-" + this.splitPrjBelongOrgType + "\u7684\u7ec4\u7ec7\u5931\u8d25\uff01";
            }
            parent = (OrgVO)parentOrgInfoResp.getData();
        } else {
            ExecutiveAgentEntity sub = e.getExecutiveAgentList().get(0);
            CommonResponse parentOrgInfoResp = this.orgApi.detailById(sub.getExecutiveAgentId());
            if (!parentOrgInfoResp.isSuccess()) {
                this.logger.error("\u975e\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-{}\uff0cid-{}\u7684\u7ec4\u7ec7\u5931\u8d25\uff01", (Object)sub.getExecutiveAgentName(), (Object)sub.getExecutiveAgentId());
                return "\u975e\u62c6\u5206\u9879\u76ee\u67e5\u8be2\u6307\u5b9a\u4e0a\u7ea7: \u540d\u79f0-" + sub.getExecutiveAgentName() + "\u7684\u7ec4\u7ec7\u5931\u8d25\uff01";
            }
            parent = (OrgVO)parentOrgInfoResp.getData();
        }
        if (null == parent) {
            this.logger.error("\u9879\u76ee\u7533\u8bf7\u5355\u636e[id-{}]\u5bf9\u5e94\u4e0a\u7ea7\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff01");
            return "\u9879\u76ee\u4e0a\u7ea7\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01";
        }
        org.setParentId(parent.getId());
        org.setEnterpriseId(parent.getEnterpriseId());
        org.setIsParent(Boolean.valueOf(false));
        org.setTenantId(parent.getTenantId());
        org.setState(Integer.valueOf(1));
        e.setOrgName(parent.getName());
        e.setProjectDepartmentId(org.getId());
        e.setOrgId(org.getParentId());
        return null;
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ProjectApplyEntity e = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(billId));
        this.logger.info("\u9879\u76ee\u7533\u8bf7\u5355\u636e[billId-{}],[billTypeCode-{}]\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        List<ProjectChangeEntity> changeRecordsList = this.projectChangeService.getAllByProjectId(e.getId());
        if (CollectionUtils.isNotEmpty(changeRecordsList)) {
            this.logger.error("\u9879\u76ee\u7533\u8bf7\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u8be5\u5355\u636e\u5df2\u505a\u53d8\u66f4\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u3001\u5f03\u5ba1\u64cd\u4f5c\uff01");
            return CommonResponse.error((String)"\u5355\u636e\u5b58\u5728\u53d8\u66f4\u8bb0\u5f55\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u9879\u76ee\u7533\u8bf7\u5355\u636e[billId-{}],[billTypeCode-{}]\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c: ", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u9879\u76ee\u7533\u8bf7\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u9879\u76ee\u7533\u8bf7\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f!");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        ProjectApplyEntity e = (ProjectApplyEntity)((Object)this.projectApplyService.selectById(billId));
        this.logger.info("\u9879\u76ee\u7533\u8bf7\u5355\u636e-\u3010{}\u3011\u6267\u884c\u64a4\u56de\u903b\u8f91", (Object)JSONObject.toJSONString((Object)((Object)e)));
        CommonResponse delResp = this.orgApi.delSDSJPrjDepartmentByOrgId(e.getProjectDepartmentId());
        this.logger.error("\u9879\u76ee\u7533\u8bf7\u5355\u636e[billId-{}],[billTypeCode-{}]\u5220\u9664\u5bf9\u5e94\u9879\u76ee\u90e8\u7ed3\u679c: ", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)delResp)});
        if (!delResp.isSuccess()) {
            this.logger.error("\u9879\u76ee\u7533\u8bf7\u5355\u636e[billId-{}],[billTypeCode-{}]\u5220\u9664\u5bf9\u5e94\u9879\u76ee\u90e8\u5931\u8d25: ", new Object[]{billId, billTypeCode, delResp.getMsg()});
            return CommonResponse.error((String)"\u9879\u76ee\u7533\u8bf7\u5355\u636e\u5bf9\u5e94\u9879\u76ee\u90e8\u5220\u9664\u5931\u8d25\uff01");
        }
        e.setEffectiveDate(null);
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserName(null);
        this.projectApplyService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u6267\u884c\u9879\u76ee\u7533\u8bf7\u5355\u636e\u64a4\u56de\u903b\u8f91\u6210\u529f! ");
    }
}

