package com.ejianc.business.projectapply.service.impl;

import com.ejianc.business.projectapply.bean.ProjectApplyEntity;
import com.ejianc.business.projectapply.mapper.ProjectApplyMapper;
import com.ejianc.business.projectapply.service.IProjectApplyService;
import com.ejianc.business.projectapply.vo.ProjectApplyVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目申请服务实现
 *
 * @author CJ
 * @Description: 项目申请服务实现
 * @date 2021/9/6 9:59
 */
@Service(value = "projectApplyService")
public class ProjectApplyServiceImpl extends BaseServiceImpl<ProjectApplyMapper, ProjectApplyEntity> implements IProjectApplyService {

    @Autowired
    private ProjectApplyMapper projectApplyMapper;

    @Override
    public long countPage(String searchText, String billState, String createTime, String projectSplit, List<Long> orgIds, String status) {
        return projectApplyMapper.countPage(searchText, billState, createTime, projectSplit, orgIds, status);
    }

    @Override
    public List<ProjectApplyVO> pageList(String searchText, String billState, String createTime, String projectSplit,
                                         List<Long> orgIds, long startLine, long pageSize, String createTimeOrderType, String status) {
        return projectApplyMapper.pageList(searchText, billState, createTime, projectSplit, orgIds, startLine, pageSize, createTimeOrderType, status);
    }

}
