package com.ejianc.business.sealm.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.api.IContractFillingApi;
import com.ejianc.business.sealm.bean.FillingEntity;
import com.ejianc.business.sealm.bean.ZcyysqEntity;
import com.ejianc.business.sealm.service.IZcyysqService;
import com.ejianc.business.sealm.service.IZcyysqSignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 用印申请
 * 
 * @author sunxiaoyi
 * 
 */
@Controller
@RequestMapping("zcyysqSignature")
public class ZcyysqSignatureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IZcyysqService service;

    @Autowired
    IZcyysqSignatureService izcyysqSignatureService;


    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    public CommonResponse<String> changeStatus(@RequestBody String objectStr) {
        if (StringUtils.isEmpty(objectStr)) {
            throw new BusinessException("签章流程返回对象为空，请检查！");
        }
        logger.info("签章流程返回对象--{}", objectStr);
        JSONObject object = (JSONObject) JSONObject.parse(objectStr);
        String billId = object.getString("billId");
        String status = object.getString("status");
        String refCode = object.getString("refCode");
        if (StringUtils.isEmpty(billId) || StringUtils.isEmpty(status) || StringUtils.isEmpty(refCode)) {
            return CommonResponse.error("参数异常，请检查相关参数！");
        }
        return izcyysqSignatureService.relieveContract(Long.valueOf(billId), status, refCode);
    }


    @Autowired
    private IContractFillingApi fillingApi;


    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @return 结果数据
     */
    @RequestMapping(value = "/changeContractFilling", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeContractFilling(Long id) {



        ZcyysqEntity zcyysqEntity = service.selectById(id);
        if (zcyysqEntity != null) {
                if (zcyysqEntity.getHtId() != null && zcyysqEntity.getSignatureStatus().equals("4")) {

                        FillingEntity fillingEntity = new FillingEntity();
                        if (zcyysqEntity.getHtlxName().equals("劳务分包合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSub");
                        } else if (zcyysqEntity.getHtlxName().equals("劳务分包合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("laborSubChange");
                        } else if (zcyysqEntity.getHtlxName().equals("材料采购合同") && zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterial");
                        } else if (zcyysqEntity.getHtlxName().equals("材料采购合同") && zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractMaterialChange");
                        } else if (zcyysqEntity.getHtlxName().equals("专业分包合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSub");
                        } else if (zcyysqEntity.getHtlxName().equals("专业分包合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("proSubChange");
                        } else if (zcyysqEntity.getHtlxName().equals("商砼采购合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcrete");
                        } else if (zcyysqEntity.getHtlxName().equals("商砼采购合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractConcreteChange");
                        } else if (zcyysqEntity.getHtlxName().equals("周转材租赁合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmat");
                        } else if (zcyysqEntity.getHtlxName().equals("周转材租赁合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("rmatChange");
                        } else if (zcyysqEntity.getHtlxName().equals("其他支出合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOther");
                        } else if (zcyysqEntity.getHtlxName().equals("其他支出合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractOtherChange");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备安拆合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractAC");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备安拆合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("contractACChange");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备租赁合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRent");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备租赁合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentRentChange");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备采购合同")&& zcyysqEntity.getHtlb() == 0) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchase");
                        } else if (zcyysqEntity.getHtlxName().equals("机械设备采购合同")&& zcyysqEntity.getHtlb() == 3) {
                            fillingEntity.setBillId(zcyysqEntity.getHtId());
                            fillingEntity.setStatus(1);
                            fillingEntity.setFillingType("equipmentPurchaseChange");
                        }
                        if (fillingEntity.getFillingType() != null) {
                            String s = JSONObject.toJSONString(fillingEntity);
                            CommonResponse<String> stringCommonResponse = fillingApi.updateFilingStatus(s);
                            return stringCommonResponse;
                        }

                }

        }
        return CommonResponse.success("修改归档状态成功！");
    }
}
