package com.ejianc.business.settle.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
/**
 * 图纸到图计划
 * 
 * @author generator
 * 
 */
 @TableName("settlement_center_draw_plan")
public class SettlementCenterDrawPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_major_id")
    private Long projectMajorId; // 项目专业id
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="settlement_center_major_name")
    private String settlementCenterMajorName; // 结算中心专业名称
    @TableField(value="settlement_center_major")
    private Long settlementCenterMajor; // 结算中心专业
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="system_name")
    private String systemName; // 系统名称
    @TableField(value="pro_start_time")
    private Date proStartTime; // 工程开始时间
    @TableField(value="pro_end_time")
    private Date proEndTime; // 工程结束时间
    @TableField(value="cal_start_time")
    private Date calStartTime; // 计量开始时间
    @TableField(value="cal_end_time")
    private Date calEndTime; // 计量结束时间
    @TableField(value="total_num")
    private Integer totalNum; // 总册数
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="statistical_person")
    private Long statisticalPerson; // 负责人

    @TableField(value="major_manager_person")
    private Long majorManagerPerson; // 专业主管
    @TableField(value="project_responsible_person")
    private Long projectResponsiblePerson; // 项目负责人
    @TableField(value="project_contract_person")
    private Long projectContractPerson; // 项目合同主管
    @TableField(value="composite_person")
    private Long compositePerson; // 综合管理员

    @TableField(value = "plan_finish_days")
    private Integer planFinishDays;// 期望值
    @TableField(value = "compare_id")
    private Long compareId;//工程量对照表id

    
    @TableField(exist=false)
    @SubEntity(serviceName="settlementCenterDrawPlanDetailService")
    private List<SettlementCenterDrawPlanDetailEntity> settlementCenterDrawPlanDetailList = new ArrayList<>(); // 图纸到图计划明细


    public Long getCompareId() {
        return compareId;
    }

    public void setCompareId(Long compareId) {
        this.compareId = compareId;
    }

    public Long getMajorManagerPerson() {
        return majorManagerPerson;
    }

    public void setMajorManagerPerson(Long majorManagerPerson) {
        this.majorManagerPerson = majorManagerPerson;
    }

    public Long getProjectResponsiblePerson() {
        return projectResponsiblePerson;
    }

    public void setProjectResponsiblePerson(Long projectResponsiblePerson) {
        this.projectResponsiblePerson = projectResponsiblePerson;
    }

    public Long getProjectContractPerson() {
        return projectContractPerson;
    }

    public void setProjectContractPerson(Long projectContractPerson) {
        this.projectContractPerson = projectContractPerson;
    }

    public Long getCompositePerson() {
        return compositePerson;
    }

    public void setCompositePerson(Long compositePerson) {
        this.compositePerson = compositePerson;
    }

    public Integer getPlanFinishDays() {
        return planFinishDays;
    }

    public void setPlanFinishDays(Integer planFinishDays) {
        this.planFinishDays = planFinishDays;
    }

    public Long getStatisticalPerson() {
        return statisticalPerson;
    }

    public void setStatisticalPerson(Long statisticalPerson) {
        this.statisticalPerson = statisticalPerson;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getProjectMajorId() {
        return projectMajorId;
    }

    public void setProjectMajorId(Long projectMajorId) {
        this.projectMajorId = projectMajorId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getSettlementCenterMajorName() {
        return settlementCenterMajorName;
    }

    public void setSettlementCenterMajorName(String settlementCenterMajorName) {
        this.settlementCenterMajorName = settlementCenterMajorName;
    }
    public Long getSettlementCenterMajor() {
        return settlementCenterMajor;
    }

    public void setSettlementCenterMajor(Long settlementCenterMajor) {
        this.settlementCenterMajor = settlementCenterMajor;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
    public Date getProStartTime() {
        return proStartTime;
    }

    public void setProStartTime(Date proStartTime) {
        this.proStartTime = proStartTime;
    }
    public Date getProEndTime() {
        return proEndTime;
    }

    public void setProEndTime(Date proEndTime) {
        this.proEndTime = proEndTime;
    }
    public Date getCalStartTime() {
        return calStartTime;
    }

    public void setCalStartTime(Date calStartTime) {
        this.calStartTime = calStartTime;
    }
    public Date getCalEndTime() {
        return calEndTime;
    }

    public void setCalEndTime(Date calEndTime) {
        this.calEndTime = calEndTime;
    }
    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }
    

    public List<SettlementCenterDrawPlanDetailEntity> getSettlementCenterDrawPlanDetailList() {
        return settlementCenterDrawPlanDetailList;
    }

    public void setSettlementCenterDrawPlanDetailList(List<SettlementCenterDrawPlanDetailEntity> settlementCenterDrawPlanDetailList) {
        this.settlementCenterDrawPlanDetailList = settlementCenterDrawPlanDetailList;
    }
}
