package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.vo.SettlementCenterAlertInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 预警信息表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementCenterAlertInfo")
@EnableScheduling
public class SettlementCenterAlertInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettlementCenterAlertInfoService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterAlertInfoVO> saveOrUpdate(@RequestBody SettlementCenterAlertInfoVO saveOrUpdateVO) {
        SettlementCenterAlertInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterAlertInfoEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SettlementCenterAlertInfoVO vo = BeanMapper.map(entity, SettlementCenterAlertInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterAlertInfoVO> queryDetail(Long id) {
        SettlementCenterAlertInfoEntity entity = service.selectById(id);
        SettlementCenterAlertInfoVO vo = BeanMapper.map(entity, SettlementCenterAlertInfoVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 预警消除功能
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterAlertInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterAlertInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterAlertInfoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterAlertInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("thirdNodeUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.EQ, userid)
            );
        }

        IPage<SettlementCenterAlertInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterAlertInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterAlertInfoVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementCenterAlertInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterAlertInfo-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterAlertInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterAlertInfoVO>> refSettlementCenterAlertInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                               String condition,
                                                                                               String searchObject,
                                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementCenterAlertInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterAlertInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterAlertInfoVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    @RequestMapping(value = "/testAlert", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse testAlert() {
        getWarning();
        return CommonResponse.success("成功！");
    }


    /**
     * 工作响应迟缓预警
     * 1.工作任务提交截止时间前24h,系统推送提醒。
     * 2.工作任务提交截止时间仍未提交,系统推送催交通知。
     * <p>
     * 统计人员id   统计人员name  卷册code   卷册name   期望完成时间  预警状态
     */
//    @Scheduled(cron = "0 0 2 * * ?")
    @ResponseBody
    public void getWarning() {
        // 所有需要预警的数据列表，每个对象有desired_time字段
        List<SettlementCenterDcDrwgrpInfoEntity> alertList = infoService
                .list(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>()
                        .lambda().eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getFlowState, 4));
        //循环获取每条数据,进行处理
        for (SettlementCenterDcDrwgrpInfoEntity alert : alertList) {
            //获取desiredTime期望完成时间
            Date desiredTime = alert.getDesiredTime();
            // 将Date转换为LocalDateTime
            LocalDateTime localDateTime = desiredTime.toInstant()
                    .atZone(ZoneId.systemDefault())
                    .toLocalDateTime()
                    .toLocalDate().atStartOfDay();;
            LocalDateTime alertTime = localDateTime.minusHours(24);
            if (localDateTime.isBefore(LocalDateTime.now())) {
                //工作任务提交截止时间仍未提交,系统推送催交通知
                service.saveNowAlert(alert);
            } else if (LocalDateTime.now().isAfter(alertTime)) {
                // 工作任务提交截止时间前24h,系统推送提醒
                service.saveLastAlert(alert);
            }
        }
    }

    /**
     * 根据结算中心职员id获取自己的预警
     *
     * @param id
     * @return
     */
//    @RequestMapping(value = "/queryIsAlert", method = RequestMethod.GET)
//    @ResponseBody
//    public Integer queryIsAlert(Long id) {
//        //通过统计人员id从预警表获取数据
//        return service.selectByUserId(id);
//        //查看预警状态是否需要预警,返回预警类型(0,1)
//        //需要就返回0
//        //不需要返回1
}

