package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settle.mapper.SettlementCenterDrawPlanDetailMapper;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 图纸到图计划明细
 * 
 * @author generator
 * 
 */
@Service("settlementCenterDrawPlanDetailService")
public class SettlementCenterDrawPlanDetailServiceImpl extends BaseServiceImpl<SettlementCenterDrawPlanDetailMapper, SettlementCenterDrawPlanDetailEntity> implements ISettlementCenterDrawPlanDetailService{

    @Override
    public CommonResponse<JSONObject> planDetailImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<SettlementCenterDrawPlanDetailVO> successList = new LinkedList<>();
            List<SettlementCenterDrawPlanDetailVO> errorList = new LinkedList<>();
            if (result != null && result.size() > 0) {
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    String warnType = "";
                    boolean importFlag = true;
                    SettlementCenterDrawPlanDetailVO vo = new SettlementCenterDrawPlanDetailVO();
                    String drwgrpCode = datas.get(0);
                    String drwgrpName = datas.get(1);
                    String startTimeStr = datas.get(2);
//                    String endTimeStr = datas.get(3);

                    vo.setId(IdWorker.getId());
                    if (StringUtils.isNotEmpty(drwgrpCode)){
                        vo.setDrwgrpCode(drwgrpCode);
                    }else {
                        warnType += "【卷册编码】不能为空;";
                        importFlag = false;
                    }

                    if (StringUtils.isNotEmpty(drwgrpName)){
                        vo.setDrwgrpName(drwgrpName);
                    }else {
                        warnType += "【卷册名称】不能为空;";
                        importFlag = false;
                    }

                    if (StringUtils.isNotEmpty(startTimeStr)){
                        try {
                            Date parse = sdf.parse(startTimeStr);
                            vo.setStartTime(parse);
                        } catch (ParseException e) {
                            warnType += "【开始时间】格式错误(yyyy-MM-dd);";
                            importFlag = false;
                        }
                    }else {
                        warnType += "【开始时间】不能为空;";
                        importFlag = false;
                    }

//                    if (StringUtils.isNotEmpty(endTimeStr)){
//                        try {
//                            Date parse = sdf.parse(endTimeStr);
//                            vo.setEndTime(parse);
//                        } catch (ParseException e) {
//                            warnType += "【结束时间】格式错误(yyyy-MM-dd);";
//                            importFlag = false;
//                        }
//                    }else {
//                        warnType += "【结束时间】不能为空;";
//                        importFlag = false;
//                    }

                    vo.setImportFlag(importFlag);
                    vo.setWarnType(warnType);
                    if (importFlag){
                        successList.add(vo);
                    }else {
                        errorList.add(vo);
                    }
                }
            }

            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            json.put("successNum", successList.size());
            json.put("errorNum", 0);
            return CommonResponse.success(json);
        }
    }
}
