package com.ejianc.business.settlementmanage.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.EventListEntity;
import com.ejianc.business.settlementmanage.bean.SettlementPlanEntity;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.SettlementFinalizedVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.settlementmanage.bean.SubcontractCountersignedEntity;
import com.ejianc.business.settlementmanage.service.ISubcontractCountersignedService;
import com.ejianc.business.settlementmanage.vo.SubcontractCountersignedVO;

/**
 * 分包结算条件会签单-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("subcontractCountersigned")
public class SubcontractCountersignedController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubcontractCountersignedService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractCountersignedVO> saveOrUpdate(@RequestBody SubcontractCountersignedVO saveorUpdateVO) {
        SubcontractCountersignedEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractCountersignedEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SubcontractCountersignedVO vo = BeanMapper.map(entity, SubcontractCountersignedVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractCountersignedVO> queryDetail(Long id) {
        SubcontractCountersignedEntity entity = service.selectById(id);
        SubcontractCountersignedVO vo = BeanMapper.map(entity, SubcontractCountersignedVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractCountersignedVO> vos) {
        service.removeByIds(vos.stream().map(SubcontractCountersignedVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractCountersignedVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("agentName");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubcontractCountersignedEntity> page = service.queryPage(param, false);
        IPage<SubcontractCountersignedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractCountersignedVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("agentName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractCountersignedEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubcontractCountersignedVO> SubcontractCountersignedVOList = BeanMapper.mapList(list, SubcontractCountersignedVO.class);
        for (int i = 0; i < SubcontractCountersignedVOList.size(); i++) {
            SubcontractCountersignedVO subcontractCountersignedVO = SubcontractCountersignedVOList.get(i);
            if (subcontractCountersignedVO.getCreateTime() != null) {
                subcontractCountersignedVO.setCreateTimeShow(DateUtils.dateSimple2(subcontractCountersignedVO.getCreateTime()));
            }

            String billStateStr = subcontractCountersignedVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "审批驳回";
                }
                subcontractCountersignedVO.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", SubcontractCountersignedVOList);
        ExcelExport.getInstance().export("SubcontractCountersigned-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractCountersignedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractCountersignedVO>> refSubcontractCountersignedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                             String condition,
                                                                                             String searchObject,
                                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubcontractCountersignedEntity> page = service.queryPage(param, false);
        IPage<SubcontractCountersignedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractCountersignedVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "query", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractCountersignedEntity> query(Long contractId) {
        QueryWrapper<SubcontractCountersignedEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", "1", "3");
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("dr", 0);
        List<SubcontractCountersignedEntity> subcontractCountersigned = service.list(queryWrapper);
        SubcontractCountersignedEntity subcontractCountersignedEntity = null;
        if (subcontractCountersigned.size() > 0) {
            subcontractCountersignedEntity = subcontractCountersigned.get(0);
            return CommonResponse.success("查询成功！", subcontractCountersignedEntity);
        }
        return CommonResponse.success("查询成功！", subcontractCountersignedEntity);

    }

    @RequestMapping(value = "query1", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List> query1(Long projectId) {
        QueryWrapper<SubcontractCountersignedEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", "1", "3");
        queryWrapper.eq("dr", 0);
        List<SubcontractCountersignedEntity> subcontractCountersigned = service.list(queryWrapper);
        int count = subcontractCountersigned.size();
        return CommonResponse.success("查询成功！",subcontractCountersigned);
    }
}
