package com.ejianc.business.settlementmanage.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 物资采购结算-主表
 * 
 * @author generator
 * 
 */
public class MaterialPurchaseSettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractName; // 合同名称
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long buyer; // 需方
    private java.lang.Long supplier; // 供方
    private java.lang.String contractCode; // 合同编码
    private java.lang.String listingCode; // 清单编码
    private java.lang.String projectCode; // 项目编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settlementStartTime; // 结算起始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settlementEndTime; // 结算截止时间
    private java.math.BigDecimal extaxPrice; // 子表结算单价汇总金额(除税)
    private java.math.BigDecimal intaxPrice; // 子表结算单价汇总金额(含税)
    private java.math.BigDecimal extaxSummaryAmount; // 子表结算汇总金额(除税)
    private java.math.BigDecimal intaxSummaryAmount; // 子表结算汇总金额(含税)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date date; // 日期
    private java.lang.String agentName; // 经办人名称
    private java.lang.Long agentDepartment; // 经办人部门
    private java.lang.Long agentId; // 经办人
    private java.lang.String remarks; // 备注
    private java.lang.String type; // 结算类型
    private java.lang.String billStateStr; // 结算类型
    private java.lang.String createTimeShow; // 结算类型
    private java.lang.String buyerName; // 结算类型
    private java.lang.String supplierName; // 结算类型
    private List<MaterialPurchaseDetailVO> materialPurchaseDetailEntities = new ArrayList<>(); // 物资采购结算-子表


    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 需方
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getBuyer() {
        return buyer;
    }

    /**
     * 需方
     */
    @ReferDeserialTransfer
    public void setBuyer(java.lang.Long buyer) {
        this.buyer = buyer;
    }
    /**
     * 供方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public java.lang.Long getSupplier() {
        return supplier;
    }

    /**
     * 供方
     */
    @ReferDeserialTransfer
    public void setSupplier(java.lang.Long supplier) {
        this.supplier = supplier;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 清单编码
     */
    public java.lang.String getListingCode() {
        return listingCode;
    }

    /**
     * 清单编码
     */
    public void setListingCode(java.lang.String listingCode) {
        this.listingCode = listingCode;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 结算起始时间
     */
    public java.util.Date getSettlementStartTime() {
        return settlementStartTime;
    }

    /**
     * 结算起始时间
     */
    public void setSettlementStartTime(java.util.Date settlementStartTime) {
        this.settlementStartTime = settlementStartTime;
    }
    /**
     * 结算截止时间
     */
    public java.util.Date getSettlementEndTime() {
        return settlementEndTime;
    }

    /**
     * 结算截止时间
     */
    public void setSettlementEndTime(java.util.Date settlementEndTime) {
        this.settlementEndTime = settlementEndTime;
    }
    /**
     * 子表结算单价汇总金额(除税)
     */
    public java.math.BigDecimal getExtaxPrice() {
        return extaxPrice;
    }

    /**
     * 子表结算单价汇总金额(除税)
     */
    public void setExtaxPrice(java.math.BigDecimal extaxPrice) {
        this.extaxPrice = extaxPrice;
    }
    /**
     * 子表结算单价汇总金额(含税)
     */
    public java.math.BigDecimal getIntaxPrice() {
        return intaxPrice;
    }

    /**
     * 子表结算单价汇总金额(含税)
     */
    public void setIntaxPrice(java.math.BigDecimal intaxPrice) {
        this.intaxPrice = intaxPrice;
    }
    /**
     * 子表结算汇总金额(除税)
     */
    public java.math.BigDecimal getExtaxSummaryAmount() {
        return extaxSummaryAmount;
    }

    /**
     * 子表结算汇总金额(除税)
     */
    public void setExtaxSummaryAmount(java.math.BigDecimal extaxSummaryAmount) {
        this.extaxSummaryAmount = extaxSummaryAmount;
    }
    /**
     * 子表结算汇总金额(含税)
     */
    public java.math.BigDecimal getIntaxSummaryAmount() {
        return intaxSummaryAmount;
    }

    /**
     * 子表结算汇总金额(含税)
     */
    public void setIntaxSummaryAmount(java.math.BigDecimal intaxSummaryAmount) {
        this.intaxSummaryAmount = intaxSummaryAmount;
    }
    /**
     * 日期
     */
    public java.util.Date getDate() {
        return date;
    }

    /**
     * 日期
     */
    public void setDate(java.util.Date date) {
        this.date = date;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人名称
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }


    @ReferSerialTransfer(referCode="idm-dept")
    public Long getAgentDepartment() {
        return agentDepartment;
    }
    @ReferDeserialTransfer
    public void setAgentDepartment(Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<MaterialPurchaseDetailVO> getMaterialPurchaseDetailEntities() {
        return materialPurchaseDetailEntities;
    }

    public void setMaterialPurchaseDetailEntities(List<MaterialPurchaseDetailVO> materialPurchaseDetailEntities) {
        this.materialPurchaseDetailEntities = materialPurchaseDetailEntities;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
}
