package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseDetailEntity;
import com.ejianc.business.settlementmanage.service.IDesignSettlementDetailService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseDetailService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.DesignSettlementDetailVO;
import com.ejianc.business.settlementmanage.vo.DesignSettlementVO;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseDetailVO;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("designSettlementExport")
public class ExcelDesignSettlementController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignSettlementDetailService materialPurchaseDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<DesignSettlementDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignSettlementDetailVO subpackagematerialanalysisdetailVO = list.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody DesignSettlementVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<DesignSettlementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<DesignSettlementDetailEntity> list = materialPurchaseDetailService.list(queryWrapper);
        List<DesignSettlementDetailVO> subpackagematerialanalysisdetailVOList = BeanMapper.mapList(list, DesignSettlementDetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); i++) {
                DesignSettlementDetailVO subpackagematerialanalysisdetailVO = subpackagematerialanalysisdetailVOList.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterialPurchaseSettlement")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsettlementdetail-import.xlsx", "设计类结算单   清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaterialPurchaseSettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignSettlementDetailVO> successList = new ArrayList<>();
        List<DesignSettlementDetailVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        HashMap<String, String> map1 = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    DesignSettlementDetailVO subpackagematerialanalysisdetailVO = new DesignSettlementDetailVO();
                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    subpackagematerialanalysisdetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setProjectCharacteristics(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(15)) ? datas.get(15) : null); // 备注
                    /**
                     * 项目重复校验
                     */
                    String data0 = map.get(datas.get(1));
                    if (map.get(data0) != null && StringUtils.isNotEmpty(data0) && data0.equals(datas.get(1))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目名称重复,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        map.put(datas.get(1), datas.get(1));
                        subpackagematerialanalysisdetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资编码
                    }
                    /**
                     * 非空校验
                     */
                    if (StringUtils.isEmpty(datas.get(1))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目名称不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(2))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目特征不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(3))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "计量单位不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(4))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "完成量（申报）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(5))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "除税单价(元)（申报）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "含税单价(元)（申报）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "完成量（审核）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "除税单价(元)（审核）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "含税单价(元)（审核）不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }


                    /**
                     * 数字格式校验
                     */
                    if (datas.get(4) != null && !"".equals(datas.get(4))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(4)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "完成量(申报)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setDeclareCompleteNum(Long.parseLong(String.valueOf(datas.get(4)))); // 供货数量
                        }
                    }
                    if (datas.get(5) != null && !"".equals(datas.get(5))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(5)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税单价(元)(申报)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setDeclareExtaxAddition(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 合同单价(除税)(元)
                        }
                    }
                    if (datas.get(6) != null && !"".equals(datas.get(6))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(6)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "含税单价(元)(申报)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setDeclareIntaxAddition(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(7) != null && !"".equals(datas.get(7))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(7)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税合价(元)(申报)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setDeclareExtaxAmount(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(8) != null && !"".equals(datas.get(8))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(8)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "含税合价(元)(申报)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setDeclareIntaxAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(9) != null && !"".equals(datas.get(9))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(9)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "完成量(审核)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditCompleteNum(Long.parseLong(String.valueOf(datas.get(9)))); // 供货数量
                        }
                    }
                    if (datas.get(10) != null && !"".equals(datas.get(10))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(10)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税单价(元)(审核)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditExtaxAddition(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(11) != null && !"".equals(datas.get(11))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(11)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "含税单价(元)(审核)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditIntaxAddition(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(12) != null && !"".equals(datas.get(12))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(12)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税合价(元)(审核)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditExtaxAmount(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(13) != null && !"".equals(datas.get(13))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(13)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税合价(元)(审核)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditIntaxAmount(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 合同单价(含税)(元)
                        }
                    }
                    /**
                     * 公式计算
                     */
                    if (datas.get(7) == null || "".equals(datas.get(7))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(4)).multiply(new BigDecimal(datas.get(5)));
                            subpackagematerialanalysisdetailVO.setDeclareExtaxAmount(extaxSummaryAmount);
                        }
                    } else {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setDeclareExtaxAmount(new BigDecimal(datas.get(7)));
                        }
                    }
                    if (datas.get(8) == null || "".equals(datas.get(8))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(4)).multiply(new BigDecimal(datas.get(6)));
                            subpackagematerialanalysisdetailVO.setDeclareIntaxAmount(extaxSummaryAmount);
                        }
                    } else {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setDeclareIntaxAmount(new BigDecimal(datas.get(8)));
                        }
                    }
                    if (datas.get(12) == null || "".equals(datas.get(12))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(9)).multiply(new BigDecimal(datas.get(10)));
                            subpackagematerialanalysisdetailVO.setAuditExtaxAmount(extaxSummaryAmount);
                        }
                    } else {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setAuditExtaxAmount(new BigDecimal(datas.get(12)));
                        }
                    }
                    if (datas.get(13) == null || "".equals(datas.get(13))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(9)).multiply(new BigDecimal(datas.get(11)));
                            subpackagematerialanalysisdetailVO.setAuditIntaxAmount(extaxSummaryAmount);
                        }
                    } else {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setAuditIntaxAmount(new BigDecimal(datas.get(13)));
                        }
                    }
                    /**
                     * 类别控制
                     */
                    if (datas.get(14) != null && !"".equals(datas.get(14))) {
                        if (!"合同内".equals(datas.get(14))&&!"合同外".equals(datas.get(14))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "类别输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setCategorys(StringUtils.isNotBlank(datas.get(14)) ? datas.get(14) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (num > 0) {
                        errorList.add(subpackagematerialanalysisdetailVO);
                    } else {
                        successList.add(subpackagematerialanalysisdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
