package com.ejianc.business.settlementmanage.excel;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.druid.sql.visitor.functions.Substring;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSetDetailEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSetDetailService;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementDetailVO;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementVO;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
@Controller
@RequestMapping("turnoverLeaseSettlementExport")

public class ExcelTurnoverLeaseSettlementController implements Serializable{
        private static final long serialVersionUID = 1L;
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        @Autowired
        private ITurnoverLeaseSetDetailService turnoverLeaseSetDetailService;
        @Autowired
        private IShareMaterialApi shareMaterialApi;
        /**
         * 导入模板下载
         *
         * @param request
         * @param response
         */
        @RequestMapping(value = "/downloadTurnoverLeaseSettlementDetail",method = RequestMethod.POST)
        @ResponseBody
        public void downloadTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) {
            ImportTemplate.initialize(response);
            ImportTemplate.templetdownload(request, "TurnoverLeaseSetDetail-import.xlsx", "周转租赁结算清单模板");
        }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportTurnoverLeaseSettlementDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<TurnoverLeaseSetDetailVO> successList = new ArrayList<>();
        List<TurnoverLeaseSetDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
           /* QueryWrapper<MechanicalleasedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<MechanicalleasedetailEntity> list = detailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }
*/

            if (result != null && result.size() > 0) {
                HashMap<String, String> map = new HashMap<>();

                for (int i = 1; i < result.size(); i++) {//取子表全部数据，进入循环，每次循环一行数据
                    int num = 0;
                    TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = new TurnoverLeaseSetDetailVO();
                    List<String> datas = result.get(i);
                    turnoverLeaseSetDetailVO.setId(IdWorker.getId());//id
//                  turnoverLeaseSetDetailVO.setMonths(DateUtils.Date(datas.get(1)));//月份
//                  turnoverLeaseSetDetailVO.setIntaxLeasePrice(StringUtils.isNotBlank(datas.get(2)) ? new BigDecimal(datas.get(2)) : null);//租赁合价(含税)
//                  turnoverLeaseSetDetailVO.setExtaxLeasePrice(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : null);//租赁合价(除税)
//                  turnoverLeaseSetDetailVO.setIntaxCompensationPayable(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null);//赔偿金额(含税)
//                  turnoverLeaseSetDetailVO.setExtaxCompensationPayable(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);//赔偿金额(除税)
//                  turnoverLeaseSetDetailVO.setIntaxRepair(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null);//修理费等其它费用(含税)
//                  turnoverLeaseSetDetailVO.setExtaxRepair(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null);//修理费等其它费用(除税)
//                  turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);//月度结算费用(含税)
//                  turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);//月度结算费用(除税)
                    turnoverLeaseSetDetailVO.setRemarks(StringUtils.isNotBlank(datas.get(10)) ? datas.get(10) : null);//备注


                    //判断月份是否重复
                    try {
                        Date data1 = DateUtils.Date(datas.get(1));//取到月份
                        String str = dateToStr(data1);//转成字符串
                        str = str.substring(0, 7);//取年月
                        /**
                         * map集合取转型的年月判断是否为空
                         * 判断转型的年月是否为空
                         * 转型的年月与集合里的年月进行比较
                         * 如果全部为ture，累加错误信息
                         * 否则将转型的年月放入集合中
                         */
                        if (map.get(str) != null && StringUtils.isNotEmpty(str) && str.equals(map.get(str))) {
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "月份重复！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            if(!DateUtils.grepDate(datas.get(1))){
                                String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                                if (errorMessage == null) errorMessage = "";
                                errorMessage += "月份输入格式错误！";
                                turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                                num++;
                            }else{
                                map.put(str, str);
                                turnoverLeaseSetDetailVO.setMonths(DateUtils.Date(datas.get(1)));
                            }

                        }
                    }catch (Exception e){
                       e.printStackTrace();
                    }

                    //数字格式校验
                    if(datas.get(2) != null && !"".equals(datas.get(2))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(2)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "租赁合价(含税)输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setIntaxLeasePrice(StringUtils.isNotBlank(datas.get(2)) ? new BigDecimal(datas.get(2)) : null);
                        }
                    }
                    if(datas.get(3) != null && !"".equals(datas.get(3))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(3)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "租赁合价(除税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setExtaxLeasePrice(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : null);
                        }
                    }
                    if(datas.get(4) != null && !"".equals(datas.get(4))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(4)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "赔偿金额(含税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setIntaxCompensationPayable(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null);


                        }
                    }
                    if(datas.get(5) != null && !"".equals(datas.get(5))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(5)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "赔偿金额(除税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setExtaxCompensationPayable(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);
                        }
                    }
                    if(datas.get(6) != null && !"".equals(datas.get(6))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(6)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "修理费等其它费用(含税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setIntaxRepair(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(6)) : null);
                        }
                    }
                    if(datas.get(7) != null && !"".equals(datas.get(7))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(7)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "修理费等其它费用(除税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setExtaxRepair(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(7)) : null);
                        }
                    }
                    if(datas.get(8) != null && !"".equals(datas.get(8))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(8)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "月度结算费用(含税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);
                        }
                    }
                    if(datas.get(9) != null && !"".equals(datas.get(9))){
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(9)))){
                            String errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "月度结算费用(除税) 输入格式错误！";
                            turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                            num++;
                        }else{
                            turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);
                        }
                    }
                    //公式计算
                    //月度结算费用(含税)
                    if(datas.get(8) != null && !"".equals(datas.get(8))){
                        turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);
                    }else{
                        if(num == 0){
                            BigDecimal intaxMonthlySettlementAmount = null ;//初始化公式字段
                            if(datas.get(2) != null && !"".equals(datas.get(2))){
                                intaxMonthlySettlementAmount = new BigDecimal(datas.get(2)) ;
                            }
                            if(datas.get(4) != null && !"".equals(datas.get(4))){
                                if(intaxMonthlySettlementAmount != null&& num==0){
                                    intaxMonthlySettlementAmount = intaxMonthlySettlementAmount.add(new BigDecimal(datas.get(4))) ;
                                }else{
                                    intaxMonthlySettlementAmount =new BigDecimal(datas.get(4));
                                }
                            }
                            if(datas.get(6) != null && !"".equals(datas.get(6))){
                                if(intaxMonthlySettlementAmount != null && num ==0){
                                    intaxMonthlySettlementAmount = intaxMonthlySettlementAmount.add(new BigDecimal(datas.get(6)));
                                }else{
                                    intaxMonthlySettlementAmount = new BigDecimal(datas.get(6));
                                }
                            }
                            if(intaxMonthlySettlementAmount != null &&num ==0){
                                turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(intaxMonthlySettlementAmount);
                            }

                        }
                    }
                    //公式计算
                    //月度结算费用(除税)
                    if(datas.get(9) != null && !"".equals(datas.get(9))){
                        turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);
                    }else{
                        if(num == 0){
                            BigDecimal extaxMonthlySettlementAmount = null ;//初始化公式字段
                            if(datas.get(3) != null && !"".equals(datas.get(3))){
                                extaxMonthlySettlementAmount = new BigDecimal(datas.get(3)) ;
                            }
                            if(datas.get(5) != null && !"".equals(datas.get(5))){
                                if(extaxMonthlySettlementAmount != null&&num ==0){
                                    extaxMonthlySettlementAmount = extaxMonthlySettlementAmount.add(new BigDecimal(datas.get(5))) ;
                                }else{
                                    extaxMonthlySettlementAmount =new BigDecimal(datas.get(5));
                                }
                            }
                            if(datas.get(7) != null && !"".equals(datas.get(7))){
                                if(extaxMonthlySettlementAmount != null&&num ==0){
                                    extaxMonthlySettlementAmount = extaxMonthlySettlementAmount.add(new BigDecimal(datas.get(7)));
                                }else{
                                    extaxMonthlySettlementAmount = new BigDecimal(datas.get(7));
                                }
                            }
                            if(extaxMonthlySettlementAmount != null&&num ==0){
                                turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(extaxMonthlySettlementAmount);
                            }

                        }
                    }
                    if (num > 0) {
                        errorList.add(turnoverLeaseSetDetailVO);
                    } else {
                        successList.add(turnoverLeaseSetDetailVO);
                    }
                }
            }

        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);

    }
    //日期转字符串
    public static String dateToStr(java.util.Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }
    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportTurnoverLeaseSettlementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementFromPage(@RequestBody List<TurnoverLeaseSetDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = list.get(i);
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
                if( turnoverLeaseSetDetailVO.getMonths()!=null){
                    turnoverLeaseSetDetailVO.setMonthsShow(DateUtils.dateSimple(turnoverLeaseSetDetailVO.getMonths()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }
    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportTurnoverLeaseSettlementDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementDatabase(@RequestBody TurnoverLeaseSettlementVO turnoverLeaseSettlementVO, HttpServletResponse response) {
        QueryWrapper<TurnoverLeaseSetDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", turnoverLeaseSettlementVO.getId());
        queryWrapper.eq("dr", 0);
        List<TurnoverLeaseSetDetailEntity> list = turnoverLeaseSetDetailService.list(queryWrapper);
        List<TurnoverLeaseSetDetailVO> tnrnoverLeaseSetDetailVOList = BeanMapper.mapList(list, TurnoverLeaseSetDetailVO.class);
        if (tnrnoverLeaseSetDetailVOList != null && tnrnoverLeaseSetDetailVOList.size() > 0) {
            for (int i = 0; i < tnrnoverLeaseSetDetailVOList.size(); i++) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = tnrnoverLeaseSetDetailVOList.get(i);
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
                if( turnoverLeaseSetDetailVO.getMonths()!=null){
                    turnoverLeaseSetDetailVO.setMonthsShow(DateUtils.dateSimple(turnoverLeaseSetDetailVO.getMonths()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", tnrnoverLeaseSetDetailVOList);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }


}
