package com.ejianc.business.settlementmanage.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算策划书评审-主表
 * 
 * @author generator
 * 
 */
public class SettlementPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.String agentName; // 经办人
    private java.lang.String contractName; // 合同名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date commencementDate; // 开工日期
    private java.lang.String commencementDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date completionDate; // 竣工日期
    private java.lang.String completionDateStr;
    private java.math.BigDecimal contractPrice; // 合同造价
    private java.math.BigDecimal actualCost; // 实际成本
    private java.math.BigDecimal settlementValue; // 报审结算值
    private java.math.BigDecimal visaClaims; // 签证索赔
    private java.math.BigDecimal designChanges; // 设计变更
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date submissionDate; // 合同约定结算提交日期
    private java.math.BigDecimal potentialCounterclaims; // 潜在违约及反索赔额
    private java.math.BigDecimal received; // 已收款
    private java.math.BigDecimal confirmedQuotation; // 业主已确认报量
    private java.lang.String remarks; // 备注
    private java.lang.Long agent; // 经办人id
    private java.lang.Long agentDepartment; // 经办人部门
    private java.lang.Long contractId; // 合同id
    private java.lang.String createTimeShow; // 创建时间文本显示
    private java.lang.String billStateStr; // 单据状态Str


    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")

    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer

    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 经办人
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 开工日期
     */
    public java.util.Date getCommencementDate() {
        return commencementDate;
    }

    /**
     * 开工日期
     */
    public void setCommencementDate(java.util.Date commencementDate) {
        this.commencementDate = commencementDate;
    }
    /**
     * 竣工日期
     */
    public java.util.Date getCompletionDate() {
        return completionDate;
    }

    /**
     * 竣工日期
     */
    public void setCompletionDate(java.util.Date completionDate) {
        this.completionDate = completionDate;
    }
    /**
     * 合同造价
     */
    public java.math.BigDecimal getContractPrice() {
        return contractPrice;
    }

    /**
     * 合同造价
     */
    public void setContractPrice(java.math.BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    /**
     * 实际成本
     */
    public java.math.BigDecimal getActualCost() {
        return actualCost;
    }

    /**
     * 实际成本
     */
    public void setActualCost(java.math.BigDecimal actualCost) {
        this.actualCost = actualCost;
    }
    /**
     * 报审结算值
     */
    public java.math.BigDecimal getSettlementValue() {
        return settlementValue;
    }

    /**
     * 报审结算值
     */
    public void setSettlementValue(java.math.BigDecimal settlementValue) {
        this.settlementValue = settlementValue;
    }
    /**
     * 签证索赔
     */
    public java.math.BigDecimal getVisaClaims() {
        return visaClaims;
    }

    /**
     * 签证索赔
     */
    public void setVisaClaims(java.math.BigDecimal visaClaims) {
        this.visaClaims = visaClaims;
    }
    /**
     * 设计变更
     */
    public java.math.BigDecimal getDesignChanges() {
        return designChanges;
    }

    /**
     * 设计变更
     */
    public void setDesignChanges(java.math.BigDecimal designChanges) {
        this.designChanges = designChanges;
    }
    /**
     * 合同约定结算提交日期
     */
    public java.util.Date getSubmissionDate() {
        return submissionDate;
    }

    /**
     * 合同约定结算提交日期
     */
    public void setSubmissionDate(java.util.Date submissionDate) {
        this.submissionDate = submissionDate;
    }
    /**
     * 潜在违约及反索赔额
     */
    public java.math.BigDecimal getPotentialCounterclaims() {
        return potentialCounterclaims;
    }

    /**
     * 潜在违约及反索赔额
     */
    public void setPotentialCounterclaims(java.math.BigDecimal potentialCounterclaims) {
        this.potentialCounterclaims = potentialCounterclaims;
    }
    /**
     * 已收款
     */
    public java.math.BigDecimal getReceived() {
        return received;
    }

    /**
     * 已收款
     */
    public void setReceived(java.math.BigDecimal received) {
        this.received = received;
    }
    /**
     * 业主已确认报量
     */
    public java.math.BigDecimal getConfirmedQuotation() {
        return confirmedQuotation;
    }

    /**
     * 业主已确认报量
     */
    public void setConfirmedQuotation(java.math.BigDecimal confirmedQuotation) {
        this.confirmedQuotation = confirmedQuotation;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")

    public java.lang.Long getAgent() {
        return agent;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer

    public void setAgent(java.lang.Long agent) {
        this.agent = agent;
    }
    /**
     * 经办人部门
     */
    @ReferSerialTransfer(referCode="idm-dept")

    public java.lang.Long getAgentDepartment() {
        return agentDepartment;
    }

    /**
     * 经办人部门
     */
    @ReferDeserialTransfer

    public void setAgentDepartment(java.lang.Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")

    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer

    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    public String getCommencementDateStr() {
        return commencementDateStr;
    }

    public void setCommencementDateStr(String commencementDateStr) {
        this.commencementDateStr = commencementDateStr;
    }

    public String getCompletionDateStr() {
        return completionDateStr;
    }

    public void setCompletionDateStr(String completionDateStr) {
        this.completionDateStr = completionDateStr;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }
}
