package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookQuantityBasDeatilEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookQuantityBasDeatilService;
import com.ejianc.business.settlementmanage.vo.SettlementBookQuantityBasDeatilVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 工程分包结算书-工程量依据导入导出
 */
@Controller
@RequestMapping("settlementBookBasExport")
public class ExcelSettlementBookQuantityBasController {

    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookQuantityBasDeatilService basDeatilService;

    @Autowired
    private IOutcontractApi outcontractApi;

    /**
     * 工程量依据导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportBasFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void exportBasFromPage(@RequestBody List<SettlementBookQuantityBasDeatilVO> list, HttpServletResponse response) {
        List<SettlementBookQuantityBasDeatilVO> records = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SettlementBookQuantityBasDeatilVO settlementBookQuantityBasDeatilVO = list.get(i);
                settlementBookQuantityBasDeatilVO.setSort(Long.valueOf(i + 1));
                records.add(settlementBookQuantityBasDeatilVO);
                if(settlementBookQuantityBasDeatilVO.getChildren()!=null&&settlementBookQuantityBasDeatilVO.getChildren().size()>0){
                    this.splitList(settlementBookQuantityBasDeatilVO.getChildren(),records);
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookQuantityBasDetail-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<SettlementBookQuantityBasDeatilVO> list,List<SettlementBookQuantityBasDeatilVO> records) {
        for(SettlementBookQuantityBasDeatilVO vo : list){
            String source = vo.getSource();
            if("1".equals(source)){//来源：1合同内 2合同外
                source = "合同内";
            }else if("2".equals(source)){
                source = "合同外";
            }
            vo.setSource(source);
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }

    /**
     * 工程量依据导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportBasFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void exportBasFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookQuantityBasDeatilEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", settlementBookVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookQuantityBasDeatilEntity> list = basDeatilService.list(queryWrapper);
        List<SettlementBookQuantityBasDeatilVO> basDeatilVOList = BeanMapper.mapList(list, SettlementBookQuantityBasDeatilVO.class);
        if (basDeatilVOList != null && basDeatilVOList.size() > 0) {
            for (int i = 0; i < basDeatilVOList.size(); i++) {
                SettlementBookQuantityBasDeatilVO basDeatilVO = basDeatilVOList.get(i);
                basDeatilVO.setSort(Long.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookQuantityBasDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量依据导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/basExcelDown")
    @ResponseBody
    public void basExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SettlementBookQuantityBasDetail-import.xlsx", "工程量依据模板");
    }

    /**
     * 工程量依据导入
     */
    @RequestMapping(value = "/basExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> basExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookQuantityBasDeatilVO> successList = new ArrayList<>();
        List<SettlementBookQuantityBasDeatilVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, SettlementBookQuantityBasDeatilVO> map = new HashMap<>();
        HashMap<String, String> diffMap = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    StringBuffer errorBuffer = new StringBuffer();

                    String listingCode = datas.get(0);//清单编码
                    String partProjectName = datas.get(1);//分部分项工程名称
                    String units = datas.get(2);//单位
                    String quantities = datas.get(3);//工程量
                    String calculationProcess = datas.get(4);//计算过程
                    String gist = datas.get(5);//依据
                    String source = datas.get(6);//来源

                    SettlementBookQuantityBasDeatilVO quantityBasDeatilVO = new SettlementBookQuantityBasDeatilVO();
                    quantityBasDeatilVO.setId(IdWorker.getId());//id
                    quantityBasDeatilVO.setSort(Long.valueOf(i));
                    quantityBasDeatilVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    quantityBasDeatilVO.setUnits(units);//单位

                    //必填项校验
                    if (StringUtils.isBlank(listingCode)) {
                        quantityBasDeatilVO.setErrorMsg("'清单编码'不能为空");
                        errorBuffer.append("'清单编码'不能为空");
                    } else {
                        quantityBasDeatilVO.setListingCode(listingCode);
                    }

                    if (StringUtils.isBlank(partProjectName)) {
                        quantityBasDeatilVO.setErrorMsg("'分部分项工程名称'不能为空");
                        errorBuffer.append("'分部分项工程名称'不能为空");
                    } else {
                        quantityBasDeatilVO.setPartProjectName(partProjectName);
                    }

                    if (StringUtils.isBlank(quantities)) {
                        quantityBasDeatilVO.setErrorMsg("'工程量'不能为空");
                        errorBuffer.append("'工程量'不能为空");
                    } else {
                        if (!NumberUtil.isNumber(quantities)) {
                            quantityBasDeatilVO.setErrorMsg("'工程量'格式错误");
                            errorBuffer.append("'工程量'格式错误");
                        } else {
                            quantityBasDeatilVO.setQuantities(new BigDecimal(quantities));
                        }
                    }

                    if (StringUtils.isBlank(calculationProcess)) {
                        quantityBasDeatilVO.setErrorMsg("'计算过程'不能为空");
                        errorBuffer.append("'计算过程'不能为空");
                    } else {
                        quantityBasDeatilVO.setCalculationProcess(calculationProcess);
                    }

                    if (StringUtils.isBlank(gist)) {
                        quantityBasDeatilVO.setErrorMsg("'依据'不能为空");
                        errorBuffer.append("'依据'不能为空");
                    } else {
                        quantityBasDeatilVO.setGist(gist);
                    }

                    if (StringUtils.isBlank(source)) {
                        quantityBasDeatilVO.setErrorMsg("'来源'不能为空");
                        errorBuffer.append("'来源'不能为空");
                    } else {
                        if (source.equals("合同内") || source.equals("合同外")) {
                            quantityBasDeatilVO.setSource(source);
                        } else {
                            quantityBasDeatilVO.setErrorMsg("'来源'输入格式错误");
                            errorBuffer.append("'来源'输入格式错误");
                        }
                    }

                    //清单编码校验
                    if (StringUtils.isNotBlank(listingCode)) {
                        quantityBasDeatilVO.setInnercode(listingCode);//清单编号确定唯一性
                        if ("01".equals(listingCode) && partProjectName != null && partProjectName.contains("装饰")) {
                            quantityBasDeatilVO.setInnercode("a1");
                        }
                        //判断是否是装饰工程的子节点编码
                        if (listingCode.length() >= 4) {
                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                            String code = listingCode.substring(0, 4);
                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                                //若是的话，将内码改为a1xx
                                quantityBasDeatilVO.setInnercode("a1" + listingCode.substring(2, listingCode.length()));
                            }
                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (listingCode == null || !(listingCode.length() == 2 || listingCode.length() == 4 || listingCode.length() == 6 || listingCode.length() >= 9)) {
                            quantityBasDeatilVO.setErrorMsg("清单编码不符合规定格式");
                            errorBuffer.append("清单编码不符合规定格式！");
                        }
                        quantityBasDeatilVO.setListingCode(listingCode);

                        quantityBasDeatilVO.setListingCode(listingCode);
                    }

                    if("合同内".equals(source)){
                        CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(contractId, listingCode);
                        if(outcontractResp.getData() == null){
                            quantityBasDeatilVO.setErrorMsg("'清单编码'未在合同中！");
                            errorBuffer.append("'清单编码'未在合同中！");
                        }else{
                            for (int x = 0; x < outcontractResp.getData().size(); x++) {
                                List<OutcontractSubcontractUnitPriceVO> priceVOS = outcontractResp.getData();
                                if (!priceVOS.get(x).getListCode().equals(listingCode)) {
                                    quantityBasDeatilVO.setErrorMsg("'清单编码'未在合同中！");
                                    errorBuffer.append("'清单编码'未在合同中！");
                                }else {
                                    OutcontractSubcontractUnitPriceVO priceVO = priceVOS.get(0);
                                    BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();//综合单价
                                    BigDecimal tax = priceVO.getTax();//税金

                                    if(comprehensiveUnitPrice != null){
                                        if(tax != null){
                                            //合同单价除税
                                            BigDecimal extaxUnitpriceB = comprehensiveUnitPrice.subtract(tax);//综合单价-税金
                                            quantityBasDeatilVO.setExtaxUnitprice(extaxUnitpriceB);
                                        }else {
                                            quantityBasDeatilVO.setExtaxUnitprice(comprehensiveUnitPrice);
                                        }
                                    }
                                    BigDecimal intaxUnitpriceB = comprehensiveUnitPrice;//合同单价含税
                                    quantityBasDeatilVO.setIntaxUnitprice(intaxUnitpriceB);
                                    quantityBasDeatilVO.setPartProjectName(priceVOS.get(x).getProject());
                                }
                            }
                        }
                    }

                    //重复性校验
                    SettlementBookQuantityBasDeatilVO mapVO = map.get(quantityBasDeatilVO.getInnercode());
                    if (mapVO == null) {
                        if(errorBuffer.length() == 0){
                            map.put(quantityBasDeatilVO.getInnercode(), quantityBasDeatilVO);
                        }
                    } else {
                        quantityBasDeatilVO.setErrorMsg("清单编号已存在！");
                        errorBuffer.append("清单编号已存在！");
                    }

                    if (errorBuffer.length() == 0) {
                        successList.add(quantityBasDeatilVO);
                    } else {
                        errorList.add(quantityBasDeatilVO);
                    }
                }
            }
        }

        //按清单编码排序
        Collections.sort(successList, new Comparator<SettlementBookQuantityBasDeatilVO>() {
            @Override
            public int compare(SettlementBookQuantityBasDeatilVO o1, SettlementBookQuantityBasDeatilVO o2) {
                return o1.getListingCode().compareTo(o2.getListingCode());
            }
        });

        //设置tid和tpid
        List<SettlementBookQuantityBasDeatilVO> resList = setTidAndTpid(successList, map);

        //构建树
        resList = createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<SettlementBookQuantityBasDeatilVO> setTidAndTpid(List<SettlementBookQuantityBasDeatilVO> vos, Map<String, SettlementBookQuantityBasDeatilVO> map) {
        if (vos == null) {
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            SettlementBookQuantityBasDeatilVO consdrawbudgetquantityBasDeatilVO = vos.get(i);
            //设置父级id
            String innercode = consdrawbudgetquantityBasDeatilVO.getInnercode();
            //String[] innercodeSubArr = innercode.split("_");
            //String innercodeSub = "";
            //String sectionSuf = "";
          /*  if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
*/
            Long pid = null;
            if (innercode.length() == 2) {
                //最上级
            } else if (innercode.length() == 4) {
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() == 6) {
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() > 6) {
                String pcode = innercode.substring(0, 6);
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                consdrawbudgetquantityBasDeatilVO.setTpid(pid.toString());
            } else {
                consdrawbudgetquantityBasDeatilVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SettlementBookQuantityBasDeatilVO> createTreeData(List<SettlementBookQuantityBasDeatilVO> list) {
        List<SettlementBookQuantityBasDeatilVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SettlementBookQuantityBasDeatilVO> listMap = new HashMap<>();
        for (SettlementBookQuantityBasDeatilVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SettlementBookQuantityBasDeatilVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SettlementBookQuantityBasDeatilVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SettlementBookQuantityBasDeatilVO> child = (List<SettlementBookQuantityBasDeatilVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SettlementBookQuantityBasDeatilVO> children = new ArrayList<SettlementBookQuantityBasDeatilVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SettlementBookQuantityBasDeatilVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

}
